/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.controller.performance;

import com.sun.japex.JapexDriverBase;
import com.sun.japex.TestCase;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.controller.metadata.ControllerDescriptor;
import org.exoplatform.web.controller.metadata.DescriptorBuilder;
import org.exoplatform.web.controller.performance.NullAppendable;
import org.exoplatform.web.controller.router.JRegexFactory;
import org.exoplatform.web.controller.router.RegexFactory;
import org.exoplatform.web.controller.router.RenderContext;
import org.exoplatform.web.controller.router.Router;
import org.exoplatform.web.controller.router.URIWriter;
import org.json.JSONObject;

public class ControllerRendererDriver
extends JapexDriverBase {
    private RegexFactory regexFactory;
    private Router router;
    private RenderContext input;
    private URIWriter writer;

    public void initializeDriver() {
        String regexFactoryName = this.getParam("regex");
        if (regexFactoryName.equals("jregex")) {
            this.regexFactory = JRegexFactory.INSTANCE;
        } else if (regexFactoryName.equals("java")) {
            this.regexFactory = RegexFactory.JAVA;
        }
        this.regexFactory = this.regexFactory;
    }

    public void prepare(TestCase testCase) {
        try {
            URL url = ControllerRendererDriver.class.getResource("controller.xml");
            DescriptorBuilder builder = new DescriptorBuilder();
            ControllerDescriptor descriptor = builder.build(url.openStream());
            Router router = descriptor.build(this.regexFactory);
            HashMap<QualifiedName, String> input = new HashMap<QualifiedName, String>();
            String parameters = testCase.getParam("parameters");
            JSONObject o = new JSONObject(parameters);
            Iterator i = o.keys();
            while (i.hasNext()) {
                String key = (String)i.next();
                String value = (String)o.get(key);
                input.put(QualifiedName.parse((String)key), value);
            }
            if (router.render(input) == null) {
                throw new Exception("Could not render " + String.valueOf(input));
            }
            this.router = router;
            this.input = new RenderContext(input);
            this.writer = new URIWriter((Appendable)NullAppendable.INSTANCE);
        }
        catch (Exception e) {
            AssertionError afe = new AssertionError((Object)"Could not load controller configuration");
            ((Throwable)((Object)afe)).initCause(e);
            throw afe;
        }
    }

    public void run(TestCase testCase) {
        try {
            this.router.render(this.input, this.writer);
            this.writer.reset((Appendable)NullAppendable.INSTANCE);
        }
        catch (IOException e) {
            AssertionError err = new AssertionError((Object)"Unexpected IOException");
            ((Throwable)((Object)err)).initCause(e);
            throw err;
        }
    }

    public void finish(TestCase testCase) {
        this.router = null;
        this.input = null;
        this.writer = null;
    }

    public void terminateDriver() {
    }
}

