/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.controller.router;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.controller.metadata.DescriptorBuilder;
import org.exoplatform.web.controller.metadata.ParamDescriptor;
import org.exoplatform.web.controller.metadata.RouteDescriptor;
import org.exoplatform.web.controller.router.AbstractTestController;
import org.exoplatform.web.controller.router.Names;
import org.exoplatform.web.controller.router.Route;
import org.exoplatform.web.controller.router.Router;

public class TestMatch
extends AbstractTestController {
    public void testRoot() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/")}).build();
        TestMatch.assertNull((Object)router.route(""));
        TestMatch.assertEquals(Collections.emptyMap(), router.route("/"));
        TestMatch.assertNull((Object)router.route("/a"));
        TestMatch.assertNull((Object)router.route("a"));
    }

    public void testA() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/a")}).build();
        TestMatch.assertEquals(Collections.emptyMap(), router.route("/a"));
        TestMatch.assertNull((Object)router.route("a"));
        TestMatch.assertNull((Object)router.route("a/"));
        TestMatch.assertEquals(Collections.emptyMap(), router.route("/a/"));
        TestMatch.assertNull((Object)router.route(""));
        TestMatch.assertNull((Object)router.route("/"));
        TestMatch.assertNull((Object)router.route("/b"));
        TestMatch.assertNull((Object)router.route("b"));
        TestMatch.assertNull((Object)router.route("/a/b"));
    }

    public void testAB() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/a/b")}).build();
        TestMatch.assertNull((Object)router.route("a/b"));
        TestMatch.assertEquals(Collections.emptyMap(), router.route("/a/b"));
        TestMatch.assertEquals(Collections.emptyMap(), router.route("/a/b/"));
        TestMatch.assertNull((Object)router.route("a/b/"));
        TestMatch.assertNull((Object)router.route(""));
        TestMatch.assertNull((Object)router.route("/"));
        TestMatch.assertNull((Object)router.route("/b"));
        TestMatch.assertNull((Object)router.route("b"));
        TestMatch.assertNull((Object)router.route("/a/b/c"));
    }

    public void testParameter() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/{p}")}).build();
        TestMatch.assertEquals(Collections.singletonMap(Names.P, "a"), router.route("/a"));
    }

    public void testParameterPropagationToDescendants() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/").with(new ParamDescriptor[]{DescriptorBuilder.routeParam((String)"p").withValue("a")}).sub(DescriptorBuilder.route((String)"/a"))}).build();
        TestMatch.assertEquals(Collections.singletonMap(Names.P, "a"), router.route("/a"));
    }

    public void testSimplePattern() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/{p}").with(new ParamDescriptor[]{DescriptorBuilder.pathParam((String)"p").matchedBy("a")})}).build();
        TestMatch.assertEquals(Collections.singletonMap(Names.P, "a"), router.route("/a"));
        TestMatch.assertNull((Object)router.route("a"));
        TestMatch.assertNull((Object)router.route("/ab"));
        TestMatch.assertNull((Object)router.route("ab"));
    }

    public void testPrecedence() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/a")}).add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/{p}/b").with(new ParamDescriptor[]{DescriptorBuilder.pathParam((String)"p").matchedBy("a")})}).build();
        TestMatch.assertNull((Object)router.route("a"));
        TestMatch.assertEquals(Collections.emptyMap(), router.route("/a"));
        TestMatch.assertEquals(Collections.emptyMap(), router.route("/a/"));
        TestMatch.assertEquals(Collections.singletonMap(Names.P, "a"), router.route("/a/b"));
    }

    public void testTwoRules1() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/a").with(new ParamDescriptor[]{DescriptorBuilder.routeParam((String)"b").withValue("b")})}).add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/a/b")}).build();
        TestMatch.assertEquals(Collections.singletonMap(Names.B, "b"), router.route("/a"));
        TestMatch.assertEquals(Collections.emptyMap(), router.route("/a/b"));
    }

    public void testTwoRules2() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/{a}").with(new ParamDescriptor[]{DescriptorBuilder.routeParam((String)"b").withValue("b")})}).add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/{a}/b")}).build();
        HashMap<QualifiedName, String> expectedParameters = new HashMap<QualifiedName, String>();
        expectedParameters.put(Names.A, "a");
        expectedParameters.put(Names.B, "b");
        TestMatch.assertEquals(expectedParameters, router.route("/a"));
        TestMatch.assertEquals(Collections.singletonMap(Names.A, "a"), router.route("/a/b"));
    }

    public void testLang() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/{a}b").with(new ParamDescriptor[]{DescriptorBuilder.pathParam((String)"a").matchedBy("(([A-Za-z]{2})/)?").preservePath()})}).build();
        TestMatch.assertEquals(Collections.singletonMap(Names.A, "fr/"), router.route("/fr/b"));
        TestMatch.assertEquals(Collections.singletonMap(Names.A, ""), router.route("/b"));
    }

    public void testOptionalParameter() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/{a}/b").with(new ParamDescriptor[]{DescriptorBuilder.pathParam((String)"a").matchedBy("a?").preservePath(), DescriptorBuilder.routeParam((String)"b").withValue("b")})}).build();
        HashMap<QualifiedName, String> expectedParameters = new HashMap<QualifiedName, String>();
        expectedParameters.put(Names.A, "a");
        expectedParameters.put(Names.B, "b");
        TestMatch.assertEquals(expectedParameters, router.route("/a/b"));
        TestMatch.assertEquals((String)"/a/b", (String)router.render(expectedParameters));
        expectedParameters.put(Names.A, "");
        TestMatch.assertEquals(expectedParameters, router.route("/b"));
        TestMatch.assertEquals((String)"/b", (String)router.render(expectedParameters));
    }

    public void testAvoidMatchingPrefix() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/{a}/ab/c").with(new ParamDescriptor[]{DescriptorBuilder.pathParam((String)"a").matchedBy("a?").preservePath()})}).build();
        HashMap<QualifiedName, String> expectedParameters = new HashMap<QualifiedName, String>();
        expectedParameters.put(Names.A, "");
        TestMatch.assertEquals(expectedParameters, router.route("/ab/c"));
        TestMatch.assertEquals((String)"/ab/c", (String)router.render(expectedParameters));
    }

    public void testPartialMatching() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/{a}").with(new ParamDescriptor[]{DescriptorBuilder.pathParam((String)"a").matchedBy("abc").preservePath()})}).build();
        TestMatch.assertNull((Object)router.route("/abcdef"));
    }

    public void testZeroOrOneFollowedBySubRoute() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/{a}").with(new ParamDescriptor[]{DescriptorBuilder.pathParam((String)"a").matchedBy("a?").preservePath()}).sub(DescriptorBuilder.route((String)"/b").with(new ParamDescriptor[]{DescriptorBuilder.routeParam((String)"b").withValue("b")}))}).build();
        HashMap<QualifiedName, String> expectedParameters = new HashMap<QualifiedName, String>();
        expectedParameters.put(Names.A, "a");
        expectedParameters.put(Names.B, "b");
        TestMatch.assertEquals(expectedParameters, router.route("/a/b"));
        TestMatch.assertEquals((String)"/a/b", (String)router.render(expectedParameters));
        expectedParameters.put(Names.A, "");
        TestMatch.assertEquals(expectedParameters, router.route("/b"));
        TestMatch.assertEquals((String)"/b", (String)router.render(expectedParameters));
    }

    public void testMatcher() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/{a}")}).add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/a").with(new ParamDescriptor[]{DescriptorBuilder.routeParam((String)"b").withValue("b_value")})}).build();
        Route.RouteMatcher i = router.root.route("/a", Collections.emptyMap());
        Map s1 = (Map)i.next();
        TestMatch.assertEquals(Collections.singletonMap(Names.A, "a"), s1);
        Map s2 = (Map)i.next();
        TestMatch.assertEquals(Collections.singletonMap(Names.B, "b_value"), s2);
        TestMatch.assertFalse((boolean)i.hasNext());
    }

    public void testDisjunction() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/{a}{b}").with(new ParamDescriptor[]{DescriptorBuilder.pathParam((String)"a").matchedBy("a|b")})}).build();
        HashMap<QualifiedName, String> expectedParameters = new HashMap<QualifiedName, String>();
        expectedParameters.put(Names.A, "a");
        expectedParameters.put(Names.B, "c");
        Route.RouteMatcher i = router.root.route("/ac", Collections.emptyMap());
        Map s1 = (Map)i.next();
        TestMatch.assertEquals(expectedParameters, s1);
        TestMatch.assertFalse((boolean)i.hasNext());
        i = router.root.route("/bc", Collections.emptyMap());
        s1 = (Map)i.next();
        expectedParameters.put(Names.A, "b");
        TestMatch.assertEquals(expectedParameters, s1);
        TestMatch.assertFalse((boolean)i.hasNext());
    }

    public void testCaptureGroup() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/{a}").with(new ParamDescriptor[]{DescriptorBuilder.pathParam((String)"a").matchedBy("a(.)c").captureGroup(true)})}).build();
        Route.RouteMatcher i = router.root.route("/abc", Collections.emptyMap());
        Map s1 = (Map)i.next();
        TestMatch.assertEquals(Collections.singletonMap(Names.A, "b"), s1);
        TestMatch.assertFalse((boolean)i.hasNext());
    }
}

