/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.resource;

import java.net.MalformedURLException;
import java.util.Arrays;
import org.exoplatform.portal.resource.AbstractSkinServiceTest;
import org.exoplatform.portal.resource.Skin;
import org.exoplatform.portal.resource.SkinConfig;
import org.exoplatform.portal.resource.SkinURL;
import org.exoplatform.services.resources.Orientation;
import org.exoplatform.web.controller.metadata.DescriptorBuilder;
import org.exoplatform.web.controller.metadata.ParamDescriptor;
import org.exoplatform.web.controller.metadata.RouteDescriptor;
import org.exoplatform.web.controller.router.Router;
import org.exoplatform.web.controller.router.RouterConfigException;

public class TestSkinService
extends AbstractSkinServiceTest {
    private static boolean isFirstStartup = true;

    @Override
    boolean isDevelopingMode() {
        return false;
    }

    @Override
    boolean setUpTestEnvironment() {
        return isFirstStartup;
    }

    @Override
    Router getRouter() {
        try {
            Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/skins/{gtn:version}/{gtn:resource}{gtn:compress}{gtn:orientation}.css").with(new ParamDescriptor[]{DescriptorBuilder.routeParam((String)"gtn:handler").withValue("skin")}).with(new ParamDescriptor[]{DescriptorBuilder.pathParam((String)"gtn:version").matchedBy("[^/]*").preservePath()}).with(new ParamDescriptor[]{DescriptorBuilder.pathParam((String)"gtn:orientation").matchedBy("-(lt)|-(rt)|").captureGroup(true)}).with(new ParamDescriptor[]{DescriptorBuilder.pathParam((String)"gtn:compress").matchedBy("-(min)|").captureGroup(true)}).with(new ParamDescriptor[]{DescriptorBuilder.pathParam((String)"gtn:resource").matchedBy(".+?").preservePath()})}).build();
            return router;
        }
        catch (RouterConfigException e) {
            return null;
        }
    }

    @Override
    void touchSetUp() {
        isFirstStartup = false;
    }

    public void testRenderURL() {
        SkinURL skinURL = this.skinService.getSkin("mockwebapp/FirstPortlet", "TestSkin").createURL(this.controllerCtx);
        TestSkinService.assertEquals((String)"/portal/skins/PORTAL-VERSION/mockwebapp/skin/FirstPortlet-min-lt.css", (String)skinURL.toString());
        skinURL.setOrientation(Orientation.RT);
        TestSkinService.assertEquals((String)"/portal/skins/PORTAL-VERSION/mockwebapp/skin/FirstPortlet-min-rt.css", (String)skinURL.toString());
    }

    public void testCompositeSkin() throws NullPointerException, MalformedURLException {
        SkinConfig fSkin = this.skinService.getSkin("mockwebapp/FirstPortlet", "TestSkin");
        SkinConfig sSkin = this.skinService.getSkin("mockwebapp/SecondPortlet", "TestSkin");
        TestSkinService.assertNotNull((Object)fSkin);
        TestSkinService.assertNotNull((Object)sSkin);
        Skin merged = this.skinService.merge(Arrays.asList(fSkin, sSkin));
        SkinURL url = merged.createURL(this.controllerCtx);
        url.setOrientation(Orientation.LT);
        TestSkinService.assertEquals((String)".FirstPortlet {foo1 : bar1}\n.SecondPortlet {foo2 : bar2}", (String)this.skinService.getCSS(TestSkinService.newControllerContext(this.getRouter(), url.toString()), true));
        url.setOrientation(Orientation.RT);
        TestSkinService.assertEquals((String)".FirstPortlet {foo1 : bar1}\n.SecondPortlet {foo2 : bar2}", (String)this.skinService.getCSS(TestSkinService.newControllerContext(this.getRouter(), url.toString()), true));
    }

    public void testCache() throws Exception {
        String resource = "/path/to/test/cache.css";
        String url = this.newSimpleSkin(resource).createURL(this.controllerCtx).toString();
        resResolver.addResource(resource, "foo");
        TestSkinService.assertEquals((String)"foo", (String)this.skinService.getCSS(TestSkinService.newControllerContext(this.getRouter(), url), true));
        resResolver.addResource(resource, "bar");
        TestSkinService.assertEquals((String)"foo", (String)this.skinService.getCSS(TestSkinService.newControllerContext(this.getRouter(), url), true));
    }

    public void testInvalidateCache() throws Exception {
        String resource = "/path/to/test/invalidate/cache.css";
        String url = this.newSimpleSkin(resource).createURL(this.controllerCtx).toString();
        resResolver.addResource(resource, "foo");
        TestSkinService.assertEquals((String)"foo", (String)this.skinService.getCSS(TestSkinService.newControllerContext(this.getRouter(), url), true));
        resResolver.addResource(resource, "bar");
        this.skinService.invalidateCachedSkin(resource);
        TestSkinService.assertEquals((String)"bar", (String)this.skinService.getCSS(TestSkinService.newControllerContext(this.getRouter(), url), true));
    }

    public void testProcessImportCSS() throws Exception {
        String resource = "/process/import/css.css";
        String url = this.newSimpleSkin(resource).createURL(this.controllerCtx).toString();
        resResolver.addResource(resource, "@import url(Portlet/Stylesheet.css); aaa;");
        TestSkinService.assertEquals((String)" aaa;", (String)this.skinService.getCSS(TestSkinService.newControllerContext(this.getRouter(), url), true));
        this.skinService.invalidateCachedSkin(resource);
        resResolver.addResource(resource, "@import url('/Portlet/Stylesheet.css'); aaa;");
        TestSkinService.assertEquals((String)" aaa;", (String)this.skinService.getCSS(TestSkinService.newControllerContext(this.getRouter(), url), true));
        this.skinService.invalidateCachedSkin(resource);
        resResolver.addResource(resource, "@import url(childCSS/child.css);  background:url(images/foo.gif);");
        String childResource = "/process/import/childCSS/child.css";
        resResolver.addResource(childResource, "background:url(bar.gif);");
        TestSkinService.assertEquals((String)"background:url(/process/import/childCSS/bar.gif);  background:url(/process/import/images/foo.gif);", (String)this.skinService.getCSS(TestSkinService.newControllerContext(this.getRouter(), url), true));
        url = this.newSimpleSkin(childResource).createURL(this.controllerCtx).toString();
        TestSkinService.assertEquals((String)"background:url(/process/import/childCSS/bar.gif);", (String)this.skinService.getCSS(TestSkinService.newControllerContext(this.getRouter(), url), true));
    }

    public void testProcessImportWithUnicodeCssChar() throws Exception {
        String childResource = "/process/import/childCSS/child.css";
        resResolver.addResource(childResource, "#test:after {content: \"\\00a0 \\003e \\00a0\";}");
        String resource = "/process/import/css.css";
        String url = this.newSimpleSkin(resource).createURL(this.controllerCtx).toString();
        resResolver.addResource(resource, "@import url(childCSS/child.css); aaa;");
        String css = this.skinService.getCSS(TestSkinService.newControllerContext(this.getRouter(), url), true);
        TestSkinService.assertEquals((String)"#test:after {content: \"\\00a0 \\003e \\00a0\";} aaa;", (String)css);
        this.skinService.invalidateCachedSkin(resource);
    }

    public void testLastModifiedSince() throws Exception {
        String resource = "/last/modify/since.css";
        SkinURL skinURL = this.newSimpleSkin(resource).createURL(this.controllerCtx);
        resResolver.addResource(resource, "foo");
        TestSkinService.assertTrue((this.skinService.getCSS(TestSkinService.newControllerContext(this.getRouter(), skinURL.toString()), true).length() > 0 ? 1 : 0) != 0);
        long lastModified = this.skinService.getLastModified(TestSkinService.newControllerContext(this.getRouter(), skinURL.toString()));
        Thread.sleep(1000L);
        TestSkinService.assertEquals((long)lastModified, (long)this.skinService.getLastModified(TestSkinService.newControllerContext(this.getRouter(), skinURL.toString())));
        skinURL.setOrientation(Orientation.RT);
        Thread.sleep(1000L);
        TestSkinService.assertTrue((lastModified < this.skinService.getLastModified(TestSkinService.newControllerContext(this.getRouter(), skinURL.toString())) ? 1 : 0) != 0);
    }
}

