/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.portal.controller.resource.script;

import jakarta.servlet.ServletContext;
import java.io.File;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.exoplatform.commons.utils.MapResourceBundle;
import org.exoplatform.component.test.AbstractGateInTest;
import org.exoplatform.component.test.web.ServletContextImpl;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.resources.ResourceBundleService;
import org.gatein.common.io.IOTools;
import org.gatein.portal.controller.resource.ResourceScope;
import org.gatein.portal.controller.resource.script.Module;
import org.gatein.portal.controller.resource.script.ScriptGraph;
import org.gatein.portal.controller.resource.script.ScriptResource;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TestModule
extends AbstractGateInTest {
    private ServletContext servletContext;
    @Mock
    private PortalContainer portalContainer;
    @Mock
    private ResourceBundleService resourceBundleService;
    public static final ResourceBundle.Control CONTROL = new ResourceBundle.Control(){

        @Override
        public Locale getFallbackLocale(String baseName, Locale locale) {
            return locale.equals(Locale.ENGLISH) ? null : Locale.ENGLISH;
        }
    };
    private ClassLoader classLoader;

    @Before
    public void setUp() throws Exception {
        ExoContainerContext.setCurrentContainer((ExoContainer)this.portalContainer);
        MapResourceBundle resourceBundle = new MapResourceBundle(Locale.getDefault());
        resourceBundle.add("foo", (Object)"foo_en");
        MapResourceBundle resourceBundle1 = new MapResourceBundle(Locale.getDefault());
        resourceBundle1.add("foo", (Object)"foo_en");
        MapResourceBundle resourceBundle2 = new MapResourceBundle(Locale.getDefault());
        resourceBundle2.add("foo", (Object)"foo_en");
        MapResourceBundle resourceBundle3 = new MapResourceBundle(Locale.getDefault());
        resourceBundle3.add("foo", (Object)"foo_fr_FR");
        MapResourceBundle resourceBundle4 = new MapResourceBundle(Locale.getDefault());
        resourceBundle4.add("foo", (Object)"\"");
        MapResourceBundle resourceBundle5 = new MapResourceBundle(Locale.getDefault());
        resourceBundle5.add("foo", (Object)"'");
        MapResourceBundle resourceBundle6 = new MapResourceBundle(Locale.getDefault());
        resourceBundle6.add("foo", (Object)"foo_fr");
        Mockito.lenient().when((Object)this.resourceBundleService.getResourceBundle(Mockito.anyString(), (Locale)Mockito.any(), (ClassLoader)Mockito.any())).thenReturn((Object)resourceBundle, (Object[])new ResourceBundle[]{resourceBundle1, resourceBundle2, resourceBundle3, resourceBundle4, resourceBundle5, resourceBundle6});
        Mockito.lenient().when((Object)((ResourceBundleService)this.portalContainer.getComponentInstanceOfType(ResourceBundleService.class))).thenReturn((Object)this.resourceBundleService);
        URL classesURL = TestModule.class.getResource("");
        TestModule.assertNotNull((Object)classesURL);
        File classes = new File(classesURL.toURI());
        TestModule.assertTrue((boolean)classes.exists());
        TestModule.assertTrue((boolean)classes.isDirectory());
        URLClassLoader classLoader = new URLClassLoader(new URL[]{new File(classes, "WEB-INF/classes").toURI().toURL()}, ClassLoader.getSystemClassLoader());
        ResourceBundle bundle = ResourceBundle.getBundle("bundle", Locale.ENGLISH, classLoader, CONTROL);
        TestModule.assertNotNull((Object)bundle);
        ServletContextImpl servletContext = new ServletContextImpl(TestModule.class, "/webapp", "webapp");
        TestModule.assertNotNull((Object)servletContext.getResource("/simple.js"));
        this.servletContext = servletContext;
        this.classLoader = classLoader;
    }

    @After
    public void tearDown() throws Exception {
        ExoContainerContext.setCurrentContainer(null);
    }

    @Test
    public void testScriptServing() throws Exception {
        ScriptGraph graph = new ScriptGraph();
        ScriptResource module = graph.addResource(ResourceScope.SHARED.create("testModule"));
        Module.Local bar = module.addLocalModule("/webapp", "/simple.js", null, 0);
        Reader reader = bar.read(null, this.servletContext, this.classLoader);
        this.assertReader("pass", reader);
    }

    @Test
    public void testScriptNotFound() throws Exception {
        ScriptGraph graph = new ScriptGraph();
        ScriptResource module = graph.addResource(ResourceScope.SHARED.create("testModule"));
        Module.Local bar = module.addLocalModule("/webapp", "/notfound.js", null, 0);
        TestModule.assertNull((Object)bar.read(null, this.servletContext, this.classLoader));
    }

    @Test
    public void testResolveNotLocalized() throws Exception {
        ScriptGraph graph = new ScriptGraph();
        ScriptResource foo = graph.addResource(ResourceScope.SHARED.create("testModule"));
        Module.Local module = foo.addLocalModule("/webapp", "/localized.js", null, 0);
        Reader reader = module.read(null, this.servletContext, this.classLoader);
        this.assertReader("${foo}", reader);
    }

    @Test
    public void testEscapeDoubleQuote() throws Exception {
        ScriptGraph graph = new ScriptGraph();
        ScriptResource foo = graph.addResource(ResourceScope.SHARED.create("testModule"));
        Module.Local module = foo.addLocalModule("/webapp", "/localized.js", "double_quote_bundle", 0);
        Reader reader = module.read(Locale.ENGLISH, this.servletContext, this.classLoader);
        this.assertReader("\"", reader);
    }

    @Test
    public void testEscapeSimpleQuote() throws Exception {
        ScriptGraph graph = new ScriptGraph();
        ScriptResource foo = graph.addResource(ResourceScope.SHARED.create("testModule"));
        Module.Local module = foo.addLocalModule("/webapp", "/localized.js", "simple_quote_bundle", 0);
        Reader reader = module.read(Locale.ENGLISH, this.servletContext, this.classLoader);
        this.assertReader("'", reader);
    }

    @Test
    public void testEnglishAsDefaultLocale() throws Exception {
        ScriptGraph graph = new ScriptGraph();
        ScriptResource foo = graph.addResource(ResourceScope.SHARED.create("testModule"));
        Module.Local module = foo.addLocalModule("/webapp", "/localized.js", "bundle", 0);
        Reader reader = module.read(null, this.servletContext, this.classLoader);
        this.assertReader("foo_en", reader);
    }

    @Test
    public void testEnglishAsFallbackLocale() throws Exception {
        ScriptGraph graph = new ScriptGraph();
        ScriptResource foo = graph.addResource(ResourceScope.SHARED.create("testModule"));
        Module.Local module = foo.addLocalModule("/webapp", "/localized.js", "bundle", 0);
        Reader reader = module.read(Locale.CANADA, this.servletContext, this.classLoader);
        this.assertReader("foo_en", reader);
    }

    @Test
    public void testSpecificLanguage() throws Exception {
        ScriptGraph graph = new ScriptGraph();
        ScriptResource foo = graph.addResource(ResourceScope.SHARED.create("testModule"));
        Module.Local module = foo.addLocalModule("/webapp", "/localized.js", "bundle", 0);
        Reader reader = module.read(Locale.FRENCH, this.servletContext, this.classLoader);
        this.assertReader("foo_fr", reader);
    }

    @Test
    public void testSpecificCountry() throws Exception {
        ScriptGraph graph = new ScriptGraph();
        ScriptResource foo = graph.addResource(ResourceScope.SHARED.create("testModule"));
        Module.Local module = foo.addLocalModule("/webapp", "/localized.js", "bundle", 0);
        Reader reader = module.read(Locale.FRANCE, this.servletContext, this.classLoader);
        this.assertReader("foo_fr_FR", reader);
    }

    @Test
    public void testAdapter() throws Exception {
        ScriptGraph graph = new ScriptGraph();
        ScriptResource foo = graph.addResource(ResourceScope.SHARED.create("testModule"));
        Module.Local.Content[] contents = new Module.Local.Content[]{new Module.Local.Content("var a;", false), new Module.Local.Content("/localized.js"), new Module.Local.Content("var b;", false)};
        Module.Local module = foo.addLocalModule("/webapp", contents, "bundle", 0);
        Reader reader = module.read(Locale.ENGLISH, this.servletContext, this.classLoader);
        this.assertReader("foo_en", reader);
    }

    private void assertReader(Object expected, Reader reader) {
        try {
            TestModule.assertNotNull((Object)reader);
            StringWriter script = new StringWriter();
            IOTools.copy((Reader)reader, (Writer)script);
            ScriptEngineManager mgr = new ScriptEngineManager();
            ScriptEngine engine = mgr.getEngineByName("JavaScript");
            engine.eval(script.toString());
            Object test = engine.get("test");
            TestModule.assertEquals((Object)expected, (Object)test);
        }
        catch (Exception e) {
            throw TestModule.failure((Throwable)e);
        }
    }
}

