/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.resource.config.tasks;

import jakarta.servlet.ServletContext;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.portal.resource.SkinDependentManager;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.portal.resource.config.tasks.AbstractSkinModule;
import org.exoplatform.portal.resource.config.tasks.SkinConfigTask;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PortletSkinTask
extends AbstractSkinModule
implements SkinConfigTask {
    private String applicationName;
    private String portletName;
    private List<String> additionalModules;

    public PortletSkinTask() {
        super(null);
        this.overwrite = true;
    }

    private void bindingApplicationName(Element element) {
        NodeList nodes = element.getElementsByTagName("application-name");
        if (nodes == null || nodes.getLength() < 1) {
            return;
        }
        String applicationName = nodes.item(0).getFirstChild().getNodeValue();
        this.setApplicationName(applicationName);
    }

    private void bindingPortletName(Element element) {
        NodeList nodes = element.getElementsByTagName("portlet-name");
        if (nodes == null || nodes.getLength() < 1) {
            return;
        }
        String portletName = nodes.item(0).getFirstChild().getNodeValue();
        this.setPortletName(portletName);
    }

    protected void bindingAdditionalModules(Element element) {
        NodeList nodes = element.getElementsByTagName("additional-module");
        if (nodes == null || nodes.getLength() == 0) {
            return;
        }
        int length = nodes.getLength();
        ArrayList<String> filteredPortalModuleNames = new ArrayList<String>();
        for (int i = 0; i < length; ++i) {
            filteredPortalModuleNames.add(nodes.item(i).getFirstChild().getNodeValue());
        }
        this.setAdditionalModules(filteredPortalModuleNames);
    }

    public void setApplicationName(String _applicationName) {
        this.applicationName = _applicationName;
    }

    public void setPortletName(String _portletName) {
        this.portletName = _portletName;
    }

    @Override
    public void execute(SkinService skinService, ServletContext scontext) {
        int priority;
        if (this.portletName == null) {
            return;
        }
        if (this.skinName == null) {
            this.skinName = skinService.getDefaultSkin();
        }
        if (this.applicationName == null) {
            this.applicationName = scontext.getContextPath();
        }
        String moduleName = this.applicationName + "/" + this.portletName;
        String contextPath = scontext.getContextPath();
        String fullCSSPath = this.cssPath == null ? null : contextPath + this.cssPath;
        try {
            priority = Integer.valueOf(this.cssPriority);
        }
        catch (Exception e) {
            priority = Integer.MAX_VALUE;
        }
        skinService.addSkin(moduleName, this.skinName, fullCSSPath, priority, this.overwrite, this.additionalModules);
        this.updateSkinDependentManager(contextPath, moduleName, this.skinName);
    }

    private void updateSkinDependentManager(String webApp, String moduleName, String skinName) {
        SkinDependentManager.addPortletSkin(webApp, moduleName, skinName);
        SkinDependentManager.addSkinDeployedInApp(webApp, skinName);
    }

    @Override
    public void binding(Element elemt) {
        this.bindingApplicationName(elemt);
        this.bindingPortletName(elemt);
        this.bindingCSSPath(elemt);
        this.bindingSkinName(elemt);
        this.bindingOverwrite(elemt);
        this.bindingCSSPriority(elemt);
        this.bindingAdditionalModules(elemt);
    }

    public List<String> getAdditionalModules() {
        return this.additionalModules;
    }

    public void setAdditionalModules(List<String> additionalModules) {
        this.additionalModules = additionalModules;
    }
}

