/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.portal.controller.resource;

import com.google.javascript.jscomp.AbstractCommandLineRunner;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.ErrorManager;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.LoggerErrorManager;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.SourceFile;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.commons.utils.CharsetTextEncoder;
import org.exoplatform.commons.utils.CompositeReader;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.commons.utils.TextEncoder;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.javascript.JavascriptConfigService;
import org.gatein.common.io.IOTools;
import org.gatein.portal.controller.resource.ResourceRequestHandler;
import org.gatein.portal.controller.resource.ScriptContent;
import org.gatein.portal.controller.resource.ScriptKey;

public class ScriptLoader
implements Loader<ScriptKey, ScriptContent, Object> {
    private static final boolean DEVELOPPING = PropertyManager.isDevelopping();
    private static final String ERROR_MINIFYING_MODULE_MESSAGE = "Error while minifying module, retrieve it as is";
    protected static final Log LOG = ExoLogger.getLogger(ScriptLoader.class);
    private Map<Integer, File> files = new ConcurrentHashMap<Integer, File>();
    private Map<Integer, Integer> hashes = new ConcurrentHashMap<Integer, Integer>();

    public ScriptContent retrieve(Object context, ScriptKey key) throws Exception {
        if (DEVELOPPING) {
            byte[] fileContentBytes = this.getFileContent(key);
            return new ScriptContent(fileContentBytes, 0L);
        }
        File jsFile = this.files.computeIfAbsent(key.hashCode(), k -> this.cacheFileContent(key));
        if (jsFile == null) {
            this.files.remove(key.hashCode());
            return null;
        }
        return new ScriptContent(jsFile, (long)this.hashes.get(key.hashCode()).intValue());
    }

    private File cacheFileContent(ScriptKey key) {
        byte[] fileContentBytes = this.getFileContent(key);
        if (fileContentBytes.length == 0) {
            return null;
        }
        this.hashes.put(key.hashCode(), Arrays.hashCode(fileContentBytes));
        String name = key.getId().getName();
        if (name.indexOf("/") >= 0) {
            name = name.substring(name.lastIndexOf("/") + 1);
        }
        File file = File.createTempFile("javascript_cache_", name + ".js");
        FileUtils.writeByteArrayToFile((File)file, (byte[])fileContentBytes);
        file.deleteOnExit();
        return file;
    }

    private byte[] getFileContent(ScriptKey key) throws Exception {
        CompositeReader script = ((JavascriptConfigService)ExoContainerContext.getService(JavascriptConfigService.class)).getCompositeScript(key.id, key.locale);
        String sourceName = String.valueOf((Object)key.id.getScope()) + "/" + key.id.getName() + ".js";
        if (script == null) {
            return new byte[0];
        }
        CompositeReader result = null;
        if (key.minified) {
            ArrayList<Reader> minifiedReaders = new ArrayList<Reader>();
            if (CompositeReader.isMinify((Reader)script)) {
                String errorMessage = this.minify(sourceName, (Reader)script, minifiedReaders);
                if (errorMessage != null) {
                    LOG.warn(ERROR_MINIFYING_MODULE_MESSAGE, new Object[]{sourceName, errorMessage});
                    result = script;
                }
            } else {
                List readers = script.getCompounds();
                for (Reader reader : readers) {
                    if (CompositeReader.isMinify((Reader)reader)) {
                        String errorMessage = this.minify(sourceName, reader, minifiedReaders);
                        if (errorMessage == null) continue;
                        LOG.warn(ERROR_MINIFYING_MODULE_MESSAGE, new Object[]{sourceName, errorMessage});
                        result = script;
                        break;
                    }
                    minifiedReaders.add(reader);
                }
            }
            if (result == null) {
                result = new CompositeReader(minifiedReaders);
            }
        } else {
            result = script;
        }
        try {
            byte[] byArray;
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                TextEncoder encoder = CharsetTextEncoder.getUTF8();
                char[] buffer = new char[256];
                int l = result.read(buffer);
                while (l != -1) {
                    encoder.encode(buffer, 0, l, (OutputStream)out);
                    l = result.read(buffer);
                }
                byArray = out.toByteArray();
            }
            return byArray;
        }
        finally {
            result.close();
        }
    }

    private String minify(String sourceName, Reader reader, List<Reader> minifiedReaders) throws IOException {
        CompilationLevel level = CompilationLevel.SIMPLE_OPTIMIZATIONS;
        CompilerOptions options = new CompilerOptions();
        options.setWarningLevel(DiagnosticGroups.NON_STANDARD_JSDOC, CheckLevel.OFF);
        options.setStrictModeInput(false);
        options.setLanguageIn(CompilerOptions.LanguageMode.ECMASCRIPT_2021);
        options.setLanguageOut(CompilerOptions.LanguageMode.ECMASCRIPT5);
        options.setExternExports(true);
        level.setOptionsForCompilationLevel(options);
        StringWriter code = new StringWriter();
        IOTools.copy((Reader)reader, (Writer)code);
        SourceFile[] inputs = new SourceFile[]{SourceFile.fromCode((String)sourceName, (String)code.toString())};
        Compiler compiler = new Compiler();
        compiler.setErrorManager((ErrorManager)new LoggerErrorManager(Logger.getLogger(ResourceRequestHandler.class.getName())));
        Result res = compiler.compile(AbstractCommandLineRunner.getBuiltinExterns((CompilerOptions.Environment)CompilerOptions.Environment.BROWSER), Arrays.asList(inputs), options);
        if (res.success) {
            minifiedReaders.add(new StringReader(compiler.toSource()));
            return null;
        }
        StringBuilder msg = new StringBuilder("Handle me gracefully JS errors\n");
        for (JSError error : res.errors) {
            msg.append(error.getSourceName()).append(":").append(error.getLineNumber()).append(" ").append(error.getDescription()).append("\n");
        }
        return msg.toString();
    }

    public Map<Integer, File> getFiles() {
        return this.files;
    }
}

