/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.portal.controller.resource;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.http.HttpServletResponse;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.application.ResourceRequestFilter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.WebRequestHandler;
import org.exoplatform.web.application.javascript.JavascriptConfigService;
import org.exoplatform.web.controller.QualifiedName;
import org.gatein.portal.controller.resource.ResourceScope;
import org.gatein.portal.controller.resource.ScriptContent;
import org.gatein.wci.ServletContainerFactory;
import org.gatein.wci.WebAppEvent;
import org.gatein.wci.WebAppListener;

@Deprecated
public class ResourceRequestHandler
extends WebRequestHandler
implements WebAppListener {
    private static final Log LOG = ExoLogger.getLogger(ResourceRequestHandler.class);
    public static final String HANDLER_NAME = "script";
    public static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String LAST_MODIFIED = "Last-Modified";
    public static final QualifiedName VERSION_QN = QualifiedName.create((String)"gtn", (String)"version");
    public static final QualifiedName RESOURCE_QN = QualifiedName.create((String)"gtn", (String)"resource");
    public static final QualifiedName SCOPE_QN = QualifiedName.create((String)"gtn", (String)"scope");
    public static final QualifiedName COMPRESS_QN = QualifiedName.create((String)"gtn", (String)"compress");
    public static final QualifiedName ORIENTATION_QN = QualifiedName.create((String)"gtn", (String)"orientation");
    public static final QualifiedName LANG_QN = QualifiedName.create((String)"gtn", (String)"lang");
    public static long MAX_AGE = ResourceRequestFilter.maxAge;
    public static String VERSION = ResourceRequestFilter.version;

    public String getHandlerName() {
        return HANDLER_NAME;
    }

    public boolean execute(ControllerContext context) throws Exception {
        HttpServletResponse response = context.getResponse();
        String resourceParam = context.getParameter(RESOURCE_QN);
        String scopeParam = context.getParameter(SCOPE_QN);
        if (scopeParam != null && resourceParam != null) {
            String compressParam = context.getParameter(COMPRESS_QN);
            ScriptContent script = ((JavascriptConfigService)ExoContainerContext.getService(JavascriptConfigService.class)).getScriptContent(ResourceScope.valueOf(scopeParam), resourceParam, "true".equals(compressParam));
            if (script == null) {
                response.sendError(404);
            } else {
                byte[] bytes = script.getContentAsBytes();
                response.setContentType("text/javascript");
                response.setContentLength(bytes.length);
                response.setHeader("Cache-Control", "public, " + MAX_AGE);
                response.setDateHeader(LAST_MODIFIED, System.currentTimeMillis());
                response.setDateHeader("Expires", System.currentTimeMillis() + MAX_AGE * 1000L);
                PrintWriter writer = response.getWriter();
                IOUtils.write((byte[])bytes, (Writer)writer, (Charset)StandardCharsets.UTF_8);
                writer.close();
            }
        } else {
            String msg = "Missing scope or resource param";
            LOG.error((Object)msg);
            response.sendError(400, msg);
        }
        return true;
    }

    protected boolean getRequiresLifeCycle() {
        return false;
    }

    public void onInit(WebAppController controller, ServletConfig sConfig) throws Exception {
        super.onInit(controller, sConfig);
        LOG.debug((Object)"Registering ResourceRequestHandler for servlet container events");
        ServletContainerFactory.getServletContainer().addWebAppListener((WebAppListener)this);
    }

    public void onDestroy(WebAppController controller) {
        super.onDestroy(controller);
        LOG.debug((Object)"Unregistering ResourceRequestHandler for servlet container events");
        ServletContainerFactory.getServletContainer().removeWebAppListener((WebAppListener)this);
    }

    public void onEvent(WebAppEvent event) {
    }
}

