/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.resource;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.exoplatform.component.test.AbstractGateInTest;
import org.exoplatform.web.application.javascript.DependencyDescriptor;
import org.exoplatform.web.application.javascript.Javascript;
import org.exoplatform.web.application.javascript.JavascriptConfigParser;
import org.exoplatform.web.application.javascript.ScriptResourceDescriptor;
import org.gatein.portal.controller.resource.ResourceId;
import org.gatein.portal.controller.resource.ResourceScope;
import org.gatein.portal.controller.resource.script.Module;

public class TestParser
extends AbstractGateInTest {
    public void testShared() throws Exception {
        String config = "<gatein-resources><module><name>foo</name><script><name>foo_module</name><path>/foo_module.js</path></script><depends><module>bar</module></depends><depends><module>juu</module></depends></module><scripts><name>foo_scripts</name><script><name>foo_module</name><path>/foo_module.js</path></script><depends><scripts>bar</scripts></depends><depends><scripts>juu</scripts></depends></scripts></gatein-resources>";
        JavascriptConfigParser parser = new JavascriptConfigParser("/mypath");
        List scripts = parser.parseConfig((InputStream)new ByteArrayInputStream(config.getBytes("UTF-8")));
        TestParser.assertEquals((int)2, (int)scripts.size());
        ScriptResourceDescriptor desc = (ScriptResourceDescriptor)scripts.get(0);
        TestParser.assertEquals((Object)new ResourceId(ResourceScope.SHARED, "foo"), (Object)desc.getId());
        TestParser.assertNull((Object)desc.getAlias());
        TestParser.assertEquals(Arrays.asList(new DependencyDescriptor(new ResourceId(ResourceScope.SHARED, "bar")), new DependencyDescriptor(new ResourceId(ResourceScope.SHARED, "juu"))), (Object)desc.getDependencies());
        desc = (ScriptResourceDescriptor)scripts.get(1);
        TestParser.assertEquals((Object)new ResourceId(ResourceScope.SHARED, "foo_scripts"), (Object)desc.getId());
        TestParser.assertEquals(Arrays.asList(new DependencyDescriptor(new ResourceId(ResourceScope.SHARED, "bar")), new DependencyDescriptor(new ResourceId(ResourceScope.SHARED, "juu"))), (Object)desc.getDependencies());
    }

    public void testPortlet() throws Exception {
        String config = "<gatein-resources><portlet><name>foo</name><module><script><name>foo_module</name><path>/foo_module.js</path></script><depends><module>bar</module></depends><depends><module>juu</module></depends></module></portlet></gatein-resources>";
        JavascriptConfigParser parser = new JavascriptConfigParser("/mypath");
        List scripts = parser.parseConfig((InputStream)new ByteArrayInputStream(config.getBytes("UTF-8")));
        TestParser.assertEquals((int)1, (int)scripts.size());
        ScriptResourceDescriptor desc = (ScriptResourceDescriptor)scripts.get(0);
        TestParser.assertEquals((Object)new ResourceId(ResourceScope.PORTLET, "mypath/foo"), (Object)desc.getId());
        TestParser.assertNull((Object)desc.getAlias());
        TestParser.assertEquals(Arrays.asList(new DependencyDescriptor(new ResourceId(ResourceScope.SHARED, "bar")), new DependencyDescriptor(new ResourceId(ResourceScope.SHARED, "juu"))), (Object)desc.getDependencies());
    }

    public void testPortal() throws Exception {
        String config = "<gatein-resources><portal><name>foo</name><module><script><name>foo_module</name><path>/foo_module.js</path></script><depends><module>bar</module></depends><depends><module>juu</module></depends></module></portal></gatein-resources>";
        JavascriptConfigParser parser = new JavascriptConfigParser("/mypath");
        List scripts = parser.parseConfig((InputStream)new ByteArrayInputStream(config.getBytes("UTF-8")));
        TestParser.assertEquals((int)1, (int)scripts.size());
        ScriptResourceDescriptor desc = (ScriptResourceDescriptor)scripts.get(0);
        TestParser.assertEquals((Object)new ResourceId(ResourceScope.PORTAL, "foo"), (Object)desc.getId());
        TestParser.assertNull((Object)desc.getAlias());
        TestParser.assertEquals(Arrays.asList(new DependencyDescriptor(new ResourceId(ResourceScope.SHARED, "bar")), new DependencyDescriptor(new ResourceId(ResourceScope.SHARED, "juu"))), (Object)desc.getDependencies());
    }

    public void testModules() throws Exception {
        String config = "<gatein-resources><portal><name>foo</name><module><script><name>local_module</name><path>/local_module.js</path></script></module></portal></gatein-resources>";
        JavascriptConfigParser parser = new JavascriptConfigParser("/mypath");
        List scripts = parser.parseConfig((InputStream)new ByteArrayInputStream(config.getBytes("UTF-8")));
        TestParser.assertEquals((int)1, (int)scripts.size());
        ScriptResourceDescriptor desc = (ScriptResourceDescriptor)scripts.get(0);
        List modules = desc.getModules();
        TestParser.assertEquals((int)1, (int)modules.size());
        Javascript local = (Javascript)modules.get(0);
        TestParser.assertTrue((boolean)(local instanceof Javascript.Local));
        TestParser.assertEquals((String)"/local_module.js", (String)((Javascript.Local)local).getContents()[0].getSource());
    }

    public void testExclude() throws Exception {
        String config = "<gatein-resources><portal><name>foo</name><module><script><name>local_module</name><path>/local_module.js</path></script></module></portal></gatein-resources>";
        String configExclude = "<gatein-resources><portal><name>foo</name><module><script><name>local_module</name><minify>false</minify><path>/local_module.js</path></script></module></portal></gatein-resources>";
        JavascriptConfigParser parser = new JavascriptConfigParser("/mypath");
        List scripts = parser.parseConfig((InputStream)new ByteArrayInputStream(config.getBytes("UTF-8")));
        ScriptResourceDescriptor desc = (ScriptResourceDescriptor)scripts.get(0);
        List modules = desc.getModules();
        Javascript local = (Javascript)modules.get(0);
        TestParser.assertTrue((boolean)((Javascript.Local)local).isMinify());
        parser = new JavascriptConfigParser("/mypath");
        scripts = parser.parseConfig((InputStream)new ByteArrayInputStream(configExclude.getBytes("UTF-8")));
        desc = (ScriptResourceDescriptor)scripts.get(0);
        modules = desc.getModules();
        local = (Javascript)modules.get(0);
        TestParser.assertTrue((boolean)(local instanceof Javascript.Local));
        TestParser.assertFalse((boolean)((Javascript.Local)local).isMinify());
    }

    public void testResourceBundle() throws Exception {
        String config = "<gatein-resources><portal><name>foo</name><module><script><name>foo_module</name><path>/foo_module.js</path><resource-bundle>my_bundle</resource-bundle></script></module></portal></gatein-resources>";
        JavascriptConfigParser parser = new JavascriptConfigParser("/mypath");
        List scripts = parser.parseConfig((InputStream)new ByteArrayInputStream(config.getBytes("UTF-8")));
        TestParser.assertEquals((int)1, (int)scripts.size());
        ScriptResourceDescriptor desc = (ScriptResourceDescriptor)scripts.get(0);
        TestParser.assertEquals((Object)new ResourceId(ResourceScope.PORTAL, "foo"), (Object)desc.getId());
        TestParser.assertEquals((int)1, (int)desc.getModules().size());
        Javascript.Local js = (Javascript.Local)desc.getModules().get(0);
        TestParser.assertEquals((String)"my_bundle", (String)js.getResourceBundle());
    }

    public void testSupportedLocales() throws Exception {
        String config = "<gatein-resources><portal><name>foo</name><module><supported-locale>EN</supported-locale><supported-locale>FR-fr</supported-locale></module></portal></gatein-resources>";
        JavascriptConfigParser parser = new JavascriptConfigParser("/mypath");
        List scripts = parser.parseConfig((InputStream)new ByteArrayInputStream(config.getBytes("UTF-8")));
        TestParser.assertEquals((int)1, (int)scripts.size());
        ScriptResourceDescriptor desc = (ScriptResourceDescriptor)scripts.get(0);
        List locales = desc.getSupportedLocales();
        TestParser.assertEquals(Arrays.asList(Locale.ENGLISH, Locale.FRANCE), (Object)locales);
    }

    public void testRemoteResource() throws Exception {
        String validConfig = "<gatein-resources xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.exoplatform.org/xml/ns/gatein_resources_1_4 http://www.exoplatform.org/xml/ns/gatein_resources_1_4\" xmlns=\"http://www.exoplatform.org/xml/ns/gatein_resources_1_4\"><module><name>foo</name><url>http://jquery.com/jquery.js</url></module></gatein-resources>";
        JavascriptConfigParser parser = new JavascriptConfigParser("mypath");
        List descs = parser.parseConfig((InputStream)new ByteArrayInputStream(validConfig.getBytes("UTF-8")));
        TestParser.assertEquals((int)1, (int)descs.size());
        ScriptResourceDescriptor desc = (ScriptResourceDescriptor)descs.get(0);
        List scripts = desc.getModules();
        TestParser.assertEquals((int)1, (int)scripts.size());
        TestParser.assertTrue((boolean)(scripts.get(0) instanceof Javascript.Remote));
    }

    public void testAlias() throws Exception {
        String config = "<gatein-resources><module><name>foo</name><as>f</as><depends><module>bar</module><as>b</as></depends></module></gatein-resources>";
        JavascriptConfigParser parser = new JavascriptConfigParser("/mypath");
        List scripts = parser.parseConfig((InputStream)new ByteArrayInputStream(config.getBytes("UTF-8")));
        ScriptResourceDescriptor desc = (ScriptResourceDescriptor)scripts.get(0);
        TestParser.assertEquals((String)"f", (String)desc.getAlias());
        TestParser.assertEquals((String)"b", (String)((DependencyDescriptor)desc.getDependencies().get(0)).getAlias());
        config = "<gatein-resources><portal><name>zoo</name><as>z</as><module><depends><module>zozo</module><as>zz</as></depends></module></portal></gatein-resources>";
        List ptScripts = parser.parseConfig((InputStream)new ByteArrayInputStream(config.getBytes("UTF-8")));
        ScriptResourceDescriptor portalDesc = (ScriptResourceDescriptor)ptScripts.get(0);
        TestParser.assertEquals((String)"z", (String)portalDesc.getAlias());
        TestParser.assertEquals((String)"zz", (String)((DependencyDescriptor)portalDesc.getDependencies().get(0)).getAlias());
    }

    public void testLoadGroup() throws Exception {
        String config = "<gatein-resources><module><name>foo_module</name><load-group>foo_group</load-group><script><name>foo_module</name><path>/foo_module.js</path></script></module><portal><name>foo_portal</name><module><load-group>foo_group</load-group><script><name>foo_portal</name><path>/foo_portal.js</path></script></module></portal><portlet><name>foo_portlet</name><module><load-group>foo_group</load-group><script><name>foo_portlet</name><path>/foo_portlet.js</path></script></module></portlet></gatein-resources>";
        JavascriptConfigParser parser = new JavascriptConfigParser("/mypath");
        List scripts = parser.parseConfig((InputStream)new ByteArrayInputStream(config.getBytes("UTF-8")));
        TestParser.assertEquals((int)3, (int)scripts.size());
        for (ScriptResourceDescriptor des : scripts) {
            TestParser.assertEquals((String)"foo_group", (String)des.getGroup());
        }
    }

    public void testLoadGroupRestriction() throws Exception {
        String config = "<gatein-resources><scripts><name>foo_scripts</name><load-group>foo_group</load-group><script><name>foo_module</name><path>/foo_module.js</path></script></scripts><module><name>foo_module</name><load-group>foo_group</load-group><url>testURL</url></module></gatein-resources>";
        JavascriptConfigParser parser = new JavascriptConfigParser("/mypath");
        List scripts = parser.parseConfig((InputStream)new ByteArrayInputStream(config.getBytes("UTF-8")));
        TestParser.assertEquals((int)2, (int)scripts.size());
        for (ScriptResourceDescriptor des : scripts) {
            TestParser.assertNull((Object)des.getGroup());
        }
    }

    public void testAdapter() throws Exception {
        String config = "<gatein-resources><module><name>foo_module</name><script><name>foo</name><adapter>aaa;<include>/foo_module.js</include>bbb;</adapter></script></module></gatein-resources>";
        JavascriptConfigParser parser = new JavascriptConfigParser("/mypath");
        List scripts = parser.parseConfig((InputStream)new ByteArrayInputStream(config.getBytes("UTF-8")));
        ScriptResourceDescriptor des = (ScriptResourceDescriptor)scripts.get(0);
        Javascript.Local module = (Javascript.Local)des.getModules().get(0);
        Module.Local.Content[] contents = module.getContents();
        TestParser.assertNotNull((Object)contents);
        TestParser.assertEquals((int)3, (int)contents.length);
        TestParser.assertEquals((String)"aaa;", (String)contents[0].getSource());
        TestParser.assertFalse((boolean)contents[0].isPath());
        TestParser.assertEquals((String)"/foo_module.js", (String)contents[1].getSource());
        TestParser.assertTrue((boolean)contents[1].isPath());
    }
}

