/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application;

import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Random;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.web.AbstractFilter;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.Orientation;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.web.application.javascript.JavascriptConfigService;
import org.gatein.portal.controller.resource.ResourceRequestHandler;
import org.gatein.portal.controller.resource.ResourceScope;
import org.gatein.portal.controller.resource.ScriptContent;

public class ResourceRequestFilter
extends AbstractFilter {
    private static final Log LOG = ExoLogger.getLogger(ResourceRequestFilter.class);
    private static final String CACHE_CONTROL_HEADER_NAME = "Cache-Control";
    public static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String LAST_MODIFIED = "Last-Modified";
    public static final String EXPIRES = "Expires";
    public static final long DEFAULT_MAX_AGE = 31536000L;
    public static long maxAge = ResourceRequestFilter.getMaxAge();
    public static String version = ResourceRequestFilter.getVersion();
    private JavascriptConfigService javascriptService;
    private SkinService skinService;
    private ResourceBundleService resourceBundleService;

    protected void afterInit(FilterConfig config) throws ServletException {
        super.afterInit(config);
        if (StringUtils.isBlank((CharSequence)version)) {
            version = ResourceRequestFilter.getVersion();
            ResourceRequestHandler.MAX_AGE = maxAge = ResourceRequestFilter.getMaxAge();
            ResourceRequestHandler.VERSION = version;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(PortalContainer.getInstance().getPortalClassLoader());
        try {
            String servletPath = httpRequest.getServletPath();
            if (servletPath.endsWith(".css")) {
                String fileContent;
                String fileContentHash = httpRequest.getParameter("hash");
                String orientation = httpRequest.getParameter("orientation");
                String compress = httpRequest.getParameter("minify");
                if (fileContentHash != null && orientation != null && compress != null && (fileContent = this.getSkinModuleContent(httpRequest, fileContentHash, orientation, compress)) != null) {
                    byte[] bytes = fileContent.getBytes(StandardCharsets.UTF_8);
                    this.writeStaticResourceContent(httpResponse, bytes, "text/css");
                    return;
                }
            } else if (servletPath.endsWith(".js")) {
                ScriptContent script;
                String scope = httpRequest.getParameter("scope");
                String compress = httpRequest.getParameter("minify");
                if (scope != null && compress != null && (script = this.getScriptContent(httpRequest, scope, compress)) != null) {
                    byte[] bytes = script.getContentAsBytes();
                    this.writeStaticResourceContent(httpResponse, bytes, "text/javascript");
                    return;
                }
            } else if (servletPath.startsWith("/i18n/")) {
                String lang = httpRequest.getParameter("lang");
                String resourceBundleName = servletPath.replace("/i18n/", "");
                String i18N = this.getResourceBundleContent(resourceBundleName, lang);
                if (i18N != null) {
                    this.writeStaticResourceContent(httpResponse, i18N.getBytes(StandardCharsets.UTF_8), "application/json");
                    return;
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
        httpResponse.setHeader(CACHE_CONTROL_HEADER_NAME, "public, " + maxAge);
        httpResponse.setDateHeader(LAST_MODIFIED, System.currentTimeMillis());
        httpResponse.setDateHeader(EXPIRES, System.currentTimeMillis() + maxAge * 1000L);
        chain.doFilter(request, response);
    }

    private void writeStaticResourceContent(HttpServletResponse httpResponse, byte[] bytes, String mimeType) throws IOException {
        httpResponse.setContentType(mimeType);
        httpResponse.setContentLength(bytes.length);
        httpResponse.setHeader(CACHE_CONTROL_HEADER_NAME, "public, " + maxAge);
        httpResponse.setDateHeader(LAST_MODIFIED, System.currentTimeMillis());
        httpResponse.setDateHeader(EXPIRES, System.currentTimeMillis() + maxAge * 1000L);
        PrintWriter writer = httpResponse.getWriter();
        IOUtils.write((byte[])bytes, (Writer)writer, (Charset)StandardCharsets.UTF_8);
        writer.close();
    }

    private ScriptContent getScriptContent(HttpServletRequest httpRequest, String scope, String compress) {
        String jsPath = httpRequest.getServletPath();
        Object module = jsPath.substring(jsPath.lastIndexOf("/") + 1).replace(".js", "");
        ResourceScope resourceScope = ResourceScope.valueOf(scope);
        if (resourceScope == ResourceScope.PORTLET) {
            module = httpRequest.getServletContext().getContextPath().replace("/", "") + "/" + (String)module;
        }
        return this.getJavascriptService().getScriptContent(resourceScope, (String)module, "true".equals(compress));
    }

    private String getSkinModuleContent(HttpServletRequest httpRequest, String fileContentHash, String orientation, String compress) throws IOException {
        return this.getSkinService().getSkinModuleContent(httpRequest.getContextPath() + httpRequest.getServletPath(), Integer.parseInt(fileContentHash), Orientation.valueOf((String)orientation), StringUtils.equals((CharSequence)"true", (CharSequence)compress));
    }

    private String getResourceBundleContent(String resourceBundleName, String lang) {
        return this.getResourceBundleService().getResourceBundleContent(resourceBundleName, Locale.forLanguageTag(lang));
    }

    private JavascriptConfigService getJavascriptService() {
        if (this.javascriptService == null) {
            this.javascriptService = (JavascriptConfigService)ExoContainerContext.getService(JavascriptConfigService.class);
        }
        return this.javascriptService;
    }

    private SkinService getSkinService() {
        if (this.skinService == null) {
            this.skinService = (SkinService)ExoContainerContext.getService(SkinService.class);
        }
        return this.skinService;
    }

    public ResourceBundleService getResourceBundleService() {
        if (this.resourceBundleService == null) {
            this.resourceBundleService = (ResourceBundleService)ExoContainerContext.getService(ResourceBundleService.class);
        }
        return this.resourceBundleService;
    }

    private static String getVersion() {
        Object version = PropertyManager.getProperty((String)"gatein.assets.version");
        if (StringUtils.isNotBlank((CharSequence)version)) {
            if (StringUtils.contains((CharSequence)version, (CharSequence)"SNAPSHOT") || PropertyManager.isDevelopping()) {
                version = (String)version + "-" + new Random().nextLong();
            }
            LOG.info("Use version \"{}\" for resource serving", new Object[]{version});
        }
        return version;
    }

    private static long getMaxAge() {
        String maxAge = PropertyManager.getProperty((String)"gatein.assets.script.max-age");
        if (StringUtils.isBlank((CharSequence)maxAge)) {
            maxAge = String.valueOf(31536000L);
        }
        LOG.info("Use maxAge \"{}\" seconds for resource serving", new Object[]{maxAge});
        return Long.parseLong(maxAge);
    }
}

