/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.portal.controller.resource.script;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.exoplatform.component.test.AbstractGateInTest;
import org.gatein.common.util.Tools;
import org.gatein.portal.controller.resource.ResourceId;
import org.gatein.portal.controller.resource.ResourceScope;
import org.gatein.portal.controller.resource.script.FetchMode;
import org.gatein.portal.controller.resource.script.ScriptGraph;
import org.gatein.portal.controller.resource.script.ScriptResource;

public class TestScriptGraph
extends AbstractGateInTest {
    private static final ResourceId A = new ResourceId(ResourceScope.SHARED, "A");
    private static final ResourceId B = new ResourceId(ResourceScope.SHARED, "B");
    private static final ResourceId C = new ResourceId(ResourceScope.SHARED, "C");
    private static final ResourceId D = new ResourceId(ResourceScope.PORTAL, "D");

    public void testDetectCycle1() {
        ScriptGraph graph = new ScriptGraph();
        ScriptResource a = graph.addResource(A);
        ScriptResource b = graph.addResource(B);
        a.addDependency(B);
        try {
            b.addDependency(A);
            TestScriptGraph.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testDetectCycle2() {
        ScriptGraph graph = new ScriptGraph();
        ScriptResource a = graph.addResource(A);
        ScriptResource b = graph.addResource(B);
        ScriptResource c = graph.addResource(C);
        a.addDependency(B);
        b.addDependency(C);
        try {
            c.addDependency(A);
            TestScriptGraph.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testClosure() {
        ScriptGraph graph = new ScriptGraph();
        ScriptResource a = graph.addResource(A);
        a.addDependency(B);
        ScriptResource b = graph.addResource(B);
        b.addDependency(C);
        ScriptResource c = graph.addResource(C);
        TestScriptGraph.assertEquals((Object)Tools.toSet((Object[])new ResourceId[]{B, C}), (Object)a.getClosure());
        TestScriptGraph.assertEquals((Object)Tools.toSet((Object[])new ResourceId[]{C}), (Object)b.getClosure());
        TestScriptGraph.assertEquals(Collections.emptySet(), (Object)c.getClosure());
    }

    public void testBuildingOrder() {
        ScriptGraph graph = new ScriptGraph();
        ScriptResource a = graph.addResource(A);
        a.addDependency(B);
        ScriptResource c = graph.addResource(C);
        c.addDependency(D);
        ScriptResource b = graph.addResource(B);
        b.addDependency(C);
        ScriptResource d = graph.addResource(D);
        TestScriptGraph.assertEquals((Object)Tools.toSet((Object[])new ResourceId[]{D}), (Object)c.getClosure());
        TestScriptGraph.assertEquals((Object)Tools.toSet((Object[])new ResourceId[]{C, D}), (Object)b.getClosure());
        TestScriptGraph.assertEquals((Object)Tools.toSet((Object[])new ResourceId[]{B, C, D}), (Object)a.getClosure());
    }

    public void testFetchMode() {
        ScriptGraph graph = new ScriptGraph();
        ScriptResource a = graph.addResource(A, FetchMode.ON_LOAD);
        ScriptResource b = graph.addResource(B, FetchMode.IMMEDIATE);
        ScriptResource c = graph.addResource(C, FetchMode.IMMEDIATE);
        try {
            a.addDependency(C);
            TestScriptGraph.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        b.addDependency(C);
        Map resolution = graph.resolve(Collections.singletonMap(A, null));
        this.assertResultOrder(resolution.keySet());
        TestScriptGraph.assertEquals((int)1, (int)resolution.size());
        TestScriptGraph.assertEquals((Object)Tools.toSet((Object[])new ScriptResource[]{a}), resolution.keySet());
        resolution = graph.resolve(Collections.singletonMap(B, null));
        this.assertResultOrder(resolution.keySet());
        TestScriptGraph.assertEquals((int)2, (int)resolution.size());
        TestScriptGraph.assertEquals((Object)Tools.toSet((Object[])new ScriptResource[]{b, c}), resolution.keySet());
        TestScriptGraph.assertEquals((Object)FetchMode.IMMEDIATE, resolution.get(b));
        TestScriptGraph.assertEquals((Object)FetchMode.IMMEDIATE, resolution.get(c));
        LinkedHashMap<ResourceId, Object> pairs = new LinkedHashMap<ResourceId, Object>();
        pairs.put(A, null);
        pairs.put(B, null);
        resolution = graph.resolve(pairs);
        this.assertResultOrder(resolution.keySet());
        TestScriptGraph.assertEquals((int)3, (int)resolution.size());
        TestScriptGraph.assertEquals((Object)Tools.toSet((Object[])new ScriptResource[]{a, b, c}), resolution.keySet());
        TestScriptGraph.assertEquals((Object)FetchMode.ON_LOAD, resolution.get(a));
        TestScriptGraph.assertEquals((Object)FetchMode.IMMEDIATE, resolution.get(b));
        TestScriptGraph.assertEquals((Object)FetchMode.IMMEDIATE, resolution.get(c));
    }

    public void testResolveDefaultOnLoadFetchMode() {
        ScriptGraph graph = new ScriptGraph();
        ScriptResource a = graph.addResource(A, FetchMode.ON_LOAD);
        Map test = graph.resolve(Collections.singletonMap(A, null));
        this.assertResultOrder(test.keySet());
        TestScriptGraph.assertEquals((Object)Tools.toSet((Object[])new ScriptResource[]{a}), test.keySet());
        TestScriptGraph.assertEquals((Object)FetchMode.ON_LOAD, test.get(a));
        test = graph.resolve(Collections.singletonMap(A, FetchMode.ON_LOAD));
        this.assertResultOrder(test.keySet());
        TestScriptGraph.assertEquals((Object)Tools.toSet((Object[])new ScriptResource[]{a}), test.keySet());
        TestScriptGraph.assertEquals((Object)FetchMode.ON_LOAD, test.get(a));
        test = graph.resolve(Collections.singletonMap(A, FetchMode.IMMEDIATE));
        TestScriptGraph.assertEquals((int)0, (int)test.size());
    }

    public void testResolveDefaultImmediateFetchMode() {
        ScriptGraph graph = new ScriptGraph();
        ScriptResource a = graph.addResource(A, FetchMode.IMMEDIATE);
        Map test = graph.resolve(Collections.singletonMap(A, null));
        this.assertResultOrder(test.keySet());
        TestScriptGraph.assertEquals((Object)Tools.toSet((Object[])new ScriptResource[]{a}), test.keySet());
        TestScriptGraph.assertEquals((Object)FetchMode.IMMEDIATE, test.get(a));
        test = graph.resolve(Collections.singletonMap(A, FetchMode.ON_LOAD));
        TestScriptGraph.assertEquals((int)0, (int)test.keySet().size());
        test = graph.resolve(Collections.singletonMap(A, FetchMode.IMMEDIATE));
        this.assertResultOrder(test.keySet());
        TestScriptGraph.assertEquals((Object)Tools.toSet((Object[])new ScriptResource[]{a}), test.keySet());
        TestScriptGraph.assertEquals((Object)FetchMode.IMMEDIATE, test.get(a));
    }

    public void testResolveDependency1() {
        ScriptGraph graph = new ScriptGraph();
        ScriptResource a = graph.addResource(A, FetchMode.IMMEDIATE);
        ScriptResource b = graph.addResource(B, FetchMode.ON_LOAD);
        try {
            a.addDependency(B);
            TestScriptGraph.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        LinkedHashMap<ResourceId, Object> pairs = new LinkedHashMap<ResourceId, Object>();
        pairs.put(A, null);
        pairs.put(B, null);
        Map test = graph.resolve(pairs);
        this.assertResultOrder(test.keySet());
        TestScriptGraph.assertEquals((Object)Tools.toSet((Object[])new ScriptResource[]{a, b}), test.keySet());
        TestScriptGraph.assertEquals((Object)FetchMode.IMMEDIATE, test.get(a));
        TestScriptGraph.assertEquals((Object)FetchMode.ON_LOAD, test.get(b));
        pairs = new LinkedHashMap();
        pairs.put(B, null);
        pairs.put(A, null);
        test = graph.resolve(pairs);
        this.assertResultOrder(test.keySet());
        TestScriptGraph.assertEquals((Object)Tools.toSet((Object[])new ScriptResource[]{a, b}), test.keySet());
        TestScriptGraph.assertEquals((Object)FetchMode.IMMEDIATE, test.get(a));
        TestScriptGraph.assertEquals((Object)FetchMode.ON_LOAD, test.get(b));
        pairs = new LinkedHashMap();
        pairs.put(B, null);
        test = graph.resolve(pairs);
        this.assertResultOrder(test.keySet());
        TestScriptGraph.assertEquals((Object)Tools.toSet((Object[])new ScriptResource[]{b}), test.keySet());
        TestScriptGraph.assertEquals((Object)FetchMode.ON_LOAD, test.get(b));
    }

    public void testResolveDependency2() {
        ScriptGraph graph = new ScriptGraph();
        ScriptResource a = graph.addResource(A, FetchMode.ON_LOAD);
        ScriptResource b = graph.addResource(B, FetchMode.IMMEDIATE);
        try {
            a.addDependency(B);
            TestScriptGraph.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        LinkedHashMap<ResourceId, Object> pairs = new LinkedHashMap<ResourceId, Object>();
        pairs.put(A, null);
        Map test = graph.resolve(pairs);
        this.assertResultOrder(test.keySet());
        TestScriptGraph.assertEquals((Object)Tools.toSet((Object[])new ScriptResource[]{a}), test.keySet());
        TestScriptGraph.assertEquals((Object)FetchMode.ON_LOAD, test.get(a));
        pairs = new LinkedHashMap();
        pairs.put(A, null);
        pairs.put(B, null);
        test = graph.resolve(pairs);
        this.assertResultOrder(test.keySet());
        TestScriptGraph.assertEquals((Object)Tools.toSet((Object[])new ScriptResource[]{a, b}), test.keySet());
        TestScriptGraph.assertEquals((Object)FetchMode.ON_LOAD, test.get(a));
        TestScriptGraph.assertEquals((Object)FetchMode.IMMEDIATE, test.get(b));
        pairs = new LinkedHashMap();
        pairs.put(B, null);
        pairs.put(A, null);
        test = graph.resolve(pairs);
        this.assertResultOrder(test.keySet());
        TestScriptGraph.assertEquals((Object)Tools.toSet((Object[])new ScriptResource[]{a, b}), test.keySet());
        TestScriptGraph.assertEquals((Object)FetchMode.ON_LOAD, test.get(a));
        TestScriptGraph.assertEquals((Object)FetchMode.IMMEDIATE, test.get(b));
        pairs = new LinkedHashMap();
        pairs.put(B, null);
        test = graph.resolve(pairs);
        this.assertResultOrder(test.keySet());
        TestScriptGraph.assertEquals((Object)Tools.toSet((Object[])new ScriptResource[]{b}), test.keySet());
        TestScriptGraph.assertEquals((Object)FetchMode.IMMEDIATE, test.get(b));
    }

    public void testResolveDisjointDependencies() {
        ScriptGraph graph = new ScriptGraph();
        ScriptResource a = graph.addResource(A, FetchMode.IMMEDIATE);
        ScriptResource b = graph.addResource(B, FetchMode.IMMEDIATE);
        ScriptResource c = graph.addResource(C, FetchMode.IMMEDIATE);
        a.addDependency(C);
        ResourceId[][] samples = new ResourceId[][]{{A}, {A, B}, {B, A}, {A, B, C}, {A, C, B}, {B, A, C}, {B, C, A}, {C, A, B}, {C, B, A}};
        LinkedHashMap pairs = new LinkedHashMap();
        for (ResourceId[] sample : samples) {
            pairs.clear();
            for (ResourceId id : sample) {
                pairs.put(id, null);
            }
            Map test = graph.resolve(pairs);
            this.assertResultOrder(test.keySet());
        }
    }

    public void testCrossDependency() {
        ScriptGraph graph = new ScriptGraph();
        ScriptResource a = graph.addResource(A, FetchMode.IMMEDIATE);
        graph.addResource(B, FetchMode.ON_LOAD);
        try {
            a.addDependency(B);
            TestScriptGraph.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        graph = new ScriptGraph();
        a = graph.addResource(A, FetchMode.ON_LOAD);
        a.addDependency(B);
        try {
            graph.addResource(B, FetchMode.IMMEDIATE);
            TestScriptGraph.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testDuplicateResource() {
        ScriptGraph graph = new ScriptGraph();
        ResourceId shared = new ResourceId(ResourceScope.SHARED, "foo");
        graph.addResource(shared);
        try {
            graph.addResource(shared);
            TestScriptGraph.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        ResourceId portlet = new ResourceId(ResourceScope.PORTLET, "foo");
        graph.addResource(portlet);
        try {
            graph.addResource(portlet);
            TestScriptGraph.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        ResourceId portal = new ResourceId(ResourceScope.PORTAL, "foo");
        graph.addResource(portal);
        try {
            graph.addResource(portal);
            TestScriptGraph.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void assertResultOrder(Collection<ScriptResource> test) {
        ScriptResource[] array = test.toArray(new ScriptResource[test.size()]);
        for (int i = 0; i < array.length; ++i) {
            ScriptResource resource = array[i];
            for (int j = i + 1; j < array.length; ++j) {
                if (!resource.closure.contains(array[j].getId()) || !resource.fetchMode.equals((Object)array[j].fetchMode)) continue;
                throw TestScriptGraph.failure((String)("Was not expecting result order " + String.valueOf(test)), (Throwable)new Exception());
            }
        }
    }
}

