/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.security.codec;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.security.KeyStore;
import java.util.HashMap;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import junit.framework.TestCase;
import org.exoplatform.web.security.codec.AbstractCodec;
import org.exoplatform.web.security.codec.JCASymmetricCodecBuilder;
import org.gatein.common.io.IOTools;

public class TestJCASymmetricCodec
extends TestCase {
    public void testDefaultCodec() throws Exception {
        URL keyFile = Thread.currentThread().getContextClassLoader().getResource("conf/key.txt");
        if (System.getProperty("java.vendor").toLowerCase().contains("ibm")) {
            keyFile = Thread.currentThread().getContextClassLoader().getResource("conf/key-ibmjvm.txt");
        }
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("gatein.codec.jca.symmetric.keyalg", "AES");
        config.put("gatein.codec.jca.symmetric.keystore", URLDecoder.decode(keyFile.getPath(), "UTF-8"));
        config.put("gatein.codec.jca.symmetric.storetype", "JCEKS");
        config.put("gatein.codec.jca.symmetric.alias", "gtnKey");
        config.put("gatein.codec.jca.symmetric.keypass", "gtnKeyPass");
        config.put("gatein.codec.jca.symmetric.storepass", "gtnStorePass");
        AbstractCodec codec = new JCASymmetricCodecBuilder().build(config);
        TestJCASymmetricCodec.assertNotNull((Object)codec);
        String encrypted = codec.encode("exoplatform");
        TestJCASymmetricCodec.assertFalse((boolean)"exoplatform".equals(encrypted));
        TestJCASymmetricCodec.assertEquals((String)"exoplatform", (String)codec.decode(encrypted));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCodecWithGeneratedKey() throws Exception {
        String alias = "testAlias";
        char[] keyPass = "testKeyPass".toCharArray();
        char[] storePass = "testStorePass".toCharArray();
        URL url = Thread.currentThread().getContextClassLoader().getResource("conf");
        File f = new File(new File(url.toURI()), "gen-key.txt");
        if (f.exists()) {
            f.delete();
        }
        f.createNewFile();
        KeyGenerator keyGen = KeyGenerator.getInstance("DES");
        SecretKey tmpSecretKey = keyGen.generateKey();
        KeyStore tmpStore = KeyStore.getInstance("JCEKS");
        tmpStore.load(null, storePass);
        tmpStore.setEntry(alias, new KeyStore.SecretKeyEntry(tmpSecretKey), new KeyStore.PasswordProtection(keyPass));
        FileOutputStream out = new FileOutputStream(f);
        try {
            tmpStore.store(out, storePass);
        }
        finally {
            IOTools.safeClose((Closeable)out);
        }
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("gatein.codec.jca.symmetric.keyalg", "DES");
        config.put("gatein.codec.jca.symmetric.keystore", f.getPath());
        config.put("gatein.codec.jca.symmetric.storetype", "JCEKS");
        config.put("gatein.codec.jca.symmetric.alias", alias);
        config.put("gatein.codec.jca.symmetric.keypass", "testKeyPass");
        config.put("gatein.codec.jca.symmetric.storepass", "testStorePass");
        AbstractCodec codec = new JCASymmetricCodecBuilder().build(config);
        TestJCASymmetricCodec.assertNotNull((Object)codec);
        TestJCASymmetricCodec.assertFalse((boolean)"exoplatform".equals(codec.encode("exoplatform")));
        TestJCASymmetricCodec.assertEquals((String)"exoplatform", (String)codec.decode(codec.encode("exoplatform")));
        TestJCASymmetricCodec.assertEquals((String)"123456", (String)codec.decode(codec.encode("123456")));
    }
}

