/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.register;

import io.meeds.spring.web.localization.HttpRequestLocaleWrapper;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.awt.Color;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import nl.captcha.Captcha;
import nl.captcha.servlet.CaptchaServletUtil;
import nl.captcha.text.producer.DefaultTextProducer;
import nl.captcha.text.renderer.DefaultWordRenderer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.branding.BrandingService;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.portal.rest.UserFieldValidator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.application.JspBasedWebHandler;
import org.exoplatform.web.application.javascript.JavascriptConfigService;
import org.exoplatform.web.login.UIParamsExtension;
import org.exoplatform.web.login.recovery.PasswordRecoveryService;
import org.exoplatform.web.register.RegisterUIParamsExtension;
import org.json.JSONObject;

public class RegisterHandler
extends JspBasedWebHandler {
    private static final Log LOG = ExoLogger.getLogger(RegisterHandler.class);
    public static final String NAME = "register";
    public static final String REGISTER_EXTENSION_NAME = "RegisterExtension";
    public static final String REGISTER_ENABLED = "registerEnabled";
    public static final String REGISTER_JSP_PATH_PARAM = "register.jsp.path";
    public static final String REGISTER_EXTENSION_JS_MODULES = "RegisterExtension";
    public static final String REGISTRATION_ERROR_CODE = "REGISTRATION_ERROR";
    public static final String EMAIL_PARAM = "email";
    public static final String CAPTCHA_PARAM = "captcha";
    public static final UserFieldValidator EMAIL_VALIDATOR = new UserFieldValidator("email", false, false);
    public static final String ONBOARDING_EMAIL_SENT_MESSAGE = "onboardingEmailSent";
    public static final String SUCCESS_MESSAGE_PARAM = "success";
    public static final String ERROR_MESSAGE_PARAM = "error";
    public static final int CAPTCHA_WIDTH = 200;
    public static final int CAPTCHA_HEIGHT = 50;
    private PortalContainer container;
    private PasswordRecoveryService passwordRecoveryService;
    private OrganizationService organizationService;
    private ResourceBundleService resourceBundleService;
    private RegisterUIParamsExtension registerUIParamsExtension;
    private ServletContext servletContext;
    private String registerJspPath;

    public RegisterHandler(PortalContainer container, ResourceBundleService resourceBundleService, PasswordRecoveryService passwordRecoveryService, OrganizationService organizationService, LocaleConfigService localeConfigService, BrandingService brandingService, JavascriptConfigService javascriptConfigService, SkinService skinService, RegisterUIParamsExtension registerUIParamsExtension, InitParams params) {
        super(localeConfigService, brandingService, javascriptConfigService, skinService);
        this.container = container;
        this.passwordRecoveryService = passwordRecoveryService;
        this.organizationService = organizationService;
        this.resourceBundleService = resourceBundleService;
        this.registerUIParamsExtension = registerUIParamsExtension;
        this.servletContext = container.getPortalContext();
        if (params != null && params.containsKey((Object)REGISTER_JSP_PATH_PARAM)) {
            this.registerJspPath = params.getValueParam(REGISTER_JSP_PATH_PARAM).getValue();
        }
    }

    public String getHandlerName() {
        return NAME;
    }

    protected boolean getRequiresLifeCycle() {
        return true;
    }

    public boolean execute(ControllerContext controllerContext) throws Exception {
        HttpRequestLocaleWrapper request = new HttpRequestLocaleWrapper(controllerContext.getRequest());
        HttpServletResponse response = controllerContext.getResponse();
        if (request.getRemoteUser() != null) {
            return false;
        }
        if (!this.registerUIParamsExtension.isRegisterEnabled()) {
            response.setStatus(401);
            return true;
        }
        Locale locale = request.getLocale();
        ResourceBundle resourceBundle = this.resourceBundleService.getResourceBundle(this.resourceBundleService.getSharedResourceBundleNames(), locale);
        String serveCaptcha = request.getParameter("serveCaptcha");
        if ("true".equals(serveCaptcha)) {
            return this.serveCaptchaImage((HttpServletRequest)request, response);
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String email = request.getParameter(EMAIL_PARAM);
        if (StringUtils.isNotBlank((CharSequence)email)) {
            String captcha = request.getParameter(CAPTCHA_PARAM);
            if (!this.isValidCaptch(request.getSession(), captcha)) {
                parameters.put(ERROR_MESSAGE_PARAM, resourceBundle.getString("gatein.forgotPassword.captchaError"));
            } else if (this.isValidEmail(email, resourceBundle, locale, parameters)) {
                this.sendOnboardingEmail(email, (HttpServletRequest)request);
                parameters.put(SUCCESS_MESSAGE_PARAM, ONBOARDING_EMAIL_SENT_MESSAGE);
            }
            parameters.put(EMAIL_PARAM, email);
        }
        return this.dispatch(controllerContext, parameters);
    }

    protected boolean dispatch(ControllerContext controllerContext, Map<String, Object> parameters) throws Exception {
        HttpServletRequest request = controllerContext.getRequest();
        HttpServletResponse response = controllerContext.getResponse();
        request.getSession().removeAttribute(NAME);
        List<String> additionalJSModules = this.getExtendedJSModules();
        List<String> additionalCSSModules = Collections.singletonList("portal/login");
        super.prepareDispatch(controllerContext, "PORTLET/social-portlet/Register", additionalJSModules, additionalCSSModules, params -> this.extendApplicationParameters(controllerContext, (JSONObject)params, parameters));
        this.servletContext.getRequestDispatcher(this.registerJspPath).include((ServletRequest)request, (ServletResponse)response);
        return true;
    }

    protected void extendApplicationParameters(ControllerContext controllerContext, JSONObject params, Map<String, Object> parameters) {
        try {
            List paramsExtensions;
            if (parameters != null) {
                parameters.forEach((arg_0, arg_1) -> ((JSONObject)params).put(arg_0, arg_1));
            }
            if (CollectionUtils.isNotEmpty((Collection)(paramsExtensions = this.container.getComponentInstancesOfType(UIParamsExtension.class)))) {
                paramsExtensions.stream().filter(extension -> extension.getExtensionNames().contains("RegisterExtension")).forEach(paramsExtension -> {
                    Map<String, Object> extendedParams = paramsExtension.extendParameters(controllerContext, "RegisterExtension");
                    if (MapUtils.isNotEmpty(extendedParams)) {
                        extendedParams.forEach((key, value) -> {
                            try {
                                params.put(key, value);
                            }
                            catch (Exception e) {
                                LOG.warn("Error while adding {}/{} in register params map", new Object[]{key, value, e});
                            }
                        });
                    }
                });
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Error while computing Register UI parameters", (Throwable)e);
        }
    }

    private List<String> getExtendedJSModules() {
        ArrayList<String> additionalJSModules = new ArrayList<String>();
        JSONObject jsConfig = this.javascriptConfigService.getJSConfig();
        if (jsConfig.has("paths")) {
            JSONObject jsConfigPaths = jsConfig.getJSONObject("paths");
            Iterator keys = jsConfigPaths.keys();
            while (keys.hasNext()) {
                String module = (String)keys.next();
                if (!module.contains("RegisterExtension")) continue;
                additionalJSModules.add(module);
            }
        }
        return additionalJSModules;
    }

    private void sendOnboardingEmail(String email, HttpServletRequest request) throws Exception {
        StringBuilder url = this.getUrl(request);
        Locale locale = request.getLocale();
        this.passwordRecoveryService.sendExternalRegisterEmail(null, email, locale, null, url, false);
    }

    private boolean isValidEmail(String email, ResourceBundle resourceBundle, Locale locale, Map<String, Object> parameters) throws Exception {
        String errorMessage = EMAIL_VALIDATOR.validate(locale, email);
        if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
            parameters.put(ERROR_MESSAGE_PARAM, errorMessage);
        } else {
            try {
                Query query = new Query();
                query.setEmail(email);
                ListAccess users = this.organizationService.getUserHandler().findUsersByQuery(query, UserStatus.ANY);
                if (users != null && users.getSize() > 0) {
                    parameters.put(SUCCESS_MESSAGE_PARAM, ONBOARDING_EMAIL_SENT_MESSAGE);
                } else {
                    User user = this.organizationService.getUserHandler().findUserByName(email);
                    if (user != null) {
                        parameters.put(SUCCESS_MESSAGE_PARAM, ONBOARDING_EMAIL_SENT_MESSAGE);
                    }
                }
            }
            catch (RuntimeException e) {
                LOG.debug("Error retrieving users list with email {}. Thus, we will consider the email as already used", new Object[]{email, e});
                parameters.put(ERROR_MESSAGE_PARAM, resourceBundle.getString("external.registration.fail.create.user"));
            }
        }
        return !parameters.containsKey(ERROR_MESSAGE_PARAM) && !parameters.containsKey(SUCCESS_MESSAGE_PARAM);
    }

    private boolean isValidCaptch(HttpSession session, String captchaValue) {
        Captcha captcha = (Captcha)session.getAttribute(NAME);
        return captcha != null && captcha.isCorrect(captchaValue);
    }

    private boolean serveCaptchaImage(HttpServletRequest req, HttpServletResponse resp) {
        Captcha captcha;
        HttpSession session = req.getSession();
        if (session.getAttribute(NAME) == null) {
            List<Font> textFonts = Arrays.asList(new Font("Arial", 1, 40), new Font("Courier", 1, 40));
            captcha = new Captcha.Builder(200, 50).addText(new DefaultTextProducer(5), new DefaultWordRenderer(Color.WHITE, textFonts)).gimp().addNoise().addBackground().build();
            session.setAttribute(NAME, (Object)captcha);
            this.writeImage(resp, captcha.getImage());
        }
        captcha = (Captcha)session.getAttribute(NAME);
        this.writeImage(resp, captcha.getImage());
        return true;
    }

    private void writeImage(HttpServletResponse response, BufferedImage bi) {
        response.setHeader("Cache-Control", "private,no-cache,no-store");
        response.setContentType("image/png");
        try {
            CaptchaServletUtil.writeImage((OutputStream)response.getOutputStream(), bi);
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private StringBuilder getUrl(HttpServletRequest request) {
        StringBuilder url = new StringBuilder();
        if (request != null) {
            url.append(request.getScheme()).append("://").append(request.getServerName());
            if (request.getServerPort() != 80 && request.getServerPort() != 443) {
                url.append(':').append(request.getServerPort());
            }
            url.append("/" + PortalContainer.getCurrentPortalContainerName());
        }
        return url;
    }
}

