/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.spring.web.localization;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Locale;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.localization.LocaleContextInfoUtils;
import org.exoplatform.services.resources.LocaleContextInfo;
import org.exoplatform.services.resources.LocalePolicy;

public class HttpRequestLocaleWrapper
extends HttpServletRequestWrapper {
    private Locale locale;

    public HttpRequestLocaleWrapper(HttpServletRequest request) {
        super(request);
    }

    public Locale getLocale() {
        if (this.locale == null) {
            LocaleContextInfo localeCtx = LocaleContextInfoUtils.buildLocaleContextInfo((HttpServletRequest)((HttpServletRequest)this.getRequest()));
            LocalePolicy localePolicyService = (LocalePolicy)ExoContainerContext.getService(LocalePolicy.class);
            this.locale = localePolicyService == null ? this.getRequest().getLocale() : localePolicyService.determineLocale(localeCtx);
        }
        return this.locale;
    }

    public Enumeration<Locale> getLocales() {
        Locale userLocale = this.getLocale();
        if (userLocale == null) {
            return this.getRequest().getLocales();
        }
        LinkedList locales = new LinkedList(Collections.list(this.getRequest().getLocales()));
        locales.add(userLocale);
        return Collections.enumeration(locales);
    }
}

