/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.security;

import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.web.security.GateInTokenStore;
import org.exoplatform.web.security.hash.NoSaltedHashService;
import org.exoplatform.web.security.security.CookieTokenService;
import org.exoplatform.web.security.security.TokenServiceInitializationException;

public class SimpleGeneratorCookieTokenService
extends CookieTokenService {
    private int counter = 0;
    private int noRandom = 0;

    public SimpleGeneratorCookieTokenService(InitParams initParams, GateInTokenStore tokenStore) throws TokenServiceInitializationException {
        super(SimpleGeneratorCookieTokenService.replaceHashService(initParams), tokenStore);
    }

    public void resetCounter() {
        this.counter = 0;
        this.noRandom = 0;
    }

    private static InitParams replaceHashService(InitParams initParams) {
        ObjectParameter hashParam = new ObjectParameter();
        hashParam.setName("hash.service");
        hashParam.setObject((Object)new NoSaltedHashService());
        initParams.addParameter((Parameter)hashParam);
        return initParams;
    }

    protected String nextTokenId() {
        ++this.counter;
        return "rememberme" + this.counter / 2;
    }

    protected String nextRandom() {
        ++this.noRandom;
        return "random" + String.valueOf(this.noRandom / 2);
    }

    int getCounter() {
        return this.counter;
    }
}

