/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.security.security;

import io.meeds.web.security.model.TokenData;
import io.meeds.web.security.storage.PortalTokenStorage;
import java.util.Date;
import java.util.regex.Pattern;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.web.security.PortalToken;
import org.exoplatform.web.security.hash.JCASaltedHashService;
import org.exoplatform.web.security.hash.SaltedHashException;
import org.exoplatform.web.security.hash.SaltedHashService;
import org.exoplatform.web.security.security.AbstractTokenService;
import org.exoplatform.web.security.security.CookieToken;
import org.exoplatform.web.security.security.TokenExistsException;
import org.exoplatform.web.security.security.TokenParseException;

public class CookieTokenService
extends AbstractTokenService<PortalToken, String> {
    public static final String LIFECYCLE_NAME = "lifecycle-name";
    public static final String HASH_SERVICE_INIT_PARAM = "hash.service";
    public static final String ONBOARD_TOKEN = "onboard";
    public static final String EMAIL_VALIDATION_TOKEN = "email-validation";
    public static final String FORGOT_PASSWORD_TOKEN = "forgot-password";
    public static final String EXTERNAL_REGISTRATION_TOKEN = "external-registration";
    public static final String SEPARATOR_CHAR = ".";
    private PortalTokenStorage tokenStore;
    private SaltedHashService saltedHashService;

    public CookieTokenService(InitParams initParams, PortalTokenStorage tokenStore) {
        super(initParams);
        this.tokenStore = tokenStore;
        ObjectParameter hashServiceParam = initParams.getObjectParam(HASH_SERVICE_INIT_PARAM);
        this.saltedHashService = hashServiceParam == null || hashServiceParam.getObject() == null ? new JCASaltedHashService() : (SaltedHashService)hashServiceParam.getObject();
    }

    @Override
    public String createToken(String username) {
        return this.createToken(username, "");
    }

    public String createToken(String username, String type) {
        if (this.validityMillis < 0L) {
            throw new IllegalArgumentException();
        }
        if (username == null) {
            throw new NullPointerException();
        }
        String cookieTokenString = null;
        while (cookieTokenString == null) {
            String selector = this.nextTokenId();
            String validator = this.nextRandom();
            String hashedRandomString = this.hashToken(validator + SEPARATOR_CHAR + type);
            long expirationTimeMillis = System.currentTimeMillis() + this.validityMillis;
            cookieTokenString = selector + SEPARATOR_CHAR + validator;
            try {
                this.tokenStore.createToken(new TokenData(selector, hashedRandomString, username, new Date(expirationTimeMillis), type));
            }
            catch (TokenExistsException e) {
                cookieTokenString = null;
            }
        }
        return cookieTokenString;
    }

    @Override
    protected String nextTokenId() {
        return this.nextRandom();
    }

    @Override
    public PortalToken getToken(String cookieTokenString, String tokenType) {
        try {
            String[] splittedToken;
            String validator;
            String tokenRandomString;
            CookieToken token = new CookieToken(cookieTokenString);
            TokenData encryptedToken = this.tokenStore.getToken(token.getId());
            if (encryptedToken != null && cookieTokenString.contains(SEPARATOR_CHAR) && this.saltedHashService.validate(tokenRandomString = (validator = (splittedToken = cookieTokenString.split(Pattern.quote(SEPARATOR_CHAR)))[1]) + SEPARATOR_CHAR + tokenType, encryptedToken.getHash())) {
                return new PortalToken(encryptedToken.getExpirationTime().getTime(), encryptedToken.getUsername());
            }
        }
        catch (SaltedHashException e) {
            this.log.warn((Object)"Could not validate cookie token against its salted hash.", (Throwable)e);
        }
        catch (TokenParseException e) {
            this.log.warn((Object)("Could not parse cookie token:" + e.getMessage()));
        }
        return null;
    }

    @Override
    public PortalToken getToken(String id) {
        return this.getToken(id, "");
    }

    @Override
    public PortalToken deleteToken(String cookieTokenString) {
        return this.deleteToken(cookieTokenString, "");
    }

    @Override
    public PortalToken deleteToken(String cookieTokenString, String tokenType) {
        try {
            PortalToken result = this.getToken(cookieTokenString, tokenType);
            if (result != null) {
                CookieToken token = new CookieToken(cookieTokenString);
                this.tokenStore.deleteToken(token.getId());
                return result;
            }
        }
        catch (TokenParseException e) {
            this.log.warn((Object)("Could not parse cookie token:" + e.getMessage()));
        }
        return null;
    }

    public void deleteTokensOfUser(String user) {
        this.tokenStore.deleteTokenOfUser(user);
    }

    public void deleteTokensByUsernameAndType(String username, String tokenType) {
        this.tokenStore.deleteTokensByUsernameAndType(username, tokenType);
    }

    public void deleteAll() {
        this.tokenStore.deleteAll();
    }

    @Override
    public void cleanExpiredTokens() {
        this.tokenStore.cleanExpired();
    }

    @Override
    public long size() {
        return this.tokenStore.size();
    }

    @Override
    protected String decodeKey(String stringKey) {
        return stringKey;
    }

    private String hashToken(String tokenId) {
        if (this.saltedHashService != null) {
            return this.saltedHashService.getSaltedHash(tokenId);
        }
        return tokenId;
    }
}

