/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.security;

import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.web.security.AbstractTokenServiceTest;
import org.exoplatform.web.security.PortalToken;
import org.exoplatform.web.security.security.CookieTokenService;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.security-configuration-local.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.identity-configuration-local.xml")})
public abstract class AbstractCookieTokenServiceTest
extends AbstractTokenServiceTest<CookieTokenService> {
    public String type = "testType";

    @Override
    public void testGetToken() throws Exception {
        String tokenId = ((CookieTokenService)this.service).createToken("root");
        AbstractCookieTokenServiceTest.assertEquals((long)((CookieTokenService)this.service).getValidityTime(), (long)2L);
        PortalToken token = ((CookieTokenService)this.service).getToken(tokenId);
        AbstractCookieTokenServiceTest.assertEquals((String)token.getUsername(), (String)"root");
        ((CookieTokenService)this.service).deleteToken(tokenId);
    }

    @Override
    public void testGetAllToken() throws Exception {
    }

    @Override
    public void testSize() throws Exception {
        String token = ((CookieTokenService)this.service).createToken("root");
        AbstractCookieTokenServiceTest.assertEquals((long)((CookieTokenService)this.service).size(), (long)1L);
        ((CookieTokenService)this.service).deleteToken(token);
    }

    @Override
    public void testDeleteToken() throws Exception {
        String tokenId = ((CookieTokenService)this.service).createToken("root");
        PortalToken deletedToken = ((CookieTokenService)this.service).deleteToken(tokenId);
        AbstractCookieTokenServiceTest.assertNotNull((Object)deletedToken);
        AbstractCookieTokenServiceTest.assertNotSame((Object)((CookieTokenService)this.service).getToken(tokenId), (Object)deletedToken);
        AbstractCookieTokenServiceTest.assertNull((Object)((CookieTokenService)this.service).getToken(tokenId));
        AbstractCookieTokenServiceTest.assertEquals((long)0L, (long)((CookieTokenService)this.service).size());
        ((CookieTokenService)this.service).deleteToken(tokenId);
    }

    @Override
    public void testCleanExpiredTokens() throws Exception {
        AbstractCookieTokenServiceTest.assertEquals((long)2L, (long)((CookieTokenService)this.service).getValidityTime());
        String tokenId1 = ((CookieTokenService)this.service).createToken("user1");
        AbstractCookieTokenServiceTest.assertEquals((long)1L, (long)((CookieTokenService)this.service).size());
        Thread.sleep(2100L);
        ((CookieTokenService)this.service).cleanExpiredTokens();
        AbstractCookieTokenServiceTest.assertEquals((long)0L, (long)((CookieTokenService)this.service).size());
        ((CookieTokenService)this.service).deleteToken(tokenId1);
    }

    @Override
    public void testGetTokenWithType() throws Exception {
        String tokenId = ((CookieTokenService)this.service).createToken("root", this.type);
        AbstractCookieTokenServiceTest.assertEquals((long)((CookieTokenService)this.service).getValidityTime(), (long)2L);
        PortalToken token = ((CookieTokenService)this.service).getToken(tokenId, this.type);
        AbstractCookieTokenServiceTest.assertEquals((String)token.getUsername(), (String)"root");
        ((CookieTokenService)this.service).deleteToken(tokenId, this.type);
    }

    @Override
    public void testGetTokenWithWrongType() throws Exception {
        String tokenId = ((CookieTokenService)this.service).createToken("root", this.type);
        AbstractCookieTokenServiceTest.assertEquals((long)((CookieTokenService)this.service).getValidityTime(), (long)2L);
        PortalToken token = ((CookieTokenService)this.service).getToken(tokenId, "otherType");
        AbstractCookieTokenServiceTest.assertNull((Object)token);
        ((CookieTokenService)this.service).deleteToken(tokenId, this.type);
    }

    @Override
    public void testGetAllTokenWithType() throws Exception {
    }

    @Override
    public void testSizeWithType() throws Exception {
        String token = ((CookieTokenService)this.service).createToken("root", this.type);
        AbstractCookieTokenServiceTest.assertEquals((long)((CookieTokenService)this.service).size(), (long)1L);
        ((CookieTokenService)this.service).deleteToken(token, this.type);
    }

    @Override
    public void testDeleteTokenWithType() throws Exception {
        String tokenId = ((CookieTokenService)this.service).createToken("root", this.type);
        PortalToken deletedToken = ((CookieTokenService)this.service).deleteToken(tokenId, this.type);
        AbstractCookieTokenServiceTest.assertNotNull((Object)deletedToken);
        AbstractCookieTokenServiceTest.assertNotSame((Object)((CookieTokenService)this.service).getToken(tokenId, this.type), (Object)deletedToken);
        AbstractCookieTokenServiceTest.assertNull((Object)((CookieTokenService)this.service).getToken(tokenId, this.type));
        AbstractCookieTokenServiceTest.assertEquals((long)0L, (long)((CookieTokenService)this.service).size());
        ((CookieTokenService)this.service).deleteToken(tokenId, this.type);
    }

    @Override
    public void testCleanExpiredTokensWithType() throws Exception {
        AbstractCookieTokenServiceTest.assertEquals((long)2L, (long)((CookieTokenService)this.service).getValidityTime());
        String tokenId1 = ((CookieTokenService)this.service).createToken("user1", this.type);
        AbstractCookieTokenServiceTest.assertEquals((long)1L, (long)((CookieTokenService)this.service).size());
        Thread.sleep(2100L);
        ((CookieTokenService)this.service).cleanExpiredTokens();
        AbstractCookieTokenServiceTest.assertEquals((long)0L, (long)((CookieTokenService)this.service).size());
        ((CookieTokenService)this.service).deleteToken(tokenId1, this.type);
    }

    public void testDeleteAll() {
        ((CookieTokenService)this.service).createToken("root", this.type);
        AbstractCookieTokenServiceTest.assertEquals((long)1L, (long)((CookieTokenService)this.service).size());
        ((CookieTokenService)this.service).deleteAll();
        AbstractCookieTokenServiceTest.assertEquals((long)0L, (long)((CookieTokenService)this.service).size());
    }

    public void testDeleteTokensByUsernameAndType() {
        ((CookieTokenService)this.service).createToken("root", this.type);
        AbstractCookieTokenServiceTest.assertEquals((long)1L, (long)((CookieTokenService)this.service).size());
        ((CookieTokenService)this.service).deleteTokensByUsernameAndType("root", this.type);
        AbstractCookieTokenServiceTest.assertEquals((long)0L, (long)((CookieTokenService)this.service).size());
    }

    public void testDeleteTokenOfUser() {
        ((CookieTokenService)this.service).createToken("root", this.type);
        AbstractCookieTokenServiceTest.assertEquals((long)1L, (long)((CookieTokenService)this.service).size());
        ((CookieTokenService)this.service).deleteTokensOfUser("root");
        AbstractCookieTokenServiceTest.assertEquals((long)0L, (long)((CookieTokenService)this.service).size());
    }
}

