/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.security.errorlogin;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.mail.MailService;
import org.exoplatform.web.security.errorlogin.InvalidAttemptKey;
import org.exoplatform.web.security.errorlogin.InvalidLoginPolicy;

public class InvalidLoginAttemptsService {
    private static final Log log = ExoLogger.getLogger(InvalidLoginAttemptsService.class);
    private final Boolean sendMailEnabled;
    private final Integer numberOfFailedAttempts;
    private InvalidLoginPolicy invalidLoginPolicy;
    private final String mailFrom;
    private final String mailTo;
    private final String mailSubject;
    private final String mailMessage;
    private final MailService mailService;
    private final ConcurrentMap<InvalidAttemptKey, Integer> attemptMap = new ConcurrentHashMap<InvalidAttemptKey, Integer>();

    public InvalidLoginAttemptsService(InitParams params, MailService mailService) {
        this.mailService = mailService;
        this.sendMailEnabled = Boolean.valueOf(params.getValueParam("sendingMailsEnabled").getValue());
        this.numberOfFailedAttempts = Integer.parseInt(params.getValueParam("numberOfFailedAttempts").getValue());
        this.invalidLoginPolicy = InvalidLoginPolicy.valueOf(params.getValueParam("invalidLoginPolicy").getValue());
        this.mailFrom = params.getValueParam("mailFrom").getValue();
        this.mailTo = params.getValueParam("mailTo").getValue();
        this.mailSubject = params.getValueParam("mailSubject").getValue();
        this.mailMessage = params.getPropertiesParam("mailMessage").getProperty(this.invalidLoginPolicy.toString());
    }

    public void badLoginAttempt(String sessionId, String username, String hostname) {
        if (log.isDebugEnabled()) {
            log.debug((Object)new StringBuilder("Detected invalid login attempt. Session id=").append(sessionId).append(", username=").append(username).append(", hostname=").append(hostname));
        }
        if (this.numberOfFailedAttempts == 1) {
            this.sendMail(sessionId, username, hostname);
            return;
        }
        InvalidAttemptKey key = InvalidAttemptKey.createKey(this.invalidLoginPolicy, sessionId, username, hostname);
        int currentCount = 1;
        if (this.attemptMap.containsKey(key)) {
            currentCount = (Integer)this.attemptMap.get(key) + 1;
            if (currentCount == this.numberOfFailedAttempts) {
                this.sendMail(sessionId, username, hostname);
                this.attemptMap.remove(key);
            } else {
                this.attemptMap.put(key, currentCount);
            }
        } else {
            this.attemptMap.put(key, currentCount);
        }
    }

    public void successfulLoginAttempt(String sessionId, String username, String hostname) {
        if (log.isDebugEnabled()) {
            log.debug((Object)new StringBuilder("Detected successful login attempt. Session id=").append(sessionId).append(", username=").append(username).append(", hostname=").append(hostname));
        }
        InvalidAttemptKey key = InvalidAttemptKey.createKey(this.invalidLoginPolicy, sessionId, username, hostname);
        this.attemptMap.remove(key);
    }

    public void setInvalidLoginPolicy(InvalidLoginPolicy invalidLoginPolicy) {
        this.invalidLoginPolicy = invalidLoginPolicy;
    }

    private void sendMail(String sessionId, String username, String hostname) {
        if (!this.sendMailEnabled.booleanValue()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Sending of mails disabled. Mail won't be send about invalid login attempts.");
            }
            return;
        }
        String result = this.mailMessage.replaceAll("\\$\\{sessionId\\}", sessionId);
        result = result.replaceAll("\\$\\{username\\}", username);
        result = result.replaceAll("\\$\\{hostname\\}", hostname);
        result = result.replaceAll("\\$\\{number\\}", String.valueOf(this.numberOfFailedAttempts));
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sending mail about the invalid login attempts. Mail message is: " + result));
            }
            this.mailService.sendMessage(this.mailFrom, this.mailTo, this.mailSubject, result);
        }
        catch (Exception e) {
            log.error((Object)"Error when sending mail to admin after detected invalid number of login attempts.", (Throwable)e);
        }
    }
}

