/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.web.security.service;

import io.meeds.web.security.plugin.OtpPlugin;
import java.io.Serializable;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class OtpService {
    private static final String OTP_TENTATIVES_CACHE_NAME = "otp.tentatives";
    @Autowired
    private CacheService cacheService;
    @Autowired(required=false)
    private List<OtpPlugin> otpPlugins;
    @Value(value="${meeds.apiKey.otp.maxTentatives.ttl:5}")
    private long otpTentativesTtl;
    @Value(value="${meeds.apiKey.otp.maxTentatives.count:5}")
    private long otpMaxTentatives;
    private ExoCache<String, Long> otpTentativeCache;

    public void sendOtpCode(String userName, String otpMethod) {
        OtpPlugin otpPlugin = this.getOtpPlugin(otpMethod);
        if (otpPlugin == null) {
            throw new IllegalAccessException();
        }
        otpPlugin.generateOtpCode(userName);
    }

    public void validateOtp(String userName, String otpMethod, String otpCode) throws IllegalAccessException {
        if (StringUtils.isBlank((CharSequence)otpCode)) {
            throw new IllegalAccessException();
        }
        OtpPlugin otpPlugin = this.getOtpPlugin(otpMethod);
        long tentativeCount = this.getOtpTentativeCount(userName);
        if (tentativeCount >= this.otpMaxTentatives) {
            throw new IllegalAccessException();
        }
        if (otpPlugin == null || !otpPlugin.validateOtp(userName, otpCode)) {
            this.getOtpTentativeCache().put((Serializable)((Object)userName), (Object)(tentativeCount + 1L));
            throw new IllegalAccessException();
        }
        this.getOtpTentativeCache().remove((Serializable)((Object)userName));
    }

    private long getOtpTentativeCount(String userName) {
        Long tentativeCount = (Long)this.getOtpTentativeCache().get((Serializable)((Object)userName));
        if (tentativeCount == null) {
            return 0L;
        }
        return tentativeCount;
    }

    private OtpPlugin getOtpPlugin(String otpMethod) {
        return this.otpPlugins.stream().filter(p -> p.getName().equals(otpMethod)).findFirst().orElse(null);
    }

    private ExoCache<String, Long> getOtpTentativeCache() {
        if (this.otpTentativeCache == null) {
            this.otpTentativeCache = this.cacheService.getCacheInstance(OTP_TENTATIVES_CACHE_NAME);
            this.otpTentativeCache.setLiveTime(this.otpTentativesTtl * 60L);
        }
        return this.otpTentativeCache;
    }

    @Generated
    public List<OtpPlugin> getOtpPlugins() {
        return this.otpPlugins;
    }

    @Generated
    public void setOtpPlugins(List<OtpPlugin> otpPlugins) {
        this.otpPlugins = otpPlugins;
    }

    @Generated
    public long getOtpTentativesTtl() {
        return this.otpTentativesTtl;
    }

    @Generated
    public void setOtpTentativesTtl(long otpTentativesTtl) {
        this.otpTentativesTtl = otpTentativesTtl;
    }

    @Generated
    public long getOtpMaxTentatives() {
        return this.otpMaxTentatives;
    }

    @Generated
    public void setOtpMaxTentatives(long otpMaxTentatives) {
        this.otpMaxTentatives = otpMaxTentatives;
    }
}

