/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.web.security.authenticator;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import org.apache.tomcat.util.buf.HexUtils;
import org.apache.tomcat.util.security.ConcurrentMessageDigest;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.Identity;
import org.exoplatform.web.security.codec.CodecInitializer;
import org.exoplatform.web.security.security.SecureRandomService;

public class DigestAuthenticatorService {
    private static final String CACHE_NAME = "digest.encryptedTemporaryPassword";
    private static final String UPPERCASE_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String LOWERCASE_CHARS = "abcdefghijklmnopqrstuvwxyz";
    private static final String DIGIT_CHARS = "0123456789";
    private static final String SPECIAL_CHARS = "!@#$%&*?";
    private CodecInitializer encrypter;
    private Authenticator authenticator;
    private SecureRandom secureRandom;
    private ExoCache<String, String> cache;

    public DigestAuthenticatorService(SecureRandomService secureRandomService, CacheService cacheService, Authenticator authenticator, CodecInitializer encrypter, InitParams initParams) {
        this.authenticator = authenticator;
        this.encrypter = encrypter;
        this.secureRandom = secureRandomService.getSecureRandom();
        String ttl = initParams.getValueParam("password.ttl").getValue();
        String cacheSize = initParams.getValueParam("password.cacheSize").getValue();
        this.cache = cacheService.getCacheInstance(CACHE_NAME);
        this.cache.setLiveTime(Long.parseLong(ttl));
        this.cache.setMaxSize(Integer.parseInt(cacheSize));
    }

    public Identity createIdentity(String userName) {
        return this.authenticator.createIdentity(userName);
    }

    public String generatePassword(String userName) {
        String password = this.getPassword(userName);
        if (password == null) {
            password = String.valueOf(this.generateSecurePassword(20));
            this.cache.put((Serializable)((Object)userName), (Object)this.encrypter.getCodec().encode(password));
        }
        return password;
    }

    public String validateUser(String userName, String clientDigest, String nonce, String nc, String cnonce, String qop, String realm, String digestA2, String algorithm) {
        String digestA1 = this.getDigest(userName, realm, algorithm);
        digestA1 = digestA1.toLowerCase(Locale.ENGLISH);
        String serverDigestValue = qop == null ? digestA1 + ":" + nonce + ":" + digestA2 : digestA1 + ":" + nonce + ":" + nc + ":" + cnonce + ":" + qop + ":" + digestA2;
        byte[] valueBytes = serverDigestValue.getBytes(StandardCharsets.UTF_8);
        String serverDigest = HexUtils.toHexString((byte[])ConcurrentMessageDigest.digest((String)algorithm, (byte[][])new byte[][]{valueBytes}));
        if (serverDigest.equals(clientDigest)) {
            return userName;
        }
        return null;
    }

    protected String getDigest(String userName, String realmName, String algorithm) {
        String clearTextPassword = this.getPassword(userName);
        if (clearTextPassword == null) {
            throw new IllegalStateException(String.format("No generated password for user '%s'", userName));
        }
        String digestValue = userName + ":" + realmName + ":" + clearTextPassword;
        byte[] valueBytes = digestValue.getBytes(StandardCharsets.UTF_8);
        return HexUtils.toHexString((byte[])ConcurrentMessageDigest.digest((String)algorithm, (byte[][])new byte[][]{valueBytes}));
    }

    private String getPassword(String userName) {
        String encryptedPassword = (String)this.cache.get((Serializable)((Object)userName));
        return encryptedPassword == null ? null : this.encrypter.getCodec().decode(encryptedPassword);
    }

    private String generateSecurePassword(int length) {
        ArrayList<Character> charPool = new ArrayList<Character>();
        String allChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%&*?";
        for (int i = 0; i < length - 4; ++i) {
            charPool.add(Character.valueOf(this.getRandomChar(allChars, this.secureRandom)));
        }
        charPool.add(Character.valueOf(this.getRandomChar(UPPERCASE_CHARS, this.secureRandom)));
        charPool.add(Character.valueOf(this.getRandomChar(LOWERCASE_CHARS, this.secureRandom)));
        charPool.add(Character.valueOf(this.getRandomChar(DIGIT_CHARS, this.secureRandom)));
        charPool.add(Character.valueOf(this.getRandomChar(SPECIAL_CHARS, this.secureRandom)));
        Collections.shuffle(charPool, this.secureRandom);
        StringBuilder finalPassword = new StringBuilder();
        charPool.forEach(finalPassword::append);
        return finalPassword.toString();
    }

    private char getRandomChar(String charSet, SecureRandom random) {
        int index = random.nextInt(charSet.length());
        return charSet.charAt(index);
    }
}

