/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.web.security.service;

import io.meeds.web.security.service.ApiKeyService;
import io.meeds.web.security.service.OtpService;
import io.meeds.web.security.storage.ApiKeyStorage;
import java.security.SecureRandom;
import java.util.Base64;
import org.exoplatform.web.security.codec.AbstractCodec;
import org.exoplatform.web.security.codec.CodecInitializer;
import org.exoplatform.web.security.security.SecureRandomService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ApiKeyServiceTest {
    private static final String USER2 = "user2";
    private static final String USER1 = "user1";
    private static final String PASSWORD = "existingPass";
    @Mock
    private ApiKeyStorage apiKeyStorage;
    @Mock
    private OtpService otpService;
    @Mock
    private CodecInitializer encrypter;
    @Mock
    private AbstractCodec codec;
    @Mock
    private SecureRandomService secureRandomService;
    @Mock
    private SecureRandom secureRandom;
    @InjectMocks
    private ApiKeyService service;

    @Before
    public void setUp() {
        Mockito.when((Object)this.encrypter.getCodec()).thenReturn((Object)this.codec);
        Mockito.when((Object)this.secureRandom.nextInt(ArgumentMatchers.anyInt())).thenAnswer(invocation -> 0);
        this.service.setApiKeyLength(20L);
    }

    @Test
    public void testGetPasswordKeyAlreadyExistsNoRenew() {
        String encrypted = Base64.getEncoder().encodeToString(PASSWORD.getBytes());
        Mockito.when((Object)this.apiKeyStorage.getKey(USER1)).thenReturn((Object)encrypted);
        Mockito.when((Object)this.codec.decode(encrypted)).thenReturn((Object)PASSWORD);
        String result = this.service.getPassword(USER1, "email", "otp123", false);
        ((OtpService)Mockito.verify((Object)this.otpService)).validateOtp(USER1, "email", "otp123");
        Assert.assertEquals((Object)PASSWORD, (Object)result);
        ((ApiKeyStorage)Mockito.verify((Object)this.apiKeyStorage, (VerificationMode)Mockito.never())).saveKey(ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
    }

    @Test
    public void testGetPasswordKeyNotExistsOrRenew() {
        Mockito.when((Object)this.codec.encode(ArgumentMatchers.anyString())).thenAnswer(invocation -> {
            String plain = (String)invocation.getArgument(0);
            return "ENC(" + plain + ")";
        });
        String result = this.service.getPassword(USER2, "sms", "otp456", true);
        ((OtpService)Mockito.verify((Object)this.otpService)).validateOtp(USER2, "sms", "otp456");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)20L, (long)result.length());
        ((ApiKeyStorage)Mockito.verify((Object)this.apiKeyStorage)).saveKey((String)ArgumentMatchers.eq((Object)USER2), ArgumentMatchers.startsWith((String)"ENC("));
    }

    @Test
    public void testGetPasswordSimple() {
        String encrypted = "ENCODED";
        Mockito.when((Object)this.apiKeyStorage.getKey("user3")).thenReturn((Object)encrypted);
        Mockito.when((Object)this.codec.decode(encrypted)).thenReturn((Object)"decodedPass");
        String result = this.service.getPassword("user3");
        Assert.assertEquals((Object)"decodedPass", (Object)result);
    }

    @Test
    public void testGeneratePasswordContainsAllCharTypes() {
        Mockito.when((Object)this.secureRandom.nextInt(ArgumentMatchers.anyInt())).thenAnswer(invocation -> {
            int bound = (Integer)invocation.getArgument(0);
            return bound / 2;
        });
        String password = this.service.getPassword("user4", "app", "otp789", true);
        Assert.assertEquals((long)this.service.getApiKeyLength(), (long)password.length());
        Assert.assertTrue((boolean)password.chars().anyMatch(ch -> "ABCDEFGHIJKLMNOPQRSTUVWXYZ".indexOf(ch) >= 0));
        Assert.assertTrue((boolean)password.chars().anyMatch(ch -> "abcdefghijklmnopqrstuvwxyz".indexOf(ch) >= 0));
        Assert.assertTrue((boolean)password.chars().anyMatch(ch -> "0123456789".indexOf(ch) >= 0));
        Assert.assertTrue((boolean)password.chars().anyMatch(ch -> "!@#$%&*?".indexOf(ch) >= 0));
    }
}

