/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.web.security.authenticator;

import io.meeds.web.security.authenticator.DigestLoginModule;
import io.meeds.web.security.service.DigestAuthenticatorService;
import java.security.Principal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DigestLoginModuleTest {
    private static final String SECRET = "secret";
    @Mock
    private DigestAuthenticatorService digestService;
    @Mock
    private IdentityRegistry identityRegistry;
    @Mock
    private ExoContainer container;
    @Mock
    private Identity identity;
    private DigestLoginModule module;
    private Subject subject;

    @Before
    public void setUp() {
        this.module = new DigestLoginModule(){

            protected ExoContainer getContainer() {
                return DigestLoginModuleTest.this.container;
            }
        };
        DigestLoginModule.digestAuthenticatorService = null;
        DigestLoginModule.identityRegistry = null;
        Mockito.when((Object)((DigestAuthenticatorService)this.container.getComponentInstanceOfType(DigestAuthenticatorService.class))).thenReturn((Object)this.digestService);
        Mockito.when((Object)((IdentityRegistry)this.container.getComponentInstanceOfType(IdentityRegistry.class))).thenReturn((Object)this.identityRegistry);
        this.subject = new Subject();
        HashMap sharedState = new HashMap();
        try {
            this.module.initialize(this.subject, this.createTestCallbackHandler(), sharedState, new HashMap());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Mockito.when((Object)this.identity.getUserId()).thenReturn((Object)"john");
        Mockito.when((Object)this.identity.getRoles()).thenReturn(Arrays.asList("users", "admin"));
    }

    @Test
    public void testLoginAndCommitSuccess() {
        Mockito.when((Object)this.digestService.validateUser(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)"john");
        Mockito.when((Object)this.digestService.createIdentity("john")).thenReturn((Object)this.identity);
        boolean loginResult = this.module.login();
        Assert.assertTrue((String)"Login should succeed", (boolean)loginResult);
        boolean commitResult = this.module.commit();
        Assert.assertTrue((String)"Commit should succeed", (boolean)commitResult);
        ((IdentityRegistry)Mockito.verify((Object)this.identityRegistry)).register(this.identity);
        Set<Principal> principals = this.subject.getPrincipals();
        Assert.assertTrue((boolean)principals.stream().anyMatch(r -> r.getName().equals("users")));
        Assert.assertTrue((boolean)principals.stream().anyMatch(r -> r.getName().equals("admin")));
        Assert.assertTrue((boolean)principals.stream().anyMatch(r -> r.getName().equals("john")));
    }

    @Test
    public void testLoginFailsWhenValidationFails() {
        Mockito.when((Object)this.digestService.validateUser(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn(null);
        boolean loginResult = this.module.login();
        Assert.assertFalse((String)"Login should fail when validateUser returns null", (boolean)loginResult);
    }

    @Test
    public void testCommitFailsWhenIdentityIsNull() {
        boolean commitResult = this.module.commit();
        Assert.assertFalse((String)"Commit should fail when identity is null", (boolean)commitResult);
    }

    private CallbackHandler createTestCallbackHandler() {
        return callbacks -> {
            ((NameCallback)callbacks[0]).setName("john");
            ((PasswordCallback)callbacks[1]).setPassword(SECRET.toCharArray());
            ((TextInputCallback)callbacks[2]).setText("nonceVal");
            ((TextInputCallback)callbacks[3]).setText("ncVal");
            ((TextInputCallback)callbacks[4]).setText("cnonceVal");
            ((TextInputCallback)callbacks[5]).setText("auth");
            ((TextInputCallback)callbacks[6]).setText("realm");
            ((TextInputCallback)callbacks[7]).setText("digestA2Val");
            ((TextInputCallback)callbacks[8]).setText("MD5");
            ((TextInputCallback)callbacks[9]).setText("BASIC");
        };
    }
}

