/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.web.security.service;

import io.meeds.web.security.service.ApiKeyService;
import io.meeds.web.security.service.DigestAuthenticatorService;
import java.nio.charset.StandardCharsets;
import org.apache.tomcat.util.buf.HexUtils;
import org.apache.tomcat.util.security.ConcurrentMessageDigest;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.Identity;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DigestAuthenticatorServiceTest {
    private static final String PATH_EXAMPLE = "/path/to/resource";
    private static final String ALGORITHM = "MD5";
    private static final String DIGEST = "digestA2";
    private static final String REALM = "realm";
    private static final String PASSWORD = "secret";
    @Mock
    private ApiKeyService apiKeyService;
    @Mock
    private Authenticator authenticator;
    @Mock
    private Identity identity;
    private DigestAuthenticatorService service;

    @Before
    public void setUp() {
        this.service = new DigestAuthenticatorService(this.apiKeyService, this.authenticator);
    }

    @Test
    public void testCreateIdentity() {
        Mockito.when((Object)this.authenticator.createIdentity("john")).thenReturn((Object)this.identity);
        Identity result = this.service.createIdentity("john");
        Assert.assertSame((Object)this.identity, (Object)result);
        ((Authenticator)Mockito.verify((Object)this.authenticator)).createIdentity("john");
    }

    @Test
    public void testValidateUserMatchingDigestNoQop() {
        String userName = "john";
        String realm = "myRealm";
        String algorithm = ALGORITHM;
        Mockito.when((Object)this.apiKeyService.getPassword(userName)).thenReturn((Object)PASSWORD);
        String digestA1 = HexUtils.toHexString((byte[])ConcurrentMessageDigest.digest((String)algorithm, (byte[][])new byte[][]{(userName + ":" + realm + ":secret").getBytes(StandardCharsets.UTF_8)})).toLowerCase();
        String digestA2 = PATH_EXAMPLE;
        String nonce = "abc123";
        String serverDigestValue = digestA1 + ":" + nonce + ":" + digestA2;
        String clientDigest = HexUtils.toHexString((byte[])ConcurrentMessageDigest.digest((String)algorithm, (byte[][])new byte[][]{serverDigestValue.getBytes(StandardCharsets.UTF_8)}));
        String result = this.service.validateUser(userName, clientDigest, nonce, null, null, null, realm, digestA2, algorithm);
        Assert.assertEquals((Object)userName, (Object)result);
    }

    @Test
    public void testValidateUserMatchingDigestWithQop() {
        String userName = "john";
        String realm = "myRealm";
        String algorithm = ALGORITHM;
        String password = PASSWORD;
        Mockito.when((Object)this.apiKeyService.getPassword(userName)).thenReturn((Object)password);
        String digestA1 = HexUtils.toHexString((byte[])ConcurrentMessageDigest.digest((String)algorithm, (byte[][])new byte[][]{(userName + ":" + realm + ":" + password).getBytes(StandardCharsets.UTF_8)})).toLowerCase();
        String digestA2 = PATH_EXAMPLE;
        String nonce = "abc123";
        String nc = "0001";
        String cnonce = "xyz789";
        String qop = "auth";
        String serverDigestValue = digestA1 + ":" + nonce + ":" + nc + ":" + cnonce + ":" + qop + ":" + digestA2;
        String clientDigest = HexUtils.toHexString((byte[])ConcurrentMessageDigest.digest((String)algorithm, (byte[][])new byte[][]{serverDigestValue.getBytes(StandardCharsets.UTF_8)}));
        String result = this.service.validateUser(userName, clientDigest, nonce, nc, cnonce, qop, realm, digestA2, algorithm);
        Assert.assertEquals((Object)userName, (Object)result);
    }

    @Test
    public void testValidateUserNonMatchingDigest() {
        Mockito.when((Object)this.apiKeyService.getPassword("john")).thenReturn((Object)PASSWORD);
        String result = this.service.validateUser("john", "wrongDigest", "nonce", null, null, null, REALM, DIGEST, ALGORITHM);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testGetDigestReturnsHash() {
        String userName = "john";
        String realm = REALM;
        String algorithm = ALGORITHM;
        String password = PASSWORD;
        Mockito.when((Object)this.apiKeyService.getPassword(userName)).thenReturn((Object)password);
        String expected = HexUtils.toHexString((byte[])ConcurrentMessageDigest.digest((String)algorithm, (byte[][])new byte[][]{(userName + ":" + realm + ":" + password).getBytes(StandardCharsets.UTF_8)}));
        String actual = this.service.getDigest(userName, realm, algorithm);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test(expected=IllegalStateException.class)
    public void testGetDigestNoPasswordThrowsException() {
        Mockito.when((Object)this.apiKeyService.getPassword("john")).thenReturn(null);
        this.service.getDigest("john", REALM, ALGORITHM);
    }
}

