/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.spring.web.security;

import jakarta.servlet.http.HttpServletRequest;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.StateKey;
import org.exoplatform.services.security.jaas.UserPrincipal;
import org.exoplatform.services.security.web.HttpSessionStateKey;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.jaas.JaasGrantedAuthority;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class PortalAuthenticationManager
implements AuthenticationProvider {
    private static OrganizationService organizationService;
    private static ConversationRegistry conversationRegistry;
    private static IdentityRegistry identityRegistry;
    private static Authenticator authenticator;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        HttpServletRequest request = requestAttributes.getRequest();
        try {
            Object object;
            Identity identity = this.getCurrentIdentity(request);
            if (this.isAnonymousUser(identity) && (object = authentication.getPrincipal()) instanceof String) {
                String username = (String)object;
                identity = this.getCurrentIdentity(request, username);
            }
            if (this.isAnonymousUser(identity)) {
                return new AnonymousAuthenticationToken(IdentityConstants.ANONIM, (Object)IdentityConstants.ANONIM, Collections.singletonList(new JaasGrantedAuthority("guests", (Principal)new UserPrincipal(IdentityConstants.ANONIM))));
            }
            UserPrincipal userPrincipal = new UserPrincipal(identity.getUserId());
            List<GrantedAuthority> authorities = this.getAuthorities(identity, (Principal)userPrincipal);
            List<GrantedAuthority> extendedAuthorities = this.getExtendedAuthorities((Principal)userPrincipal);
            if (CollectionUtils.isNotEmpty(extendedAuthorities)) {
                authorities = new ArrayList<GrantedAuthority>(authorities);
                authorities.addAll(extendedAuthorities);
            }
            return new PreAuthenticatedAuthenticationToken((Object)userPrincipal, (Object)identity.getUserId(), authorities);
        }
        catch (Exception e) {
            throw new AuthenticationServiceException("An unknown error is encountered while authenticating user", (Throwable)e);
        }
    }

    public boolean supports(Class<?> authentication) {
        return true;
    }

    private Identity getCurrentIdentity(HttpServletRequest httpRequest) throws Exception {
        ConversationState state = ConversationState.getCurrent();
        if (state == null) {
            return this.getCurrentIdentity(httpRequest, httpRequest.getRemoteUser());
        }
        return state.getIdentity();
    }

    private Identity getCurrentIdentity(HttpServletRequest httpRequest, String userId) throws Exception {
        if (userId != null) {
            HttpSessionStateKey stateKey = new HttpSessionStateKey(httpRequest.getSession());
            ConversationState state = this.getStateBySessionId(userId, (StateKey)stateKey);
            if (state == null) {
                state = this.buildState(userId, (StateKey)stateKey);
            }
            return state == null ? null : state.getIdentity();
        }
        return new Identity(IdentityConstants.ANONIM);
    }

    protected List<GrantedAuthority> getExtendedAuthorities(Principal userPrincipal) {
        return Collections.emptyList();
    }

    private List<GrantedAuthority> getAuthorities(Identity identity, Principal principal) {
        return identity.getRoles().stream().map(role -> new JaasGrantedAuthority(role, principal)).toList();
    }

    private ConversationState buildState(String userId, StateKey stateKey) throws Exception {
        Identity identity = this.buildIdentity(userId);
        if (identity == null) {
            return null;
        }
        return this.buildState(identity, stateKey);
    }

    private ConversationState buildState(Identity identity, StateKey stateKey) {
        ConversationState state = new ConversationState(identity);
        PortalAuthenticationManager.getConversationRegistry().register(stateKey, state);
        return state;
    }

    private Identity buildIdentity(String userId) throws Exception {
        Identity identity = PortalAuthenticationManager.getIdentityRegistry().getIdentity(userId);
        if (identity == null) {
            identity = PortalAuthenticationManager.getAuthenticator().createIdentity(userId);
            PortalAuthenticationManager.getIdentityRegistry().register(identity);
        }
        return identity;
    }

    private ConversationState getStateBySessionId(String userId, StateKey stateKey) {
        ConversationState state = PortalAuthenticationManager.getConversationRegistry().getState(stateKey);
        if (state != null && !userId.equals(state.getIdentity().getUserId())) {
            state = null;
            PortalAuthenticationManager.getConversationRegistry().unregister(stateKey, false);
        }
        return state;
    }

    private boolean isDisabledUser(String username) {
        return null == PortalAuthenticationManager.getOrganizationService().getUserHandler().findUserByName(username, UserStatus.ENABLED);
    }

    private boolean isAnonymousUser(Identity identity) {
        return identity == null || IdentityConstants.ANONIM.equals(identity.getUserId()) || !identity.isMemberOf("/platform/users") && !identity.isMemberOf("/platform/externals") || this.isDisabledUser(identity.getUserId());
    }

    private static Authenticator getAuthenticator() {
        if (authenticator == null) {
            authenticator = (Authenticator)ExoContainerContext.getService(Authenticator.class);
        }
        return authenticator;
    }

    private static IdentityRegistry getIdentityRegistry() {
        if (identityRegistry == null) {
            identityRegistry = (IdentityRegistry)ExoContainerContext.getService(IdentityRegistry.class);
        }
        return identityRegistry;
    }

    private static OrganizationService getOrganizationService() {
        if (organizationService == null) {
            organizationService = (OrganizationService)ExoContainerContext.getService(OrganizationService.class);
        }
        return organizationService;
    }

    private static ConversationRegistry getConversationRegistry() {
        if (conversationRegistry == null) {
            conversationRegistry = (ConversationRegistry)ExoContainerContext.getService(ConversationRegistry.class);
        }
        return conversationRegistry;
    }
}

