/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.security.csrf;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.Collection;
import java.util.Collections;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.web.security.csrf.CSRFTokenUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class CSRFTokenUtilTest {
    HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
    HttpSession session = (HttpSession)Mockito.mock(HttpSession.class);

    @After
    public void tearDown() {
        ConversationState.setCurrent(null);
    }

    @Test
    public void shouldGenerateTokenWhenAuthenticated() {
        this.startSessionAs("root");
        Mockito.when((Object)this.request.getRemoteUser()).thenReturn((Object)"root");
        String token = CSRFTokenUtil.getToken((HttpServletRequest)this.request);
        Assert.assertNotNull((Object)token);
    }

    @Test
    public void shouldGenerateTokenWhenNonAuthenticated() {
        this.startSessionAs("root");
        Mockito.when((Object)this.request.getRemoteUser()).thenReturn(null);
        Mockito.when((Object)this.request.getSession()).thenReturn((Object)this.session);
        Mockito.when((Object)this.session.getAttribute("portal:csrf")).thenReturn((Object)"B56F1F537F0001012F46539853E23BCD");
        String token = CSRFTokenUtil.getToken((HttpServletRequest)this.request);
        Assert.assertNotNull((Object)token);
    }

    @Test
    public void shouldGetSameTokenWhenFetchingTokenTwiceWhenAuthenticated() {
        this.startSessionAs("root");
        Mockito.when((Object)this.request.getRemoteUser()).thenReturn((Object)"root");
        String token1 = CSRFTokenUtil.getToken((HttpServletRequest)this.request);
        String token2 = CSRFTokenUtil.getToken((HttpServletRequest)this.request);
        Assert.assertNotNull((Object)token1);
        Assert.assertNotNull((Object)token2);
        Assert.assertEquals((Object)token1, (Object)token2);
    }

    @Test
    public void shouldGetSameTokenWhenFetchingTokenTwiceWhenNonAuthenticated() {
        this.startSessionAs("root");
        Mockito.when((Object)this.request.getSession()).thenReturn((Object)this.session);
        Mockito.when((Object)this.session.getAttribute("portal:csrf")).thenReturn((Object)"B56F1F537F0001012F46539853E23BCD");
        String token1 = CSRFTokenUtil.getToken((HttpServletRequest)this.request);
        String token2 = CSRFTokenUtil.getToken((HttpServletRequest)this.request);
        Assert.assertNotNull((Object)token1);
        Assert.assertNotNull((Object)token2);
        Assert.assertEquals((Object)token1, (Object)token2);
        Assert.assertEquals((Object)token1, (Object)"B56F1F537F0001012F46539853E23BCD");
    }

    @Test
    public void shouldSucceedCheckWhenSameTokenInRequestWhenAuthenticated() {
        this.startSessionAs("root");
        Mockito.when((Object)this.request.getRemoteUser()).thenReturn((Object)"root");
        String token = CSRFTokenUtil.getToken((HttpServletRequest)this.request);
        Mockito.when((Object)this.request.getParameter("portal:csrf")).thenReturn((Object)token);
        boolean check = CSRFTokenUtil.check((HttpServletRequest)this.request);
        Assert.assertTrue((boolean)check);
    }

    @Test
    public void shouldSucceedCheckWhenSameTokenInRequestWhenNonAuthenticated() {
        this.startSessionAs("root");
        Mockito.when((Object)this.request.getSession()).thenReturn((Object)this.session);
        Mockito.when((Object)this.session.getAttribute("portal:csrf")).thenReturn((Object)"B56F1F537F0001012F46539853E23BCD");
        String token = CSRFTokenUtil.getToken((HttpServletRequest)this.request);
        Mockito.when((Object)this.request.getParameter("portal:csrf")).thenReturn((Object)token);
        boolean check = CSRFTokenUtil.check((HttpServletRequest)this.request);
        Assert.assertTrue((boolean)check);
    }

    @Test
    public void shouldFailCheckWhenNoTokenInRequestWhenAuthenticated() {
        this.startSessionAs("root");
        Mockito.when((Object)this.request.getParameter("portal:csrf")).thenReturn(null);
        Mockito.when((Object)this.request.getRemoteUser()).thenReturn((Object)"root");
        boolean check = CSRFTokenUtil.check((HttpServletRequest)this.request);
        Assert.assertFalse((boolean)check);
    }

    @Test
    public void shouldFailCheckWhenNoTokenInRequestWhenNonAuthenticated() {
        this.startSessionAs("root");
        Mockito.when((Object)this.request.getSession()).thenReturn((Object)this.session);
        Mockito.when((Object)this.request.getParameter("portal:csrf")).thenReturn(null);
        Mockito.when((Object)this.request.getRemoteUser()).thenReturn(null);
        boolean check = CSRFTokenUtil.check((HttpServletRequest)this.request);
        Assert.assertFalse((boolean)check);
    }

    @Test
    public void shouldFailCheckWhenWrongTokenInRequestInAuthenticatedMode() {
        this.startSessionAs("root");
        Mockito.when((Object)this.request.getParameter("portal:csrf")).thenReturn((Object)"WrongToken");
        Mockito.when((Object)this.request.getRemoteUser()).thenReturn((Object)"root");
        boolean check = CSRFTokenUtil.check((HttpServletRequest)this.request);
        Assert.assertFalse((boolean)check);
    }

    @Test
    public void shouldFailCheckWhenWrongTokenInRequestInNonAuthenticatedMode() {
        this.startSessionAs("root");
        Mockito.when((Object)this.request.getSession()).thenReturn((Object)this.session);
        Mockito.when((Object)this.request.getParameter("portal:csrf")).thenReturn((Object)"WrongToken");
        Mockito.when((Object)this.request.getRemoteUser()).thenReturn(null);
        boolean check = CSRFTokenUtil.check((HttpServletRequest)this.request);
        Assert.assertFalse((boolean)check);
    }

    protected void startSessionAs(String user) {
        Identity identity = new Identity(user, (Collection)Collections.EMPTY_LIST);
        ConversationState state = new ConversationState(identity);
        ConversationState.setCurrent((ConversationState)state);
    }
}

