/*
 * Decompiled with CFR 0.152.
 */
package nl.captcha.servlet;

import jakarta.servlet.http.HttpServletResponse;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public final class CaptchaServletUtil {
    protected static final Log LOG = ExoLogger.getLogger(CaptchaServletUtil.class);

    private CaptchaServletUtil() {
    }

    public static void writeImage(HttpServletResponse response, BufferedImage bi) {
        response.setHeader("Cache-Control", "private,no-cache,no-store");
        response.setContentType("image/png");
        try {
            CaptchaServletUtil.writeImage((OutputStream)response.getOutputStream(), bi);
        }
        catch (IOException e) {
            LOG.error((Object)"Error writing generated captcha image in HTTP response", (Throwable)e);
        }
    }

    public static void writeImage(OutputStream os, BufferedImage bi) {
        try {
            ImageIO.write((RenderedImage)bi, "png", os);
            os.close();
        }
        catch (IOException e) {
            LOG.error((Object)"Error writing generated captcha image", (Throwable)e);
        }
    }
}

