/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.security;

import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.web.security.SimpleGeneratorCookieTokenService;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.security-configuration-local.xml")})
public class TestSimpleGeneratorService
extends AbstractKernelTest {
    private SimpleGeneratorCookieTokenService service;
    String type = "testtype";

    protected void setUp() throws Exception {
        PortalContainer container = this.getContainer();
        this.service = (SimpleGeneratorCookieTokenService)((Object)container.getComponentInstanceOfType(SimpleGeneratorCookieTokenService.class));
        Thread.sleep(1000L);
        this.begin();
    }

    protected void tearDown() {
        this.end();
    }

    public void testDuplicatedTokenGeneration() throws Exception {
        this.service.resetCounter();
        String token1 = this.service.createToken("root1");
        TestSimpleGeneratorService.assertEquals((String)"rememberme0.random0", (String)token1);
        TestSimpleGeneratorService.assertEquals((int)this.service.getCounter(), (int)1);
        String token2 = this.service.createToken("root2");
        TestSimpleGeneratorService.assertEquals((String)"rememberme1.random1", (String)token2);
        TestSimpleGeneratorService.assertEquals((int)this.service.getCounter(), (int)2);
        String token3 = this.service.createToken("-root3");
        TestSimpleGeneratorService.assertEquals((String)"rememberme2.random2", (String)token3);
        TestSimpleGeneratorService.assertEquals((int)this.service.getCounter(), (int)4);
        TestSimpleGeneratorService.assertEquals((String)"root1", (String)this.service.getToken(token1).getUsername());
        TestSimpleGeneratorService.assertEquals((String)"root2", (String)this.service.getToken(token2).getUsername());
        TestSimpleGeneratorService.assertEquals((String)"-root3", (String)this.service.getToken(token3).getUsername());
        this.service.deleteToken(token1);
        this.service.deleteToken(token2);
        this.service.deleteToken(token3);
    }

    public void testDuplicatedTokenWithTypeGeneration() throws Exception {
        this.service.resetCounter();
        String token1 = this.service.createToken("root1", this.type);
        TestSimpleGeneratorService.assertEquals((String)"rememberme0.random0", (String)token1);
        TestSimpleGeneratorService.assertEquals((int)this.service.getCounter(), (int)1);
        String token2 = this.service.createToken("root2", this.type);
        TestSimpleGeneratorService.assertEquals((String)"rememberme1.random1", (String)token2);
        TestSimpleGeneratorService.assertEquals((int)this.service.getCounter(), (int)2);
        String token3 = this.service.createToken("-root3", this.type);
        TestSimpleGeneratorService.assertEquals((String)"rememberme2.random2", (String)token3);
        TestSimpleGeneratorService.assertEquals((int)this.service.getCounter(), (int)4);
        TestSimpleGeneratorService.assertEquals((String)"root1", (String)this.service.getToken(token1, this.type).getUsername());
        TestSimpleGeneratorService.assertEquals((String)"root2", (String)this.service.getToken(token2, this.type).getUsername());
        TestSimpleGeneratorService.assertEquals((String)"-root3", (String)this.service.getToken(token3, this.type).getUsername());
        this.service.deleteToken(token1, this.type);
        this.service.deleteToken(token2, this.type);
        this.service.deleteToken(token3, this.type);
    }

    public void testTokenValidationWithDifferentTypes() throws Exception {
        this.service.resetCounter();
        String token1 = this.service.createToken("root1", this.type);
        TestSimpleGeneratorService.assertEquals((String)"rememberme0.random0", (String)token1);
        TestSimpleGeneratorService.assertEquals((int)this.service.getCounter(), (int)1);
        TestSimpleGeneratorService.assertNull((Object)this.service.getToken(token1, "otherType"));
        this.service.deleteToken(token1, this.type);
    }
}

