/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.spring.web.security;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.web.AbstractFilter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.StateKey;
import org.exoplatform.services.security.web.HttpSessionStateKey;

public class PortalIdentityFilter
extends AbstractFilter {
    private static final Log LOG = ExoLogger.getLogger(PortalIdentityFilter.class);
    private static ConversationRegistry conversationRegistry;
    private static IdentityRegistry identityRegistry;
    private static Authenticator authenticator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        ExoContainer container = this.getContainer();
        ExoContainerContext.setCurrentContainer((ExoContainer)container);
        try {
            ConversationState.setCurrent((ConversationState)this.getCurrentState(container, httpRequest));
            chain.doFilter(request, response);
        }
        finally {
            ConversationState.setCurrent(null);
            ExoContainerContext.setCurrentContainer(null);
        }
    }

    private ConversationState getCurrentState(ExoContainer container, HttpServletRequest httpRequest) {
        Identity identity;
        String userId = httpRequest.getRemoteUser();
        if (StringUtils.isBlank((CharSequence)userId)) {
            return new ConversationState(new Identity(IdentityConstants.ANONIM));
        }
        ConversationState state = null;
        HttpSession httpSession = httpRequest.getSession(false);
        if (httpSession != null) {
            HttpSessionStateKey stateKey = new HttpSessionStateKey(httpSession);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Looking for Conversation State " + httpSession.getId()));
            }
            if ((state = PortalIdentityFilter.getConversationRegistry(container).getState((StateKey)stateKey)) != null && !userId.equals(state.getIdentity().getUserId())) {
                state = null;
                conversationRegistry.unregister((StateKey)stateKey, false);
                LOG.warn("The current conversation state with the session ID {} does not belong to the user {}. Identity registries has been cleared.", new Object[]{httpSession.getId(), userId});
            }
        }
        if (state == null && (identity = this.getIdentity(container, userId)) != null) {
            state = new ConversationState(identity);
            PortalIdentityFilter.getConversationRegistry(container).register((StateKey)new HttpSessionStateKey(httpRequest.getSession()), state);
        }
        return state;
    }

    private Identity getIdentity(ExoContainer container, String userId) {
        Identity identity = PortalIdentityFilter.getIdentityRegistry(container).getIdentity(userId);
        if (identity == null) {
            try {
                identity = PortalIdentityFilter.getAuthenticator(container).createIdentity(userId);
                identityRegistry.register(identity);
            }
            catch (Exception e) {
                LOG.warn("Unable restore identity of user {}", new Object[]{userId, e});
            }
        }
        return identity;
    }

    private static IdentityRegistry getIdentityRegistry(ExoContainer container) {
        if (identityRegistry == null) {
            identityRegistry = (IdentityRegistry)container.getComponentInstanceOfType(IdentityRegistry.class);
        }
        return identityRegistry;
    }

    private static ConversationRegistry getConversationRegistry(ExoContainer container) {
        if (conversationRegistry == null) {
            conversationRegistry = (ConversationRegistry)container.getComponentInstanceOfType(ConversationRegistry.class);
        }
        return conversationRegistry;
    }

    private static Authenticator getAuthenticator(ExoContainer container) {
        if (authenticator == null) {
            authenticator = (Authenticator)container.getComponentInstanceOfType(Authenticator.class);
        }
        return authenticator;
    }
}

