/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.web.security.service;

import io.meeds.web.security.service.OtpService;
import io.meeds.web.security.storage.ApiKeyStorage;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import lombok.Generated;
import org.exoplatform.web.security.codec.CodecInitializer;
import org.exoplatform.web.security.security.SecureRandomService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ApiKeyService {
    private static final String UPPERCASE_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String LOWERCASE_CHARS = "abcdefghijklmnopqrstuvwxyz";
    private static final String DIGIT_CHARS = "0123456789";
    private static final String SPECIAL_CHARS = "!@#$%&*?";
    @Autowired
    private ApiKeyStorage apiKeyStorage;
    @Autowired
    private OtpService otpService;
    @Autowired
    private CodecInitializer encrypter;
    @Autowired
    private SecureRandomService secureRandomService;
    @Value(value="${meeds.apiKey.length:20}")
    private long apiKeyLength;
    private SecureRandom secureRandom;

    public String getPassword(String userName, String otpMethod, String otpCode, boolean renew) throws IllegalAccessException {
        String password;
        this.otpService.validateOtp(userName, otpMethod, otpCode);
        String string = password = renew ? null : this.getPassword(userName);
        if (password == null) {
            password = this.generatePassword();
            String encryptedPassword = this.encrypter.getCodec().encode(password);
            this.apiKeyStorage.saveKey(userName, encryptedPassword);
        }
        return password;
    }

    public String getPassword(String userName) {
        String encryptedPassword = this.apiKeyStorage.getKey(userName);
        return encryptedPassword == null ? null : this.encrypter.getCodec().decode(encryptedPassword);
    }

    private String generatePassword() {
        ArrayList<Character> charPool = new ArrayList<Character>();
        String allChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%&*?";
        SecureRandom random = this.getSecureRandom();
        int i = 0;
        while ((long)i < this.apiKeyLength - 4L) {
            charPool.add(Character.valueOf(this.getRandomChar(allChars, random)));
            ++i;
        }
        charPool.add(Character.valueOf(this.getRandomChar(UPPERCASE_CHARS, random)));
        charPool.add(Character.valueOf(this.getRandomChar(LOWERCASE_CHARS, random)));
        charPool.add(Character.valueOf(this.getRandomChar(DIGIT_CHARS, random)));
        charPool.add(Character.valueOf(this.getRandomChar(SPECIAL_CHARS, random)));
        Collections.shuffle(charPool, random);
        StringBuilder finalPassword = new StringBuilder();
        charPool.forEach(finalPassword::append);
        return finalPassword.toString();
    }

    private char getRandomChar(String charSet, SecureRandom random) {
        int index = random.nextInt(charSet.length());
        return charSet.charAt(index);
    }

    private SecureRandom getSecureRandom() {
        if (this.secureRandom == null) {
            this.secureRandom = this.secureRandomService.getSecureRandom();
        }
        return this.secureRandom;
    }

    @Generated
    public long getApiKeyLength() {
        return this.apiKeyLength;
    }

    @Generated
    public void setApiKeyLength(long apiKeyLength) {
        this.apiKeyLength = apiKeyLength;
    }
}

