/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.login;

import jakarta.servlet.http.HttpServletRequest;
import javax.security.auth.login.LoginException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.UsernameCredential;
import org.exoplatform.services.security.j2ee.TomcatLoginModule;
import org.exoplatform.web.login.LoginUtils;
import org.exoplatform.web.security.security.CookieTokenService;
import org.gatein.sso.agent.tomcat.ServletAccess;

public class RememberMeLoginModule
extends TomcatLoginModule {
    private static final Log log = ExoLogger.getLogger(RememberMeLoginModule.class);

    public boolean login() throws LoginException {
        try {
            HttpServletRequest servletRequest = ServletAccess.getRequest();
            if (servletRequest == null) {
                LOG.warn((Object)"HttpServletRequest is null. RemembermeLoginModule will be ignored.");
                return false;
            }
            String token = LoginUtils.getRememberMeTokenCookie(servletRequest);
            if (token != null) {
                CookieTokenService tokenservice = (CookieTokenService)this.getContainer().getComponentInstanceOfType(CookieTokenService.class);
                String username = tokenservice.validateToken(token, false);
                if (username != null) {
                    Authenticator authenticator = (Authenticator)this.getContainer().getComponentInstanceOfType(Authenticator.class);
                    if (authenticator == null) {
                        throw new LoginException("No Authenticator component found, check your configuration");
                    }
                    this.identity = authenticator.createIdentity(username);
                    this.sharedState.put("javax.security.auth.login.name", username);
                    this.sharedState.put("exo.security.identity", this.identity);
                    this.subject.getPublicCredentials().add(new UsernameCredential(username));
                } else {
                    log.debug((Object)"Rememberme cookie is not valid. RemembermeLoginModule will be ignored.");
                }
            } else {
                log.debug((Object)"No username has been committed. RemembermeLoginModule will be ignored.");
            }
            return true;
        }
        catch (Exception e) {
            throw new LoginException(e.getMessage());
        }
    }

    public boolean commit() throws LoginException {
        if (this.identity != null) {
            super.commit();
        }
        return true;
    }
}

