/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.login.recovery;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exoplatform.commons.utils.I18N;
import org.exoplatform.commons.utils.MailUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.branding.BrandingService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.mail.MailService;
import org.exoplatform.services.mail.Message;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.resources.LocaleContextInfo;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.login.recovery.ChangePasswordConnector;
import org.exoplatform.web.login.recovery.PasswordRecoveryService;
import org.exoplatform.web.security.PortalToken;
import org.exoplatform.web.security.security.CookieTokenService;
import org.exoplatform.web.security.security.RemindPasswordTokenService;

public class PasswordRecoveryServiceImpl
implements PasswordRecoveryService {
    private static final String USER_FIRST_NAME_PARAM = "${FIRST_NAME}";
    private static final String LOGIN_LINK_PARAM = "${LOGIN_LINK}";
    private static final String USERNAME_PARAM = "${USERNAME}";
    private static final String DISPLAY_NAME_PARAM = "${DISPLAY_NAME}";
    private static final String EXTERNAL_REGISTRATION_LINK_PARAM = "${EXTERNAL_REGISTRATION_LINK}";
    private static final String EXTERNAL_REGISTRATION_NAME = "external-registration";
    private static final String SPACE_DISPLAY_NAME_PARAM = "${SPACE_DISPLAY_NAME}";
    private static final String SENDER_DISPLAY_NAME_PARAM = "${SENDER_DISPLAY_NAME}";
    private static final String RESET_PASSWORD_LINK_PARAM = "${RESET_PASSWORD_LINK}";
    private static final String USER_DISPLAY_NAME_PARAM = "${USER_DISPLAY_NAME}";
    private static final String COMPANY_NAME_PARAM = "${COMPANY_NAME}";
    public static final String AUTHENTICATION_ATTEMPTS = "authenticationAttempts";
    public static final QualifiedName TOKEN = QualifiedName.create((String)"gtn", (String)"token");
    public static final QualifiedName LANG = QualifiedName.create((String)"gtn", (String)"lang");
    public static final String NAME = "forgot-password";
    protected static Log log = ExoLogger.getLogger(PasswordRecoveryServiceImpl.class);
    private final OrganizationService orgService;
    private final MailService mailService;
    private final ResourceBundleService bundleService;
    private final RemindPasswordTokenService remindPasswordTokenService;
    private final CookieTokenService cookieTokenService;
    private final BrandingService brandingService;
    private final WebAppController webController;
    public static final String CONFIGURED_DOMAIN_URL_KEY = "gatein.email.domain.url";
    private String changePasswordConnectorName;
    private Map<String, ChangePasswordConnector> changePasswordConnectorMap;
    private static final Pattern PATTERN = Pattern.compile("&\\{([a-zA-Z0-9\\.]+)\\}");

    public PasswordRecoveryServiceImpl(InitParams initParams, OrganizationService orgService, MailService mailService, ResourceBundleService bundleService, RemindPasswordTokenService remindPasswordTokenService, CookieTokenService cookieTokenService, WebAppController controller, BrandingService brandingService) {
        this.orgService = orgService;
        this.mailService = mailService;
        this.bundleService = bundleService;
        this.remindPasswordTokenService = remindPasswordTokenService;
        this.cookieTokenService = cookieTokenService;
        this.webController = controller;
        this.brandingService = brandingService;
        this.changePasswordConnectorMap = new HashMap<String, ChangePasswordConnector>();
        this.changePasswordConnectorName = initParams.getValueParam("changePasswordConnector").getValue();
    }

    public void addConnector(ChangePasswordConnector connector) {
        if (!this.changePasswordConnectorMap.containsKey(connector.getName())) {
            this.changePasswordConnectorMap.put(connector.getName(), connector);
        }
    }

    public String verifyToken(String tokenId, String type) {
        PortalToken token = this.remindPasswordTokenService.getToken(tokenId, type);
        if (token == null || token.isExpired()) {
            return null;
        }
        return token.getUsername();
    }

    public void deleteToken(String tokenId, String type) {
        this.remindPasswordTokenService.deleteToken(tokenId, type);
    }

    public String verifyToken(String tokenId) {
        return this.verifyToken(tokenId, "");
    }

    public boolean allowChangePassword(String username) throws Exception {
        User user = this.orgService.getUserHandler().findUserByName(username);
        return user != null && (user.isInternalStore() || this.changePasswordConnectorMap.get(this.changePasswordConnectorName).isAllowChangeExternalPassword());
    }

    public boolean changePass(String tokenId, String tokenType, String username, String password) {
        try {
            UserProfile profile;
            this.changePasswordConnectorMap.get(this.changePasswordConnectorName).changePassword(username, password);
            try {
                this.remindPasswordTokenService.deleteToken(tokenId, tokenType);
                this.remindPasswordTokenService.deleteTokensByUsernameAndType(username, tokenType);
                this.cookieTokenService.deleteTokensByUsernameAndType(username, "");
            }
            catch (Exception ex) {
                log.warn((Object)("Can not delete token: " + tokenId), (Throwable)ex);
            }
            User user = this.orgService.getUserHandler().findUserByName(username);
            if (user != null && (profile = this.orgService.getUserProfileHandler().findUserProfileByName(username)) != null && profile.getAttribute(AUTHENTICATION_ATTEMPTS) != null && !profile.getAttribute(AUTHENTICATION_ATTEMPTS).equals("0")) {
                profile.setAttribute(AUTHENTICATION_ATTEMPTS, String.valueOf(0));
                this.orgService.getUserProfileHandler().saveUserProfile(profile, true);
            }
            return true;
        }
        catch (Exception ex) {
            log.error((Object)("Can not change pass for user: " + username), (Throwable)ex);
            return false;
        }
    }

    public boolean sendOnboardingEmail(User user, Locale locale, StringBuilder url) {
        if (user == null) {
            throw new IllegalArgumentException("User or Locale must not be null");
        }
        ResourceBundle bundle = this.bundleService.getResourceBundle(this.bundleService.getSharedResourceBundleNames(), locale);
        String tokenId = this.remindPasswordTokenService.createToken(user.getUserName(), "onboard");
        StringBuilder redirectUrl = new StringBuilder();
        redirectUrl.append((CharSequence)url);
        redirectUrl.append("/on-boarding");
        redirectUrl.append("?lang=" + I18N.toTagIdentifier((Locale)locale));
        redirectUrl.append("&token=" + tokenId);
        String emailBody = this.buildOnboardingEmailBody(user, bundle, redirectUrl.toString());
        String emailSubject = bundle.getString("onboarding.email.header") + " " + this.brandingService.getCompanyName();
        String senderName = MailUtils.getSenderName();
        Object from = MailUtils.getSenderEmail();
        if (senderName != null && !senderName.trim().isEmpty()) {
            from = senderName + " <" + (String)from + ">";
        }
        Message message = new Message();
        message.setFrom((String)from);
        message.setTo(user.getEmail());
        message.setSubject(emailSubject);
        message.setBody(emailBody);
        message.setMimeType("text/html");
        try {
            this.mailService.sendMessage(message);
        }
        catch (Exception ex) {
            log.error((Object)"Failure to send onboarding email", (Throwable)ex);
            return false;
        }
        return true;
    }

    private String buildOnboardingEmailBody(User user, ResourceBundle bundle, String link) {
        InputStream input = this.getClass().getClassLoader().getResourceAsStream("conf/onBoarding_email_template.html");
        String content = input == null ? "" : this.resolveLanguage(input, bundle);
        content = content.replace(USER_DISPLAY_NAME_PARAM, user == null || user.getDisplayName() == null ? "" : user.getDisplayName());
        content = content.replace(COMPANY_NAME_PARAM, this.brandingService.getCompanyName());
        content = content.replace(RESET_PASSWORD_LINK_PARAM, link);
        return content;
    }

    public String sendExternalRegisterEmail(String sender, String email, Locale locale, String space, StringBuilder url) throws Exception {
        return this.sendExternalRegisterEmail(sender, email, locale, space, url, true);
    }

    public String sendExternalRegisterEmail(String sender, String email, Locale locale, String space, StringBuilder url, boolean spaceInvitation) throws Exception {
        String emailSubject;
        String emailBody;
        ResourceBundle bundle = this.bundleService.getResourceBundle(this.bundleService.getSharedResourceBundleNames(), locale);
        String token = this.createToken(email);
        StringBuilder redirectUrl = new StringBuilder();
        redirectUrl.append((CharSequence)url);
        redirectUrl.append("/external-registration");
        redirectUrl.append("?lang=" + I18N.toTagIdentifier((Locale)locale));
        redirectUrl.append("&token=" + token);
        if (spaceInvitation) {
            UserHandler uHandler = this.orgService.getUserHandler();
            String senderFullName = uHandler.findUserByName(sender).getDisplayName();
            emailBody = this.buildExternalEmailBody(senderFullName, space, redirectUrl.toString(), bundle);
            emailSubject = bundle.getString("external.email.subject") + " " + (space != null ? space : "") + " " + bundle.getString("external.email.on") + " " + this.brandingService.getCompanyName();
        } else {
            emailBody = this.buildOnboardingEmailBody(null, bundle, redirectUrl.toString());
            emailSubject = bundle.getString("onboarding.email.header") + " " + this.brandingService.getCompanyName();
        }
        String senderName = MailUtils.getSenderName();
        Object from = MailUtils.getSenderEmail();
        if (senderName != null && !senderName.trim().isEmpty()) {
            from = senderName + " <" + (String)from + ">";
        }
        Message message = new Message();
        message.setFrom((String)from);
        message.setTo(email);
        message.setSubject(emailSubject);
        message.setBody(emailBody);
        message.setMimeType("text/html");
        this.mailService.sendMessage(message);
        return token;
    }

    private String createToken(String email) {
        return this.remindPasswordTokenService.createToken(email, EXTERNAL_REGISTRATION_NAME);
    }

    private String buildExternalEmailBody(String sender, String space, String link, ResourceBundle bundle) {
        InputStream input = this.getClass().getClassLoader().getResourceAsStream("conf/external_email_template.html");
        String content = input == null ? "" : this.resolveLanguage(input, bundle);
        content = content.replace(SENDER_DISPLAY_NAME_PARAM, sender);
        content = content.replace(COMPANY_NAME_PARAM, this.brandingService.getCompanyName());
        content = content.replace(SPACE_DISPLAY_NAME_PARAM, space);
        content = content.replace(EXTERNAL_REGISTRATION_LINK_PARAM, link);
        return content;
    }

    public boolean sendAccountVerificationEmail(String data, String username, String firstName, String lastName, String email, Locale locale, StringBuilder url) {
        try {
            ResourceBundle bundle = this.bundleService.getResourceBundle(this.bundleService.getSharedResourceBundleNames(), locale);
            String tokenId = this.remindPasswordTokenService.createToken(data, "email-validation");
            StringBuilder redirectUrl = new StringBuilder();
            redirectUrl.append((CharSequence)url);
            redirectUrl.append("/").append(EXTERNAL_REGISTRATION_NAME);
            redirectUrl.append("?action=validateEmail");
            redirectUrl.append("&token=" + tokenId);
            String emailBody = this.buildExternalVerificationAccountEmailBody(firstName + " " + lastName, username, redirectUrl.toString(), bundle);
            String emailSubject = bundle.getString("external.verification.account.email.subject") + " " + this.brandingService.getCompanyName() + "!";
            String senderName = MailUtils.getSenderName();
            Object from = MailUtils.getSenderEmail();
            if (senderName != null && !senderName.trim().isEmpty()) {
                from = senderName + " <" + (String)from + ">";
            }
            Message message = new Message();
            message.setFrom((String)from);
            message.setTo(email);
            message.setSubject(emailSubject);
            message.setBody(emailBody);
            message.setMimeType("text/html");
            this.mailService.sendMessage(message);
        }
        catch (Exception ex) {
            log.error((Object)"Failure to send external confirmation account email", (Throwable)ex);
            return false;
        }
        return true;
    }

    public boolean sendAccountCreatedConfirmationEmail(String username, Locale locale, StringBuilder url) {
        try {
            User user = this.orgService.getUserHandler().findUserByName(username);
            ResourceBundle bundle = this.bundleService.getResourceBundle(this.bundleService.getSharedResourceBundleNames(), locale);
            StringBuilder redirectUrl = new StringBuilder();
            redirectUrl.append((CharSequence)url);
            redirectUrl.append("/login");
            String emailBody = this.buildExternalConfirmationAccountEmailBody(user.getDisplayName(), user.getUserName(), redirectUrl.toString(), bundle);
            String emailSubject = bundle.getString("external.confirmation.account.email.subject") + " " + this.brandingService.getCompanyName() + "!";
            String senderName = MailUtils.getSenderName();
            Object from = MailUtils.getSenderEmail();
            if (senderName != null && !senderName.trim().isEmpty()) {
                from = senderName + " <" + (String)from + ">";
            }
            Message message = new Message();
            message.setFrom((String)from);
            message.setTo(user.getEmail());
            message.setSubject(emailSubject);
            message.setBody(emailBody);
            message.setMimeType("text/html");
            this.mailService.sendMessage(message);
        }
        catch (Exception ex) {
            log.error((Object)"Failure to send external confirmation account email", (Throwable)ex);
            return false;
        }
        return true;
    }

    private String buildExternalConfirmationAccountEmailBody(String dispalyName, String username, String link, ResourceBundle bundle) {
        InputStream input = this.getClass().getClassLoader().getResourceAsStream("conf/external_confirmation_account_email_template.html");
        String content = input == null ? "" : this.resolveLanguage(input, bundle);
        content = content.replace(DISPLAY_NAME_PARAM, dispalyName);
        content = content.replace(COMPANY_NAME_PARAM, this.brandingService.getCompanyName());
        content = content.replace(USERNAME_PARAM, username);
        content = content.replace(LOGIN_LINK_PARAM, link);
        return content;
    }

    private String buildExternalVerificationAccountEmailBody(String displayName, String username, String link, ResourceBundle bundle) {
        InputStream input = this.getClass().getClassLoader().getResourceAsStream("conf/external_verification_account_email_template.html");
        String content = input == null ? "" : this.resolveLanguage(input, bundle);
        content = content.replace(DISPLAY_NAME_PARAM, displayName);
        content = content.replace(COMPANY_NAME_PARAM, this.brandingService.getCompanyName());
        content = content.replace(USERNAME_PARAM, username);
        content = content.replace(LOGIN_LINK_PARAM, link);
        return content;
    }

    public boolean sendRecoverPasswordEmail(User user, Locale defaultLocale, HttpServletRequest req) {
        if (user == null) {
            throw new IllegalArgumentException("User or Locale must not be null");
        }
        Locale locale = this.getLocaleOfUser(user.getUserName(), defaultLocale);
        PortalContainer container = PortalContainer.getCurrentInstance((ServletContext)req.getServletContext());
        ResourceBundle bundle = this.bundleService.getResourceBundle(this.bundleService.getSharedResourceBundleNames(), locale);
        String tokenId = this.remindPasswordTokenService.createToken(user.getUserName(), NAME);
        StringBuilder url = new StringBuilder();
        url.append(req.getScheme()).append("://").append(req.getServerName());
        if (req.getServerPort() != 80 && req.getServerPort() != 443) {
            url.append(':').append(req.getServerPort());
        }
        url.append(container.getPortalContext().getContextPath());
        url.append(this.getPasswordRecoverURL(tokenId, I18N.toTagIdentifier((Locale)locale)));
        String emailBody = this.buildRecoverEmailBody(user, bundle, url.toString());
        String emailSubject = this.getEmailSubject(user, bundle);
        String senderName = MailUtils.getSenderName();
        Object from = MailUtils.getSenderEmail();
        if (senderName != null && !senderName.trim().isEmpty()) {
            from = senderName + " <" + (String)from + ">";
        }
        Message message = new Message();
        message.setFrom((String)from);
        message.setTo(user.getEmail());
        message.setSubject(emailSubject);
        message.setBody(emailBody);
        message.setMimeType("text/html");
        try {
            this.mailService.sendMessage(message);
        }
        catch (Exception ex) {
            log.error((Object)"Failure to send recover password email", (Throwable)ex);
            return false;
        }
        return true;
    }

    private Locale getLocaleOfUser(String username, Locale defLocale) {
        try {
            UserProfile profile = this.orgService.getUserProfileHandler().findUserProfileByName(username);
            String lang = profile == null ? null : (String)profile.getUserInfoMap().get("user.language");
            return lang != null ? LocaleContextInfo.getLocale((String)lang) : defLocale;
        }
        catch (Exception ex) {
            log.debug((Object)"Can not load user profile language", (Throwable)ex);
            return defLocale;
        }
    }

    private String buildRecoverEmailBody(User user, ResourceBundle bundle, String link) {
        InputStream input = this.getClass().getClassLoader().getResourceAsStream("conf/forgot_password_email_template.html");
        String content = input == null ? "" : this.resolveLanguage(input, bundle);
        content = content.replace(USER_FIRST_NAME_PARAM, user.getFirstName());
        content = content.replace(COMPANY_NAME_PARAM, this.brandingService.getCompanyName());
        content = content.replace(USERNAME_PARAM, user.getUserName());
        content = content.replace(RESET_PASSWORD_LINK_PARAM, link);
        return content;
    }

    private String resolveLanguage(InputStream input, ResourceBundle bundle) {
        StringBuffer content = new StringBuffer();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(input));
            while ((line = reader.readLine()) != null) {
                if (content.length() > 0) {
                    content.append("\n");
                }
                this.resolveLanguage(content, line, bundle);
            }
        }
        catch (IOException ex) {
            log.error((Object)ex);
        }
        return content.toString();
    }

    private void resolveLanguage(StringBuffer sb, String input, ResourceBundle bundle) {
        Matcher matcher = PATTERN.matcher(input);
        while (matcher.find()) {
            String resource;
            String key = matcher.group(1);
            try {
                resource = bundle.getString(key);
            }
            catch (MissingResourceException ex) {
                resource = key;
            }
            matcher.appendReplacement(sb, resource);
        }
        matcher.appendTail(sb);
    }

    protected String getEmailSubject(User user, ResourceBundle bundle) {
        return bundle.getString("gatein.forgotPassword.email.subject");
    }

    public String getOnboardingURL(String tokenId, String lang) {
        String passwordRecoveryPath = "/portal/on-boarding";
        if (tokenId != null) {
            passwordRecoveryPath = "%s%stoken=%s".formatted(passwordRecoveryPath, passwordRecoveryPath.contains("?") ? "&" : "?", tokenId);
        }
        if (lang != null) {
            passwordRecoveryPath = "%s%slang=%s".formatted(passwordRecoveryPath, passwordRecoveryPath.contains("?") ? "&" : "?", lang);
        }
        return passwordRecoveryPath;
    }

    public String getExternalRegistrationURL(String tokenId, String lang) {
        String passwordRecoveryPath = "/portal/external-registration";
        if (tokenId != null) {
            passwordRecoveryPath = "%s%stoken=%s".formatted(passwordRecoveryPath, passwordRecoveryPath.contains("?") ? "&" : "?", tokenId);
        }
        if (lang != null) {
            passwordRecoveryPath = "%s%slang=%s".formatted(passwordRecoveryPath, passwordRecoveryPath.contains("?") ? "&" : "?", lang);
        }
        return passwordRecoveryPath;
    }

    public String getPasswordRecoverURL(String tokenId, String lang) {
        String passwordRecoveryPath = "/forgot-password";
        if (tokenId != null) {
            passwordRecoveryPath = "%s%stoken=%s".formatted(passwordRecoveryPath, passwordRecoveryPath.contains("?") ? "&" : "?", tokenId);
        }
        if (lang != null) {
            passwordRecoveryPath = "%s%slang=%s".formatted(passwordRecoveryPath, passwordRecoveryPath.contains("?") ? "&" : "?", lang);
        }
        return passwordRecoveryPath;
    }

    public ChangePasswordConnector getActiveChangePasswordConnector() {
        return this.changePasswordConnectorMap.get(this.changePasswordConnectorName);
    }
}

