/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.security.errorlogin;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.exoplatform.container.web.AbstractFilter;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.web.security.errorlogin.InvalidLoginAttemptsService;

public class LoginDetectorFilter
extends AbstractFilter {
    private static final String ATTR_LOGIN_DETECTED = "LoginDetectorFilter.loginDetected";

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        ConversationState state = ConversationState.getCurrent();
        if (state != null && state.getAttribute(ATTR_LOGIN_DETECTED) == null) {
            String clientIPAddress = request.getRemoteAddr();
            String sessionID = httpRequest.getSession().getId();
            String username = httpRequest.getRemoteUser();
            state.setAttribute(ATTR_LOGIN_DETECTED, (Object)true);
            InvalidLoginAttemptsService invalidLoginService = (InvalidLoginAttemptsService)this.getContainer().getComponentInstanceOfType(InvalidLoginAttemptsService.class);
            invalidLoginService.successfulLoginAttempt(sessionID, username, clientIPAddress);
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

