/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.security.security;

import org.exoplatform.web.security.security.TokenParseException;

public class CookieToken {
    private static final char DELIMITER = '.';
    private final String id;
    private final String randomString;

    public CookieToken(String token) throws TokenParseException {
        int periodPos = token.lastIndexOf(46);
        if (periodPos < 0) {
            throw new TokenParseException("Delimiter '.' not found in cookie token.");
        }
        if (periodPos == 0) {
            throw new TokenParseException("Delimiter '.' found at position 0 in cookie token.");
        }
        if (periodPos == token.length() - 1) {
            throw new TokenParseException("Delimiter '.' found at position token.length() - 1 in cookie token.");
        }
        this.id = token.substring(0, periodPos);
        this.randomString = token.substring(periodPos + 1);
    }

    public CookieToken(String id, String randomString) {
        if (id == null || id.length() == 0) {
            throw new IllegalArgumentException("user must be non-null and non-empty.");
        }
        if (randomString == null || randomString.length() == 0) {
            throw new IllegalArgumentException("randomString must be non-null and non-empty.");
        }
        if (randomString.indexOf(46) >= 0) {
            throw new IllegalArgumentException("randomString must not contain '.'.");
        }
        this.id = id;
        this.randomString = randomString;
    }

    public String toString() {
        return this.id + "." + this.randomString;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.randomString == null ? 0 : this.randomString.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CookieToken)) {
            return false;
        }
        CookieToken other = (CookieToken)obj;
        if (this.randomString == null ? other.randomString != null : !this.randomString.equals(other.randomString)) {
            return false;
        }
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String getId() {
        return this.id;
    }

    public String getRandomString() {
        return this.randomString;
    }
}

