/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.handler;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URLEncoder;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebRequestHandler;
import org.gatein.common.text.EntityEncoder;

public class UploadHandler
extends WebRequestHandler {
    private static final String RESTRICT_PUBLIC_PARAM = "public-access-restriction";
    private boolean isRestrictToPublic = false;

    public UploadHandler(InitParams params) {
        ValueParam value;
        if (params != null && (value = params.getValueParam(RESTRICT_PUBLIC_PARAM)) != null) {
            this.isRestrictToPublic = Boolean.parseBoolean(value.getValue().trim());
        }
    }

    public String getHandlerName() {
        return "upload";
    }

    public boolean execute(ControllerContext context) throws Exception {
        this.execute(context.getRequest(), context.getResponse());
        return true;
    }

    public void execute(HttpServletRequest req, HttpServletResponse res) throws Exception {
        if (this.isRestrictToPublic && req.getRemoteUser() == null) {
            res.sendError(403);
            return;
        }
        String action = req.getParameter("action");
        String[] uploadIds = req.getParameterValues("uploadId");
        res.setHeader("Cache-Control", "no-cache");
        UploadService service = (UploadService)ExoContainerContext.getService(UploadService.class);
        if (action == null || action.length() < 1) {
            return;
        }
        UploadServiceAction uploadActionService = UploadServiceAction.valueOf(StringUtils.upperCase((String)action));
        if (uploadActionService == UploadServiceAction.PROGRESS) {
            PrintWriter writer = res.getWriter();
            if (uploadIds == null) {
                return;
            }
            StringBuilder value = new StringBuilder();
            value.append("{\n  upload : {");
            for (int i = 0; i < uploadIds.length; ++i) {
                UploadResource upResource = service.getUploadResource(uploadIds[i]);
                if (upResource == null) continue;
                if (upResource.getStatus() == 2) {
                    UploadService.UploadLimit limit = (UploadService.UploadLimit)service.getUploadLimits().get(uploadIds[i]);
                    value.append("\n    \"").append(uploadIds[i]).append("\": {");
                    value.append("\n      \"status\":").append('\"').append("failed").append("\",");
                    value.append("\n      \"size\":").append('\"').append(limit.getLimit()).append("\",");
                    value.append("\n      \"unit\":").append('\"').append(limit.getUnit()).append("\"");
                    value.append("\n    }");
                    continue;
                }
                double percent = 100.0;
                if (upResource.getStatus() == 0) {
                    percent = upResource.getUploadedSize() * 100.0 / upResource.getEstimatedSize();
                }
                value.append("\n    \"").append(uploadIds[i]).append("\": {");
                value.append("\n      \"percent\":").append('\"').append((int)percent).append("\",");
                String fileName = EntityEncoder.FULL.encode(upResource.getFileName());
                value.append("\n      \"fileName\":").append('\"').append(this.encodeName(fileName)).append("\"");
                value.append("\n    }");
                if (i >= uploadIds.length - 1) continue;
                value.append(',');
            }
            value.append("\n  }\n}");
            ((Writer)writer).append(value);
        } else if (uploadActionService == UploadServiceAction.UPLOAD) {
            service.createUploadResource(req);
        } else if (uploadActionService == UploadServiceAction.DELETE) {
            service.removeUploadResource(uploadIds[0]);
        } else if (uploadActionService == UploadServiceAction.ABORT) {
            service.removeUploadResource(uploadIds[0]);
        }
    }

    protected boolean getRequiresLifeCycle() {
        return false;
    }

    public String encodeName(String name) throws Exception {
        String[] arr = name.split(" ");
        Object str = "";
        for (int i = 0; i < arr.length; ++i) {
            str = (String)str + " " + URLEncoder.encode(arr[i], "UTF-8");
        }
        return str;
    }

    public static enum UploadServiceAction {
        PROGRESS,
        UPLOAD,
        DELETE,
        ABORT;

    }
}

