/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.test;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ResourceBundle;
import junit.framework.TestCase;
import org.exoplatform.commons.utils.ExpressionUtil;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.page.PageState;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.web.application.Application;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class PortalRequestContextTest
extends TestCase {
    private static MockedStatic<ExpressionUtil> EXPRESSION_UTIL;

    @BeforeClass
    public static void beforeClass() {
        EXPRESSION_UTIL = Mockito.mockStatic(ExpressionUtil.class);
    }

    @AfterClass
    public static void afterClass() {
        EXPRESSION_UTIL.close();
    }

    @Test
    public void testGetTitle() throws Exception {
        PortalRequestContext prc = (PortalRequestContext)Mockito.mock(PortalRequestContext.class);
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class, (Answer)Mockito.CALLS_REAL_METHODS);
        ExoContainer container = (ExoContainer)Mockito.mock(ExoContainer.class);
        UserNode userNode = (UserNode)Mockito.mock(UserNode.class);
        UserPortalConfigService configService = (UserPortalConfigService)Mockito.mock(UserPortalConfigService.class);
        UIPortal uiPortal = (UIPortal)Mockito.mock(UIPortal.class);
        PageState state = (PageState)Mockito.mock(PageState.class);
        PageContext page = (PageContext)Mockito.mock(PageContext.class);
        Application app = (Application)Mockito.mock(Application.class);
        ResourceBundle bundle = ResourceBundle.getBundle("test");
        Mockito.when((Object)prc.getUiPortal()).thenReturn((Object)uiPortal);
        EXPRESSION_UTIL.when(() -> ExpressionUtil.getExpressionValue((ResourceBundle)bundle, (String)"title")).thenCallRealMethod();
        ((PortalRequestContext)Mockito.doCallRealMethod().when((Object)prc)).setPageTitle(ArgumentMatchers.anyString());
        Mockito.when((Object)prc.getTitle()).thenCallRealMethod();
        Mockito.when((Object)((UserPortalConfigService)container.getComponentInstanceOfType(UserPortalConfigService.class))).thenReturn((Object)configService);
        Mockito.when((Object)configService.getPage((PageKey)ArgumentMatchers.any())).thenReturn((Object)page);
        Mockito.when((Object)page.getState()).thenReturn((Object)state);
        Mockito.when((Object)state.getDisplayName()).thenReturn((Object)"title");
        Mockito.when((Object)userNode.getResolvedLabel()).thenReturn((Object)"test");
        Mockito.when((Object)app.getApplicationServiceContainer()).thenReturn((Object)container);
        Mockito.when((Object)prc.getApplication()).thenReturn((Object)app);
        Mockito.when((Object)prc.getApplicationResourceBundle()).thenReturn((Object)bundle);
        Mockito.when((Object)uiPortal.getSelectedUserNode()).thenReturn((Object)userNode);
        Mockito.when((Object)prc.getRequest()).thenReturn((Object)request);
        request.setAttribute(PortalRequestContext.REQUEST_TITLE, (Object)"title");
        PortalRequestContextTest.assertEquals((String)"test", (String)prc.getTitle());
        prc.setPageTitle("otherTest");
        PortalRequestContextTest.assertEquals((String)"otherTest", (String)prc.getTitle());
    }
}

