/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import org.exoplatform.portal.application.DefaultRequestHandler;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.controller.router.URIWriter;
import org.exoplatform.web.url.navigation.NavigationResource;
import org.exoplatform.web.url.navigation.NodeURL;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class DefaultRequestHandlerTest {
    private static final Log LOG = ExoLogger.getLogger(DefaultRequestHandlerTest.class);

    @Test
    public void testGetDefaultSite() {
        NodeURL url = (NodeURL)Mockito.mock(NodeURL.class);
        Mockito.when((Object)url.toString()).thenCallRealMethod();
        Mockito.when((Object)url.setResource((NavigationResource)Mockito.any(NavigationResource.class))).thenCallRealMethod();
        UserPortalConfigService portalConfigService = (UserPortalConfigService)Mockito.mock(UserPortalConfigService.class);
        ControllerContext context = (ControllerContext)Mockito.mock(ControllerContext.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        try {
            Mockito.when((Object)context.getResponse()).thenReturn((Object)response);
            Mockito.when((Object)context.getRequest()).thenReturn((Object)request);
            Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)"root");
            Mockito.when((Object)portalConfigService.computePortalPath((HttpServletRequest)Mockito.any(HttpServletRequest.class))).thenReturn((Object)"/portal/site2/node");
            Mockito.when((Object)response.encodeRedirectURL(Mockito.anyString())).thenAnswer((Answer)new Answer<String>(this){

                public String answer(InvocationOnMock invocation) {
                    return (String)invocation.getArgument(0, String.class);
                }
            });
            DefaultRequestHandler defaultRequestHandler = new DefaultRequestHandler(portalConfigService);
            defaultRequestHandler.execute(context);
            ((HttpServletResponse)Mockito.verify((Object)response)).sendRedirect("/portal/site2/node");
        }
        catch (Exception e) {
            LOG.error((Object)"Error while executing method", (Throwable)e);
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetUserDefaultUri() {
        UserPortalConfigService portalConfigService = (UserPortalConfigService)Mockito.mock(UserPortalConfigService.class);
        ControllerContext context = (ControllerContext)Mockito.mock(ControllerContext.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        try {
            Mockito.when((Object)context.getResponse()).thenReturn((Object)response);
            Mockito.when((Object)context.getRequest()).thenReturn((Object)request);
            Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)"user");
            Mockito.when((Object)portalConfigService.getUserHomePage((String)Mockito.eq((Object)"user"))).thenReturn((Object)"/portal/home");
            Mockito.when((Object)response.encodeRedirectURL(Mockito.anyString())).thenAnswer((Answer)new Answer<String>(this){

                public String answer(InvocationOnMock invocation) {
                    return (String)invocation.getArgument(0, String.class);
                }
            });
            DefaultRequestHandler defaultRequestHandler = new DefaultRequestHandler(portalConfigService);
            defaultRequestHandler.execute(context);
            ((HttpServletResponse)Mockito.verify((Object)response)).sendRedirect((String)Mockito.eq((Object)"/portal/home"));
        }
        catch (Exception e) {
            LOG.error((Object)"Error while executing method", (Throwable)e);
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetNonDefaultSite() {
        NodeURL url = (NodeURL)Mockito.mock(NodeURL.class);
        Mockito.when((Object)url.toString()).thenCallRealMethod();
        UserPortalConfigService portalConfigService = (UserPortalConfigService)Mockito.mock(UserPortalConfigService.class);
        ControllerContext context = (ControllerContext)Mockito.mock(ControllerContext.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        try {
            Mockito.when((Object)context.getResponse()).thenReturn((Object)response);
            Mockito.when((Object)context.getRequest()).thenReturn((Object)request);
            Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)"root");
            Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)"user");
            Mockito.when((Object)portalConfigService.computePortalPath((HttpServletRequest)Mockito.any(HttpServletRequest.class))).thenReturn((Object)"/portal/site1");
            ((ControllerContext)Mockito.doAnswer(invocation -> {
                Map parameters = (Map)invocation.getArgument(0, Map.class);
                URIWriter uriWriter = (URIWriter)invocation.getArgument(1, URIWriter.class);
                uriWriter.append("/portal/");
                uriWriter.append((String)parameters.get(NodeURL.REQUEST_SITE_NAME));
                return null;
            }).when((Object)context)).renderURL((Map)Mockito.any(), (URIWriter)Mockito.any());
            Mockito.when((Object)response.encodeRedirectURL(Mockito.anyString())).thenAnswer((Answer)new Answer<String>(this){

                public String answer(InvocationOnMock invocation) {
                    return (String)invocation.getArgument(0, String.class);
                }
            });
            DefaultRequestHandler defaultRequestHandler = new DefaultRequestHandler(portalConfigService);
            defaultRequestHandler.execute(context);
            ((HttpServletResponse)Mockito.verify((Object)response)).sendRedirect((String)Mockito.eq((Object)"/portal/site1"));
        }
        catch (Exception e) {
            LOG.error((Object)"Error while executing method", (Throwable)e);
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetLoginPageWhenNoSite() {
        UserPortalConfigService portalConfigService = (UserPortalConfigService)Mockito.mock(UserPortalConfigService.class);
        ControllerContext context = (ControllerContext)Mockito.mock(ControllerContext.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        try {
            Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)"user");
            Mockito.when((Object)portalConfigService.getUserPortalSites()).thenReturn(null);
            Mockito.when((Object)context.getResponse()).thenReturn((Object)response);
            Mockito.when((Object)context.getRequest()).thenReturn((Object)request);
            Mockito.when((Object)response.encodeRedirectURL(Mockito.anyString())).thenAnswer((Answer)new Answer<String>(this){

                public String answer(InvocationOnMock invocation) {
                    return (String)invocation.getArgument(0, String.class);
                }
            });
            DefaultRequestHandler defaultRequestHandler = new DefaultRequestHandler(portalConfigService);
            defaultRequestHandler.execute(context);
            ((HttpServletResponse)Mockito.verify((Object)response)).sendRedirect((String)Mockito.eq((Object)"/portal/login"));
        }
        catch (Exception e) {
            LOG.error((Object)"Error while executing method", (Throwable)e);
            Assert.fail((String)e.getMessage());
        }
    }
}

