/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Locale;
import java.util.ServiceLoader;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.I18N;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.application.PortalApplication;
import org.exoplatform.portal.application.PortalApplicationFactory;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.application.PortalRequestImpl;
import org.exoplatform.portal.config.StaleModelException;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.PortalHttpServletResponseWrapper;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.WebRequestHandler;
import org.exoplatform.web.application.Application;
import org.exoplatform.web.application.ApplicationLifecycle;
import org.exoplatform.web.application.ApplicationRequestPhaseLifecycle;
import org.exoplatform.web.application.Phase;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.web.application.RequestFailure;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.webui.core.UIApplication;

public class PortalRequestHandler
extends WebRequestHandler {
    public static final String HANDLER_NAME = "portal";
    protected static final Log LOG = ExoLogger.getLogger((String)"portal:PortalRequestHandler");
    public static final QualifiedName REQUEST_PATH = QualifiedName.create((String)"gtn", (String)"path");
    public static final QualifiedName REQUEST_SITE_TYPE = QualifiedName.create((String)"gtn", (String)"sitetype");
    public static final QualifiedName REQUEST_SITE_NAME = QualifiedName.create((String)"gtn", (String)"sitename");
    public static final QualifiedName LANG = QualifiedName.create((String)"gtn", (String)"lang");
    protected static final PortalApplicationFactory APPP_ROVIDER = ServiceLoader.load(PortalApplicationFactory.class).findFirst().orElse(null);
    protected static final String PORTAL_PUBLIC_PAGE_NOT_FOUND = "/portal/public/page-not-found";
    protected UserPortalConfigService portalConfigService;
    protected String globalPortal;
    protected String metaPortal;

    public String getHandlerName() {
        return HANDLER_NAME;
    }

    public void onInit(WebAppController controller, ServletConfig sConfig) throws Exception {
        PortalApplication application = APPP_ROVIDER != null ? (PortalApplication)APPP_ROVIDER.createApplication(sConfig) : new PortalApplication(sConfig);
        application.onInit();
        controller.addApplication((Application)application);
        this.portalConfigService = (UserPortalConfigService)ExoContainerContext.getService(UserPortalConfigService.class);
        this.metaPortal = this.portalConfigService.getMetaPortal();
        this.globalPortal = this.portalConfigService.getGlobalPortal();
    }

    public boolean execute(ControllerContext controllerContext) throws Exception {
        HttpServletRequest req = controllerContext.getRequest();
        HttpServletResponse res = controllerContext.getResponse();
        res.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        res.setHeader("Pragma", "no-cache");
        res.setHeader("Expires", "0");
        Locale requestLocale = this.getRequestLocale(controllerContext);
        String requestSiteName = controllerContext.getParameter(REQUEST_SITE_NAME);
        String requestSiteType = controllerContext.getParameter(REQUEST_SITE_TYPE);
        String requestPath = controllerContext.getParameter(REQUEST_PATH);
        if (requestSiteName == null) {
            res.sendRedirect(req.getContextPath());
            return true;
        }
        return this.processRequest(controllerContext, requestSiteType, requestSiteName, requestPath, requestLocale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processRequest(ControllerContext controllerContext, String requestSiteType, String requestSiteName, String requestPath, Locale requestLocale) throws Exception {
        PortalApplication app = (PortalApplication)controllerContext.getController().getApplication("PortalApplication");
        PortalRequestContext context = new PortalRequestContext(app, controllerContext, requestSiteType, requestSiteName, requestPath, requestLocale);
        try {
            PortalConfig persistentPortalConfig = context.getDynamicPortalConfig();
            if (context.getUserPortalConfig() == null) {
                if (persistentPortalConfig == null || StringUtils.equals((CharSequence)persistentPortalConfig.getName(), (CharSequence)this.globalPortal)) {
                    boolean bl = false;
                    return bl;
                }
                if (context.getRemoteUser() == null) {
                    context.requestAuthenticationLogin();
                    boolean bl = true;
                    return bl;
                }
                this.sendToNotFoundPage(context, this.metaPortal);
                boolean bl = true;
                return bl;
            }
            if (persistentPortalConfig != null && StringUtils.equals((CharSequence)persistentPortalConfig.getName(), (CharSequence)this.globalPortal)) {
                boolean bl = false;
                return bl;
            }
            this.processRequest(context, app);
            if (context.getUiPage() == null) {
                if (context.getRemoteUser() == null) {
                    context.requestAuthenticationLogin();
                } else {
                    this.sendToNotFoundPage(context, this.metaPortal);
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            context.onRequestEnd();
        }
    }

    protected boolean getRequiresLifeCycle() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(PortalRequestContext context, PortalApplication app) throws Exception {
        RequestContext.setCurrentInstance((RequestContext)context);
        this.createPortalRequestInstance(context);
        List lifecycles = app.getApplicationLifecycle();
        try {
            HttpServletResponse httpServletResponse = context.getResponse();
            if (httpServletResponse instanceof PortalHttpServletResponseWrapper) {
                PortalHttpServletResponseWrapper responseWrapper = (PortalHttpServletResponseWrapper)httpServletResponse;
                responseWrapper.setWrapMethods(true);
            }
            UIApplication uiApp = app.getStateManager().restoreUIRootComponent(context);
            if (context.getUIApplication() != uiApp) {
                context.setUIApplication(uiApp);
            }
            for (ApplicationLifecycle lifecycle : lifecycles) {
                lifecycle.onStartRequest((Application)app, (RequestContext)context);
            }
            if (uiApp != null) {
                uiApp.processDecode(context);
            }
            if (!context.isResponseComplete() && !context.getProcessRender()) {
                this.startRequestPhaseLifecycle(app, context, lifecycles, Phase.ACTION);
                uiApp.processAction(context);
                this.endRequestPhaseLifecycle(app, context, lifecycles, Phase.ACTION);
            }
            if (!context.isResponseComplete()) {
                this.startRequestPhaseLifecycle(app, context, lifecycles, Phase.RENDER);
                uiApp.processRender(context);
                this.endRequestPhaseLifecycle(app, context, lifecycles, Phase.RENDER);
            }
            app.getStateManager().storeUIRootComponent(context);
        }
        catch (StaleModelException e) {
            for (ApplicationLifecycle lifecycle : lifecycles) {
                lifecycle.onFailRequest((Application)app, (RequestContext)context, RequestFailure.CONCURRENCY_FAILURE);
            }
        }
        catch (Exception e) {
            if (!e.getClass().toString().contains("ClientAbortException")) {
                LOG.error((Object)"Error while handling request", (Throwable)e);
            }
        }
        finally {
            try {
                context.commitResponse();
                try {
                    for (ApplicationLifecycle lifecycle : lifecycles) {
                        lifecycle.onEndRequest((Application)app, (RequestContext)context);
                    }
                }
                catch (Exception exception) {
                    LOG.error((Object)"Error while ending request on all ApplicationLifecycle", (Throwable)exception);
                }
            }
            finally {
                RequestContext.setCurrentInstance(null);
                PortalRequestImpl.clearInstance();
            }
        }
    }

    protected void startRequestPhaseLifecycle(PortalApplication app, PortalRequestContext context, List<ApplicationLifecycle> lifecycles, Phase phase) {
        for (ApplicationLifecycle lifecycle : lifecycles) {
            if (!(lifecycle instanceof ApplicationRequestPhaseLifecycle)) continue;
            ApplicationRequestPhaseLifecycle requestLifecycle = (ApplicationRequestPhaseLifecycle)lifecycle;
            requestLifecycle.onStartRequestPhase((Application)app, (RequestContext)context, phase);
        }
    }

    protected void endRequestPhaseLifecycle(PortalApplication app, PortalRequestContext context, List<ApplicationLifecycle> lifecycles, Phase phase) {
        for (ApplicationLifecycle lifecycle : lifecycles) {
            if (!(lifecycle instanceof ApplicationRequestPhaseLifecycle)) continue;
            ApplicationRequestPhaseLifecycle applicationRequestPhaseLifecycle = (ApplicationRequestPhaseLifecycle)lifecycle;
            applicationRequestPhaseLifecycle.onEndRequestPhase((Application)app, (RequestContext)context, phase);
        }
    }

    protected Locale getRequestLocale(ControllerContext controllerContext) {
        String lang = controllerContext.getParameter(LANG);
        if (StringUtils.isBlank((CharSequence)lang)) {
            return null;
        }
        return I18N.parseTagIdentifier((String)lang);
    }

    private void sendToNotFoundPage(PortalRequestContext context, String metaPortal) throws Exception {
        String metaPageNotFound = "/portal/" + metaPortal + "/page-not-found";
        if (!StringUtils.equals((CharSequence)context.getRequest().getRequestURI(), (CharSequence)metaPageNotFound)) {
            if (StringUtils.equals((CharSequence)context.getRequest().getRequestURI(), (CharSequence)PORTAL_PUBLIC_PAGE_NOT_FOUND)) {
                if (StringUtils.isNotBlank((CharSequence)context.getRemoteUser())) {
                    context.sendRedirect("/");
                } else {
                    context.requestAuthenticationLogin();
                }
            } else {
                context.sendRedirect(metaPageNotFound);
            }
        } else {
            context.sendRedirect(PORTAL_PUBLIC_PAGE_NOT_FOUND);
        }
    }

    private void createPortalRequestInstance(PortalRequestContext context) {
        try {
            PortalRequestImpl.createInstance(context);
        }
        catch (Exception e) {
            LOG.warn((Object)"Error while instanciating deprecated 'PortalRequestImpl'. continue processing request", (Throwable)e);
        }
    }
}

