/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.workspace;

import java.util.concurrent.atomic.AtomicInteger;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.portal.UISharedLayout;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class UISharedLayoutTest {
    private static final MockedStatic<RequestContext> PORTAL_REQUEST_CONTEXT = Mockito.mockStatic(RequestContext.class);
    @Mock
    private PortalRequestContext pcontext;

    @AfterClass
    public static void afterRunBare() {
        PORTAL_REQUEST_CONTEXT.close();
    }

    @Before
    public void setUp() {
        PORTAL_REQUEST_CONTEXT.when(() -> RequestContext.getCurrentInstance()).thenReturn((Object)this.pcontext);
    }

    @Test
    public void testStandaloneRender() throws Exception {
        final AtomicInteger siteBodyRenderCount = new AtomicInteger(0);
        final AtomicInteger overallRenderCount = new AtomicInteger(0);
        UISharedLayout sharedLayout = new UISharedLayout(){

            protected void processSiteBodyRender(WebuiRequestContext context) throws Exception {
                siteBodyRenderCount.incrementAndGet();
            }

            protected void processContainerRender(WebuiRequestContext context) throws Exception {
                overallRenderCount.incrementAndGet();
            }

            public boolean isShowSharedLayout(PortalRequestContext requestContext) {
                return !UISharedLayoutTest.this.pcontext.isHideSharedLayout();
            }
        };
        sharedLayout.processRender((WebuiRequestContext)this.pcontext);
        Assert.assertEquals((long)1L, (long)overallRenderCount.get());
        Assert.assertEquals((long)0L, (long)siteBodyRenderCount.get());
        Mockito.when((Object)this.pcontext.isHideSharedLayout()).thenReturn((Object)true);
        sharedLayout.processRender((WebuiRequestContext)this.pcontext);
        Assert.assertEquals((long)1L, (long)overallRenderCount.get());
        Assert.assertEquals((long)1L, (long)siteBodyRenderCount.get());
    }
}

