/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application;

import jakarta.servlet.ServletConfig;
import java.util.Locale;
import java.util.ResourceBundle;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.resolver.ApplicationResourceResolver;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.resolver.ServletResourceResolver;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.webui.application.WebuiApplication;

public class PortalApplication
extends WebuiApplication {
    protected static Log log = ExoLogger.getLogger((String)"portal:PortalApplication");
    public static final String PORTAL_APPLICATION_ID = "PortalApplication";
    private ServletConfig sconfig_;
    private String[] applicationResourceBundleNames_;

    public PortalApplication(ServletConfig config) {
        this.sconfig_ = config;
        ApplicationResourceResolver resolver = new ApplicationResourceResolver();
        resolver.addResourceResolver((ResourceResolver)new ServletResourceResolver(config.getServletContext(), "war:"));
        resolver.addResourceResolver((ResourceResolver)new ServletResourceResolver(config.getServletContext(), "app:"));
        resolver.addResourceResolver((ResourceResolver)new ServletResourceResolver(config.getServletContext(), "system:"));
        resolver.addResourceResolver((ResourceResolver)new ServletResourceResolver(config.getServletContext(), "resources:"));
        this.setResourceResolver(resolver);
    }

    @Override
    public void onInit() throws Exception {
        super.onInit();
        this.applicationResourceBundleNames_ = this.getConfigurationManager().getApplication().getInitParams().getParam("application.resource.bundle").getValue().split(",");
        for (int i = 0; i < this.applicationResourceBundleNames_.length; ++i) {
            this.applicationResourceBundleNames_[i] = this.applicationResourceBundleNames_[i].trim();
        }
    }

    public ServletConfig getServletConfig() {
        return this.sconfig_;
    }

    public String getApplicationId() {
        return PORTAL_APPLICATION_ID;
    }

    public String getApplicationName() {
        return this.sconfig_.getServletName();
    }

    public String getApplicationGroup() {
        return this.sconfig_.getServletContext().getServletContextName();
    }

    public String getApplicationType() {
        return "eXoPortal";
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        ExoContainer appContainer = this.getApplicationServiceContainer();
        ResourceBundleService service = (ResourceBundleService)appContainer.getComponentInstanceOfType(ResourceBundleService.class);
        ResourceBundle res = service.getResourceBundle(this.applicationResourceBundleNames_, locale);
        return res;
    }

    public ResourceBundle getOwnerResourceBundle(String username, Locale locale) {
        ExoContainer appContainer = this.getApplicationServiceContainer();
        ResourceBundleService service = (ResourceBundleService)appContainer.getComponentInstanceOfType(ResourceBundleService.class);
        ResourceBundle res = service.getResourceBundle("locale.users." + username, locale);
        return res;
    }

    @Override
    public String getApplicationInitParam(String name) {
        String value = this.sconfig_.getInitParameter(name);
        return value;
    }
}

