/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIFormInputBase;

@Serialized
public class UIFormRadioBoxInput
extends UIFormInputBase<String> {
    public static int VERTICAL_ALIGN = 1;
    public static int HORIZONTAL_ALIGN = 2;
    private List<SelectItemOption<String>> options_;
    private int align_;
    private int topRender_ = 0;

    public UIFormRadioBoxInput() {
    }

    public UIFormRadioBoxInput(String name, String value) {
        this(name, value, new ArrayList<SelectItemOption<String>>());
    }

    public UIFormRadioBoxInput(String name, String value, List<SelectItemOption<String>> options) {
        super(name, value, String.class);
        this.value_ = value;
        this.options_ = options;
        this.align_ = HORIZONTAL_ALIGN;
    }

    public final List<SelectItemOption<String>> getOptions() {
        return this.options_;
    }

    public final UIFormRadioBoxInput setOptions(List<SelectItemOption<String>> options) {
        this.options_ = options;
        return this;
    }

    public final UIFormRadioBoxInput setAlign(int val) {
        this.align_ = val;
        return this;
    }

    public final UIFormRadioBoxInput setRenderOneRadioBox() {
        this.topRender_ = 1;
        return this;
    }

    @Override
    public void decode(Object input, WebuiRequestContext context) {
        if (this.isDisabled()) {
            return;
        }
        if (input != null) {
            this.value_ = (String)input;
        }
    }

    @Override
    public void processRender(WebuiRequestContext context) throws Exception {
        int index;
        if (this.options_ == null) {
            return;
        }
        ResourceBundle res = context.getApplicationResourceBundle();
        Writer w = context.getWriter();
        if (this.value_ == null) {
            SelectItemOption<String> si = this.options_.get(0);
            this.value_ = si.getValue();
        }
        for (int i = index = 0; i < this.options_.size(); ++i) {
            SelectItemOption<String> si = this.options_.get(i);
            String checked = "";
            if (si.getValue().equals(this.value_)) {
                checked = " checked='checked'";
            }
            if (this.align_ == VERTICAL_ALIGN) {
                w.write("<div>");
            }
            w.write("<label class=\"uiRadio\"><input class='radio' type='radio'");
            if (this.readonly_) {
                w.write(" readonly ");
            }
            if (this.isDisabled()) {
                w.write(" disabled ");
            }
            w.write(checked);
            w.write(" name='");
            w.write(this.getName());
            w.write("'");
            w.write(" id='");
            w.write(this.getName());
            w.write("'");
            w.write(" value='");
            w.write(si.getValue());
            w.write("'/>");
            w.write(" <span>");
            Object label = this.getId() + ".label." + si.getLabel();
            try {
                label = res.getString((String)label);
            }
            catch (MissingResourceException e) {
                label = si.getLabel();
            }
            w.write((String)label);
            w.write("</span></label>");
            if (this.align_ == VERTICAL_ALIGN) {
                w.write("</div>");
            }
            if (this.topRender_ != 1) continue;
            index = i + 1;
            if (index != this.options_.size()) break;
            index = 0;
            break;
        }
    }

    public String renderWithId(int iteration) throws Exception {
        int index;
        if (this.options_ == null) {
            return "";
        }
        StringWriter w = new StringWriter();
        if (this.value_ == null) {
            SelectItemOption<String> si = this.options_.get(0);
            this.value_ = si.getValue();
        }
        for (int i = index = 0; i < this.options_.size(); ++i) {
            SelectItemOption<String> si = this.options_.get(i);
            String checked = "";
            if (si.getValue().equals(this.value_)) {
                checked = " checked='checked'";
            }
            if (this.align_ == VERTICAL_ALIGN) {
                ((Writer)w).write("<div>");
            }
            ((Writer)w).write("<input class='radio' type='radio'");
            if (this.readonly_) {
                ((Writer)w).write(" readonly ");
            }
            if (this.isDisabled()) {
                ((Writer)w).write(" disabled ");
            }
            ((Writer)w).write(checked);
            ((Writer)w).write(" name='");
            ((Writer)w).write(this.getName());
            ((Writer)w).write("'");
            ((Writer)w).write(" id='");
            ((Writer)w).write(this.getName() + iteration);
            ((Writer)w).write("'");
            ((Writer)w).write(" value='");
            ((Writer)w).write(si.getValue());
            ((Writer)w).write("'/>");
            if (this.align_ == VERTICAL_ALIGN) {
                ((Writer)w).write("</div>");
            }
            if (this.topRender_ != 1) continue;
            index = i + 1;
            if (index != this.options_.size()) break;
            index = 0;
            break;
        }
        return ((Object)w).toString();
    }
}

