/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.workspace;

import java.util.concurrent.atomic.AtomicInteger;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.page.UISiteBody;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class UISiteBodyTest {
    private static final MockedStatic<RequestContext> PORTAL_REQUEST_CONTEXT = Mockito.mockStatic(RequestContext.class);
    @Mock
    private PortalRequestContext pcontext;

    @AfterClass
    public static void afterRunBare() {
        PORTAL_REQUEST_CONTEXT.close();
    }

    @Before
    public void setUp() {
        PORTAL_REQUEST_CONTEXT.when(RequestContext::getCurrentInstance).thenReturn((Object)this.pcontext);
    }

    @Test
    public void testStandaloneRender() throws Exception {
        final AtomicInteger pageBodyRenderCount = new AtomicInteger(0);
        final AtomicInteger overallRenderCount = new AtomicInteger(0);
        UISiteBody uiSiteBody = new UISiteBody(this){

            protected void processPageBodyRender(WebuiRequestContext context) throws Exception {
                pageBodyRenderCount.incrementAndGet();
            }

            protected void processContainerRender(WebuiRequestContext context) throws Exception {
                overallRenderCount.incrementAndGet();
            }
        };
        uiSiteBody.processRender((WebuiRequestContext)this.pcontext);
        Assert.assertEquals((long)1L, (long)overallRenderCount.get());
        Assert.assertEquals((long)0L, (long)pageBodyRenderCount.get());
        Mockito.when((Object)this.pcontext.isShowMaxWindow()).thenReturn((Object)true);
        uiSiteBody.processRender((WebuiRequestContext)this.pcontext);
        Assert.assertEquals((long)1L, (long)overallRenderCount.get());
        Assert.assertEquals((long)1L, (long)pageBodyRenderCount.get());
    }
}

