/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.ext.filter.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.exoplatform.webui.ext.filter.UIExtensionFilterType;
import org.exoplatform.webui.ext.filter.impl.FileFilter;

public class FileFilterTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testAcceptWhenAllMimeTypesAllowed() throws Exception {
        FileFilterDummy filter = new FileFilterDummy(this);
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("mimeType", "application/pdf");
        boolean isAccepted = filter.accept(context);
        FileFilterTest.assertEquals((boolean)isAccepted, (boolean)true);
    }

    public void testAcceptWhenNotContain() {
        FileFilterDummy filter = new FileFilterDummy(this);
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("mimeType", "application/pdf");
        ArrayList<String> mimetypes = new ArrayList<String>();
        mimetypes.add("image/gif");
        mimetypes.add("image/jpeg");
        mimetypes.add("image/png");
        filter.setMimeTypes(mimetypes);
        try {
            boolean isAccepted = filter.accept(context);
            FileFilterTest.assertEquals((boolean)isAccepted, (boolean)false);
        }
        catch (Exception ex) {
            Assert.fail((String)"testAcceptWhenNotContain is FAILED because of an unhandled excaption");
        }
    }

    public void testAcceptWhenContain() {
        FileFilterDummy filter = new FileFilterDummy(this);
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("mimeType", "image/gif");
        ArrayList<String> mimetypes = new ArrayList<String>();
        mimetypes.add("image/gif");
        mimetypes.add("image/jpeg");
        mimetypes.add("image/png");
        filter.setMimeTypes(mimetypes);
        try {
            boolean isAccepted = filter.accept(context);
            FileFilterTest.assertEquals((boolean)isAccepted, (boolean)true);
        }
        catch (Exception ex) {
            Assert.fail((String)"testAcceptWhenContain is FAILED because of an unhandled excaption");
        }
    }

    public void testAcceptWhenMimeTypeNullInContext() throws Exception {
        FileFilterDummy filter = new FileFilterDummy(this);
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("mimeType", null);
        ArrayList<String> mimetypes = new ArrayList<String>();
        mimetypes.add("image/gif");
        mimetypes.add("image/jpeg");
        mimetypes.add("image/png");
        filter.setMimeTypes(mimetypes);
        boolean isAccepted = filter.accept(context);
        FileFilterTest.assertEquals((boolean)isAccepted, (boolean)false);
    }

    public void testGetType() {
        FileFilter filter = new FileFilter();
        UIExtensionFilterType type = filter.getType();
        if (type != UIExtensionFilterType.MANDATORY && type != UIExtensionFilterType.REQUISITE && type != UIExtensionFilterType.REQUIRED && type != UIExtensionFilterType.OPTIONAL) {
            Assert.fail((String)"testGetType is FAILED. The result is not expected");
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public class FileFilterDummy
    extends FileFilter {
        public FileFilterDummy(FileFilterTest this$0) {
        }

        public void setMimeTypes(List<String> mimetypes) {
            this.mimeTypes = mimetypes;
        }
    }
}

