/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.url;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Locale;
import junit.framework.TestCase;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.url.PortalURLContext;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.controller.metadata.DescriptorBuilder;
import org.exoplatform.web.controller.metadata.ParamDescriptor;
import org.exoplatform.web.controller.metadata.RouteDescriptor;
import org.exoplatform.web.controller.router.Router;
import org.exoplatform.web.url.URLContext;
import org.exoplatform.web.url.navigation.NavigationResource;
import org.exoplatform.web.url.navigation.NodeURL;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class PortalURLContextTest
extends TestCase {
    private PortalURLContext urlContext;

    @Before
    public void begin() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getScheme()).thenReturn((Object)"http");
        Mockito.when((Object)request.getServerName()).thenReturn((Object)"localhost");
        Mockito.when((Object)request.getServerPort()).thenReturn((Object)8080);
        Mockito.when((Object)request.getContextPath()).thenReturn((Object)"/portal");
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        WebAppController webAppController = (WebAppController)Mockito.mock(WebAppController.class);
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/public/{gtn:lang}/{gtn:sitename}{gtn:path}").with(new ParamDescriptor[]{DescriptorBuilder.routeParam((String)"gtn:sitetype").withValue("portal")}).with(new ParamDescriptor[]{DescriptorBuilder.routeParam((String)"gtn:handler").withValue("portal")}).with(new ParamDescriptor[]{DescriptorBuilder.pathParam((String)"gtn:lang").matchedBy("([A-Za-z]{2}(-[A-Za-z]{2})?)?").preservePath()}).with(new ParamDescriptor[]{DescriptorBuilder.pathParam((String)"gtn:path").matchedBy(".*").preservePath()})}).build();
        HashMap parameters = new HashMap();
        ControllerContext controllerContext = new ControllerContext(webAppController, router, request, response, parameters);
        SiteKey key = SiteKey.portal((String)"classic");
        this.urlContext = new PortalURLContext(controllerContext, key);
    }

    @Test
    public void testXSS() {
        NodeURL url = new NodeURL((URLContext)this.urlContext);
        url.setAuthorityUse(true);
        url.setSchemeUse(true);
        url.setLocale(Locale.FRENCH);
        url.setResource(new NavigationResource(SiteKey.portal((String)"classic"), "/home/&apos;%29&semi;alert%28&apos;xss-vulnerability&apos;%29;alert%28&apos;"));
        String expected = "http://localhost:8080/portal/public/fr/classic/home/&amp;apos;%2529&amp;semi;alert%2528&amp;apos;xss-vulnerability&amp;apos;%2529;alert%2528&amp;apos;";
        PortalURLContextTest.assertEquals((String)expected, (String)url.toString());
    }
}

