/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.test.validator;

import java.util.List;
import java.util.Locale;
import java.util.Set;
import junit.framework.TestCase;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIFormDateTimeInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.validator.DateTimeValidator;
import org.exoplatform.webui.form.validator.EmailAddressValidator;
import org.exoplatform.webui.form.validator.IdentifierValidator;
import org.exoplatform.webui.form.validator.NameValidator;
import org.exoplatform.webui.form.validator.NumberFormatValidator;
import org.exoplatform.webui.form.validator.NumberRangeValidator;
import org.exoplatform.webui.form.validator.PasswordPolicyValidator;
import org.exoplatform.webui.form.validator.PositiveNumberFormatValidator;
import org.exoplatform.webui.form.validator.ResourceValidator;
import org.exoplatform.webui.form.validator.SpecialCharacterValidator;
import org.exoplatform.webui.form.validator.URLValidator;
import org.exoplatform.webui.form.validator.UserConfigurableValidator;
import org.exoplatform.webui.form.validator.UsernameValidator;
import org.exoplatform.webui.form.validator.Validator;
import org.exoplatform.webui.test.validator.MockRequestContext;

public class TestWebuiValidator
extends TestCase {
    public void testUrlValidator() {
        URLValidator validator = new URLValidator();
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "https://192.168.1.1"));
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "ftp://255.255.255.1"));
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "ftps://255.255.0.1"));
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "ftp://0.0.0.0"));
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "http://127.0.0.1"));
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "https://192.168.4.90"));
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "https://192.168.4.90:8080"));
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "http://127.0.0.1:8080"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "http://127.0.0.01"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "ftp://255.255.255.255"));
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "https://www.exoplatform.com"));
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "ftps://root:gtn@exoplatform.com"));
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "ftps://root@exoplatform.com"));
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "https://www.dev.exoplatform.com"));
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "https://www.dev.exoplatform.com:8888"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "https://www.dev.exoplatform.com:8888?arg=value"));
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "https://www.dev.exoplatform.com:8888/path?arg=value"));
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "https://www.dev.exoplatform.com:8888/path?arg=value#"));
    }

    public void testDateTimeValidator() {
        DateTimeValidator validator = new DateTimeValidator();
        WebuiRequestContext.setCurrentInstance((RequestContext)new MockRequestContext(new Locale("fr")));
        UIFormDateTimeInput uiInput = new UIFormDateTimeInput("currentDate", "currentDate", null);
        uiInput.setValue((Object)"28/09/2011 10:59:59");
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, (UIFormInput)uiInput));
        uiInput.setValue((Object)"09/28/2011 10:59:59");
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, (UIFormInput)uiInput));
        WebuiRequestContext.setCurrentInstance((RequestContext)new MockRequestContext(new Locale("en")));
        uiInput = new UIFormDateTimeInput("currentDate", "currentDate", null);
        uiInput.setValue((Object)"09/28/2011, 10:59:59");
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, (UIFormInput)uiInput));
        uiInput.setValue((Object)"09-28-2011, 10:59:59");
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, (UIFormInput)uiInput));
        uiInput.setValue((Object)"28/09/2011 10:59:59");
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, (UIFormInput)uiInput));
    }

    public void testCustomPasswordValidator() {
        UserConfigurableValidator validator = new UserConfigurableValidator("mycompanypasspolicy");
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "ABC123ABC!@#"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "12312312312312312312"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "123123123"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "A1a"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "ABC123"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "abc123"));
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "ABC123abc"));
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "abc123ABC"));
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "abcABC123"));
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "123abcABC"));
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "123abcABC!@#"));
    }

    public void testPasswordPolicyValidator() {
        PasswordPolicyValidator validator = new PasswordPolicyValidator();
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "ABC123ABC!@#"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "12312312312312312312"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "123123123"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "A1a"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "ABC123"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "abc123"));
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "ABC123abc"));
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "abc123ABC"));
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "abcABC123"));
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "123abcABC"));
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "123abcABC!@#"));
    }

    public void testCheckAvaibleConfigurations() {
        Set configurations = UserConfigurableValidator.getConfigurationNames();
        TestWebuiValidator.assertFalse((boolean)configurations.contains("nonexistingConf"));
        TestWebuiValidator.assertTrue((boolean)configurations.contains("mycompanypasspolicy"));
    }

    public void testUsernameValidator() {
        UsernameValidator validator = new UsernameValidator(Integer.valueOf(3), Integer.valueOf(30));
        this.validateUsernames((Validator)validator);
        validator = new UserConfigurableValidator("username");
        this.validateUsernames((Validator)validator);
    }

    private void validateUsernames(Validator validator) {
        TestWebuiValidator.assertTrue((boolean)this.expected(validator, "root.gtn"));
        TestWebuiValidator.assertTrue((boolean)this.expected(validator, "root_gtn"));
        TestWebuiValidator.assertTrue((boolean)this.expected(validator, "root_gtn.01"));
        TestWebuiValidator.assertFalse((boolean)this.expected(validator, "root_gtn_"));
        TestWebuiValidator.assertFalse((boolean)this.expected(validator, "_root_gtn"));
        TestWebuiValidator.assertFalse((boolean)this.expected(validator, "root__gtn"));
        TestWebuiValidator.assertFalse((boolean)this.expected(validator, "root._gtn"));
        TestWebuiValidator.assertFalse((boolean)this.expected(validator, "root--gtn"));
        TestWebuiValidator.assertFalse((boolean)this.expected(validator, "root*gtn"));
        TestWebuiValidator.assertFalse((boolean)this.expected(validator, "Root"));
        TestWebuiValidator.assertFalse((boolean)this.expected(validator, " root "));
        TestWebuiValidator.assertFalse((boolean)this.expected(validator, " root"));
        TestWebuiValidator.assertFalse((boolean)this.expected(validator, "root "));
    }

    public void validateUsernamesInGroupMembership() {
        UserConfigurableValidator validator = new UserConfigurableValidator("groupmembership");
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "root.gtn"));
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "root_gtn"));
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "root_gtn.01"));
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "a1,foo,bar"));
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "a1 ,\tfoo,\nbar     \r"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "a1 ,\tfoo,\nbar     \ra"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "a1 ,\tfoo,\nbar     \r,a"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "root_gtn_"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "_root_gtn"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "root--gtn"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "root*gtn"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "Root"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "a"));
    }

    public void validateIdentifierByConfigurableValidator() {
        UserConfigurableValidator validator = new UserConfigurableValidator("pagename");
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "caff\u00e9-_"));
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "Caff\u00e9"));
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "_caff\u00e9-_"));
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "caff\u00e901"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "-caff\u00e9"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "01caff\u00e9"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "caff\u00e9+"));
    }

    public void testEmailValidator() {
        EmailAddressValidator validator = new EmailAddressValidator();
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "root"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "@"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "foo@"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "@foo"));
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "root.gtn@exoplatform.com"));
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "root.exo.gtn.portal@explatform.biz.edu.vn"));
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "root_exo_gtn_portal@explatform-edu.biz.vn"));
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "exo-sys@exoplatform.com"));
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "user@4test.com"));
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "1user@test.com"));
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "exo+sys@exoplatform.com"));
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "exo&sys@exoplatform.com"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "exo--sys@exoplatform.com"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "root_exo_gtn_portal@explatform-edu.biz-vn"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "root_exo_gtn_portal@explatform-edu.biz9vn"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "root_exo_gtn_portal@explatform--edu.biz.vn"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "root_exo_gtn_portal@-explatform.biz"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "root_exo_gtn_portal@explatform_biz_edu.vn"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "root_exo_gtn_portal@explatform_biz_edu_vn"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "root_gtn--@portal.org"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "root__gtn@portal.org"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "root_.gtn@portal.org"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "--root.gtn@portal.org"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "root.gtn@.portal.org"));
    }

    public void testNumberValidator() {
        NumberFormatValidator validator = new NumberFormatValidator();
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "1001"));
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "0"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "01"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "-01"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "-0"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "000"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "-01"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "1,5"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "1.5"));
    }

    public void testPositiveNumberValidator() {
        PositiveNumberFormatValidator validator = new PositiveNumberFormatValidator();
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "1"));
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "0"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "-1"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "01"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "-01"));
    }

    public void testNumberRangeValidator() {
        NumberRangeValidator validator = new NumberRangeValidator(-5, 5);
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "-5"));
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "-1"));
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "0"));
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "1"));
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "5"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "-10"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "-6"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "6"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "10"));
    }

    public void testSpecialCharacterValidator() {
        SpecialCharacterValidator validator = new SpecialCharacterValidator();
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "aAzZ  caff\u00e9"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "aAzZ\tcaff\u00e9"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "aAzZ\ncaff\u00e9"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "aAzZ \rcaff\u00e9"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "\tcaff\u00e9"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "\ncaff\u00e9"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "\rcaff\u00e9"));
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "\n"));
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "\t"));
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "\n"));
    }

    public void testResourceValidator() {
        ResourceValidator validator = new ResourceValidator();
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "caff\u00e9_-.--"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "_caff\u00e9"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "0caff\u00e9"));
    }

    public void testNameValidator() {
        NameValidator validator = new NameValidator();
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "caff\u00e9_-.*"));
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "*caff\u00e9"));
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "0caff\u00e9"));
    }

    public void testIdentifierValidator() {
        IdentifierValidator validator = new IdentifierValidator();
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "caff\u00e9-_"));
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "Caff\u00e9"));
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "_caff\u00e9-_"));
        TestWebuiValidator.assertTrue((boolean)this.expected((Validator)validator, "caff\u00e901"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "-caff\u00e9"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "01caff\u00e9"));
        TestWebuiValidator.assertFalse((boolean)this.expected((Validator)validator, "caff\u00e9+"));
    }

    public boolean expected(Validator validator, final String input) {
        MockUIFormImput uiInput = new MockUIFormImput(this){

            @Override
            public Object getValue() throws Exception {
                return input;
            }
        };
        return this.expected(validator, uiInput);
    }

    public boolean expected(Validator validator, UIFormInput uiInput) {
        try {
            validator.validate(uiInput);
            return true;
        }
        catch (MessageException e) {
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class MockUIFormImput
    extends UIComponent
    implements UIFormInput {
        private MockUIFormImput() {
        }

        public String getBindingField() {
            return null;
        }

        public String getLabel() {
            return null;
        }

        public UIFormInput addValidator(Class clazz, Object ... params) throws Exception {
            return null;
        }

        public List getValidators() {
            return null;
        }

        public Object getValue() throws Exception {
            return null;
        }

        public UIFormInput setValue(Object value) throws Exception {
            return null;
        }

        public Class getTypeValue() {
            return null;
        }

        public void reset() {
        }
    }
}

