/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.application;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.portal.config.model.ApplicationState;
import org.exoplatform.portal.config.model.TransientApplicationState;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.pc.ExoPortletState;
import org.exoplatform.portal.pc.ExoPortletStateType;
import org.exoplatform.portal.pom.spi.portlet.Portlet;
import org.exoplatform.portal.pom.spi.portlet.PortletBuilder;
import org.exoplatform.portal.pom.spi.portlet.Preference;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.api.PortletStateType;
import org.gatein.pc.api.StatefulPortletContext;

public abstract class ModelAdapter {
    private static final String LOCAL_STATE_ID = PortletContext.LOCAL_CONSUMER_CLONE.getId();
    private static final ModelAdapter PORTLET = new ModelAdapter(){

        @Override
        public StatefulPortletContext<ExoPortletState> getPortletContext(ExoContainer container, String applicationId, ApplicationState applicationState) throws Exception {
            LayoutService layoutService = (LayoutService)container.getComponentInstanceOfType(LayoutService.class);
            Portlet preferences = layoutService.load(applicationState);
            PortletContext producerOfferedPortletContext = this.getProducerOfferedPortletContext(applicationId);
            ExoPortletState map = new ExoPortletState(producerOfferedPortletContext.getId());
            if (preferences != null) {
                for (Preference pref : preferences) {
                    map.getState().put(pref.getName(), pref.getValues());
                }
            }
            return StatefulPortletContext.create((String)LOCAL_STATE_ID, (PortletStateType)ExoPortletStateType.getInstance(), (Serializable)map);
        }

        @Override
        public ApplicationState update(ExoContainer container, ExoPortletState updateState, ApplicationState applicationState) throws Exception {
            PortletBuilder builder = new PortletBuilder();
            for (Map.Entry entry : updateState.getState().entrySet()) {
                builder.add((String)entry.getKey(), (List)entry.getValue());
            }
            if (applicationState instanceof TransientApplicationState) {
                TransientApplicationState transientState = (TransientApplicationState)applicationState;
                transientState.setContentState(builder.build());
                return transientState;
            }
            LayoutService layoutService = (LayoutService)container.getComponentInstanceOfType(LayoutService.class);
            return layoutService.save(applicationState, builder.build());
        }

        @Override
        public PortletContext getProducerOfferedPortletContext(String applicationState) {
            int indexOfSeparator = applicationState.lastIndexOf("/");
            String appName = applicationState.substring(0, indexOfSeparator);
            String portletName = applicationState.substring(indexOfSeparator + 1);
            return PortletContext.reference((String)"local", (PortletContext)PortletContext.createPortletContext((String)appName, (String)portletName));
        }

        @Override
        public Portlet getState(ExoContainer container, ApplicationState applicationState) throws Exception {
            if (applicationState instanceof TransientApplicationState) {
                TransientApplicationState transientState = (TransientApplicationState)applicationState;
                Portlet pref = transientState.getContentState();
                if (pref == null) {
                    pref = new Portlet();
                }
                return pref;
            }
            LayoutService layoutService = (LayoutService)container.getComponentInstanceOfType(LayoutService.class);
            Portlet pref = layoutService.load(applicationState);
            if (pref == null) {
                pref = new Portlet();
            }
            return pref;
        }

        @Override
        public ExoPortletState getStateFromModifiedContext(PortletContext originalPortletContext, PortletContext modifiedPortletContext) {
            StatefulPortletContext statefulContext;
            if (modifiedPortletContext != null && modifiedPortletContext instanceof StatefulPortletContext && (statefulContext = (StatefulPortletContext)modifiedPortletContext).getState() instanceof ExoPortletState) {
                return (ExoPortletState)statefulContext.getState();
            }
            return null;
        }

        @Override
        public ExoPortletState getstateFromClonedContext(PortletContext originalPortletContext, PortletContext clonedPortletContext) {
            StatefulPortletContext statefulContext;
            if (clonedPortletContext != null && clonedPortletContext instanceof StatefulPortletContext && (statefulContext = (StatefulPortletContext)clonedPortletContext).getState() instanceof ExoPortletState) {
                return (ExoPortletState)statefulContext.getState();
            }
            return null;
        }
    };

    public static ModelAdapter getAdapter() {
        return PORTLET;
    }

    public abstract PortletContext getProducerOfferedPortletContext(String var1);

    public abstract StatefulPortletContext<ExoPortletState> getPortletContext(ExoContainer var1, String var2, ApplicationState var3) throws Exception;

    public abstract ApplicationState update(ExoContainer var1, ExoPortletState var2, ApplicationState var3) throws Exception;

    public abstract Portlet getState(ExoContainer var1, ApplicationState var2) throws Exception;

    public abstract ExoPortletState getStateFromModifiedContext(PortletContext var1, PortletContext var2);

    public abstract ExoPortletState getstateFromClonedContext(PortletContext var1, PortletContext var2);
}

