/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.push.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.exoplatform.push.filter.AuthenticationHeaderFilter;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class AuthenticationHeaderFilterTest {
    @Test
    public void shouldReturnConcatenatedHeaderWithUserAuthenticated() throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        FilterChain filterChain = (FilterChain)Mockito.mock(FilterChain.class);
        Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)"john");
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        for (String cookieName : AuthenticationHeaderFilter.COOKIES_TO_PROPAGATE) {
            cookies.add(new Cookie(cookieName, "value" + cookieName));
        }
        Mockito.when((Object)request.getCookies()).thenReturn((Object)cookies.toArray(new Cookie[0]));
        AuthenticationHeaderFilter filter = new AuthenticationHeaderFilter();
        ArgumentCaptor headerNameCaptor = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor headerValueCaptor = ArgumentCaptor.forClass(String.class);
        filter.doFilter((ServletRequest)request, (ServletResponse)response, filterChain);
        ((HttpServletResponse)Mockito.verify((Object)response)).addHeader((String)headerNameCaptor.capture(), (String)headerValueCaptor.capture());
        String name = (String)headerNameCaptor.getValue();
        String value = (String)headerValueCaptor.getValue();
        Assert.assertNotNull((Object)name);
        Assert.assertEquals((Object)"X-Authorization", (Object)name);
        Assert.assertNotNull((Object)value);
        List<String> authenticationHeaderTokens = Arrays.asList(value.split(";"));
        Assert.assertEquals((long)3L, (long)authenticationHeaderTokens.size());
        Assert.assertTrue((boolean)authenticationHeaderTokens.contains(AuthenticationHeaderFilter.COOKIES_TO_PROPAGATE[0] + "=value" + AuthenticationHeaderFilter.COOKIES_TO_PROPAGATE[0]));
        Assert.assertTrue((boolean)authenticationHeaderTokens.contains(AuthenticationHeaderFilter.COOKIES_TO_PROPAGATE[1] + "=value" + AuthenticationHeaderFilter.COOKIES_TO_PROPAGATE[1]));
        Assert.assertTrue((boolean)authenticationHeaderTokens.contains(AuthenticationHeaderFilter.COOKIES_TO_PROPAGATE[2] + "=value" + AuthenticationHeaderFilter.COOKIES_TO_PROPAGATE[2]));
    }

    @Test
    public void shouldReturnConcatenatedHeaderWithNoUserAuthenticated() throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        FilterChain filterChain = (FilterChain)Mockito.mock(FilterChain.class);
        Mockito.when((Object)request.getRemoteUser()).thenReturn(null);
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        for (String cookieName : AuthenticationHeaderFilter.COOKIES_TO_PROPAGATE) {
            cookies.add(new Cookie(cookieName, "value" + cookieName));
        }
        Mockito.when((Object)request.getCookies()).thenReturn((Object)cookies.toArray(new Cookie[0]));
        AuthenticationHeaderFilter filter = new AuthenticationHeaderFilter();
        filter.doFilter((ServletRequest)request, (ServletResponse)response, filterChain);
        ((HttpServletResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.never())).addHeader((String)Mockito.any(), (String)Mockito.any());
    }

    @Test
    public void shouldReturnConcatenatedHeaderWithUserAuthenticatedAndMissingCookies() throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        FilterChain filterChain = (FilterChain)Mockito.mock(FilterChain.class);
        Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)"john");
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        cookies.add(new Cookie("JSESSIONID", "valueJSESSIONID"));
        cookies.add(new Cookie("JSESSIONIDSSO", "valueJSESSIONIDSSO"));
        cookies.add(new Cookie("UNRELATED_COOKIE", "value"));
        Mockito.when((Object)request.getCookies()).thenReturn((Object)cookies.toArray(new Cookie[0]));
        AuthenticationHeaderFilter filter = new AuthenticationHeaderFilter();
        ArgumentCaptor headerNameCaptor = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor headerValueCaptor = ArgumentCaptor.forClass(String.class);
        filter.doFilter((ServletRequest)request, (ServletResponse)response, filterChain);
        ((HttpServletResponse)Mockito.verify((Object)response)).addHeader((String)headerNameCaptor.capture(), (String)headerValueCaptor.capture());
        String name = (String)headerNameCaptor.getValue();
        String value = (String)headerValueCaptor.getValue();
        Assert.assertNotNull((Object)name);
        Assert.assertEquals((Object)"X-Authorization", (Object)name);
        Assert.assertNotNull((Object)value);
        List<String> authenticationHeaderTokens = Arrays.asList(value.split(";"));
        Assert.assertEquals((long)2L, (long)authenticationHeaderTokens.size());
        Assert.assertTrue((boolean)authenticationHeaderTokens.contains("JSESSIONID=valueJSESSIONID"));
        Assert.assertTrue((boolean)authenticationHeaderTokens.contains("JSESSIONIDSSO=valueJSESSIONIDSSO"));
    }

    @Test
    public void shouldNotThrowsNPEWhenGettingCookieValueWithNullArray() throws IOException, ServletException {
        try {
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            FilterChain filterChain = (FilterChain)Mockito.mock(FilterChain.class);
            Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)"john");
            Mockito.when((Object)request.getCookies()).thenReturn(null);
            AuthenticationHeaderFilter filter = new AuthenticationHeaderFilter();
            filter.doFilter((ServletRequest)request, (ServletResponse)response, filterChain);
        }
        catch (NullPointerException ex) {
            Assert.fail((String)"NullPointereException in getCookieValue");
        }
    }
}

