/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.pwa.plugin;

import io.meeds.pwa.model.PwaNotificationMessage;
import io.meeds.pwa.plugin.PwaNotificationPlugin;
import java.text.MessageFormat;
import java.util.Locale;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.plugin.config.PluginConfig;
import org.exoplatform.commons.api.notification.service.setting.PluginSettingService;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.services.resources.LocaleConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultPwaNotificationPlugin
implements PwaNotificationPlugin {
    @Autowired
    private PluginSettingService pluginSettingService;

    @Override
    public PwaNotificationMessage process(NotificationInfo notification, LocaleConfig localeConfig) {
        PluginKey pluginKey = notification.getKey();
        String pluginId = pluginKey.getId();
        PluginConfig templateConfig = this.pluginSettingService.getPluginConfig(pluginId);
        String bundlePath = templateConfig.getBundlePath();
        String subjectKey = templateConfig.getKeyValue("subject", this.getDefaultKey("Notification.subject.{0}", pluginId));
        String title = TemplateUtils.getResourceBundle((String)subjectKey, (Locale)localeConfig.getLocale(), (String)bundlePath);
        PwaNotificationMessage pwaNotificationMessage = new PwaNotificationMessage();
        pwaNotificationMessage.setTitle(title);
        return pwaNotificationMessage;
    }

    private String getDefaultKey(String key, String providerId) {
        return MessageFormat.format(key, providerId);
    }
}

