/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.pwa.rest;

import io.meeds.pwa.model.PwaNotificationMessage;
import io.meeds.pwa.service.PwaNotificationService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"notifications"})
@Tag(name="notifications", description="Managing PWA Notifications")
public class PwaNotificationRest {
    @Autowired
    private PwaNotificationService pwaNotificationService;

    @GetMapping(value={"{id}"})
    @Secured(value={"users"})
    @Operation(summary="Get Web Notification", description="Get Web Notification", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Web Notification retrieved")})
    public PwaNotificationMessage getNotification(HttpServletRequest request, @Parameter(description="The Web Notification Identifier") @PathVariable(value="id") long notificationId) {
        try {
            return this.pwaNotificationService.getNotification(notificationId, request.getRemoteUser());
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN, e.getMessage());
        }
    }

    @PatchMapping(path={"{id}"}, consumes={"application/x-www-form-urlencoded"})
    @Secured(value={"users"})
    @Operation(summary="Update Web Notification specific property", description="Update Web Notification specific property", method="PATCH")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Web Notification updated")})
    public void updateNotificationProperty(HttpServletRequest request, @Parameter(description="The Web Notification Identifier") @PathVariable(value="id") long notificationId, @Parameter(description="The Web Notification Identifier") @RequestParam(value="action") String action) {
        try {
            this.pwaNotificationService.updateNotification(notificationId, action, request.getRemoteUser());
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN, e.getMessage());
        }
    }
}

