/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.pwa.model;

import lombok.Generated;
import org.exoplatform.portal.branding.model.Branding;

public class PwaManifest {
    private static final String BRANDING_BASE_URL = "/portal/rest/v1/platform/branding/";
    private boolean enabled;
    private String name;
    private String description;
    private String largeIconPath;
    private String smallIconPath;
    private String backgroundColor;
    private String themeColor;
    private String version;
    private String manifestId;
    private String domainName;
    private String fullDomainUrl;
    private String descriptionKey;
    private String content;
    private String template;

    public String getContent(Branding branding) {
        if (this.enabled && this.template != null && this.content == null) {
            this.content = this.template.replace("$manifestId", this.manifestId).replace("$name", this.getName(branding)).replace("$description", this.description).replace("$largeIconPath", this.getLargeIconPath(branding)).replace("$smallIconPath", this.getSmallIconPath(branding)).replace("$defaultLang", branding.getDefaultLanguage()).replace("$dir", branding.getDirection()).replace("$backgroundColor", this.getBackgroundColor(branding)).replace("$domainName", this.domainName).replace("$fullDomainUrl", this.fullDomainUrl).replace("$themeColor", this.getThemeColor(branding));
        }
        return this.content;
    }

    private String getThemeColor(Branding branding) {
        return this.themeColor == null ? (String)branding.getThemeStyle().get("primaryColor") : this.themeColor;
    }

    private String getBackgroundColor(Branding branding) {
        return this.backgroundColor == null ? (String)branding.getThemeStyle().get("primaryColor") : this.backgroundColor;
    }

    private String getSmallIconPath(Branding branding) {
        return this.smallIconPath == null ? "/portal/rest/v1/platform/branding/favicon?v=" + branding.getFavicon().getUpdatedDate() + "&size=16x16" : this.smallIconPath;
    }

    private String getLargeIconPath(Branding branding) {
        return this.largeIconPath == null ? "/portal/rest/v1/platform/branding/logo?v=" + branding.getLogo().getUpdatedDate() + "&size=512x512" : this.largeIconPath;
    }

    private String getName(Branding branding) {
        return this.name == null ? branding.getCompanyName() : this.name;
    }

    @Generated
    public PwaManifest() {
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getLargeIconPath() {
        return this.largeIconPath;
    }

    @Generated
    public String getSmallIconPath() {
        return this.smallIconPath;
    }

    @Generated
    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    @Generated
    public String getThemeColor() {
        return this.themeColor;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getManifestId() {
        return this.manifestId;
    }

    @Generated
    public String getDomainName() {
        return this.domainName;
    }

    @Generated
    public String getFullDomainUrl() {
        return this.fullDomainUrl;
    }

    @Generated
    public String getDescriptionKey() {
        return this.descriptionKey;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public String getTemplate() {
        return this.template;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setLargeIconPath(String largeIconPath) {
        this.largeIconPath = largeIconPath;
    }

    @Generated
    public void setSmallIconPath(String smallIconPath) {
        this.smallIconPath = smallIconPath;
    }

    @Generated
    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    @Generated
    public void setThemeColor(String themeColor) {
        this.themeColor = themeColor;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setManifestId(String manifestId) {
        this.manifestId = manifestId;
    }

    @Generated
    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    @Generated
    public void setFullDomainUrl(String fullDomainUrl) {
        this.fullDomainUrl = fullDomainUrl;
    }

    @Generated
    public void setDescriptionKey(String descriptionKey) {
        this.descriptionKey = descriptionKey;
    }

    @Generated
    public void setContent(String content) {
        this.content = content;
    }

    @Generated
    public void setTemplate(String template) {
        this.template = template;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PwaManifest)) {
            return false;
        }
        PwaManifest other = (PwaManifest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$largeIconPath = this.getLargeIconPath();
        String other$largeIconPath = other.getLargeIconPath();
        if (this$largeIconPath == null ? other$largeIconPath != null : !this$largeIconPath.equals(other$largeIconPath)) {
            return false;
        }
        String this$smallIconPath = this.getSmallIconPath();
        String other$smallIconPath = other.getSmallIconPath();
        if (this$smallIconPath == null ? other$smallIconPath != null : !this$smallIconPath.equals(other$smallIconPath)) {
            return false;
        }
        String this$backgroundColor = this.getBackgroundColor();
        String other$backgroundColor = other.getBackgroundColor();
        if (this$backgroundColor == null ? other$backgroundColor != null : !this$backgroundColor.equals(other$backgroundColor)) {
            return false;
        }
        String this$themeColor = this.getThemeColor();
        String other$themeColor = other.getThemeColor();
        if (this$themeColor == null ? other$themeColor != null : !this$themeColor.equals(other$themeColor)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$manifestId = this.getManifestId();
        String other$manifestId = other.getManifestId();
        if (this$manifestId == null ? other$manifestId != null : !this$manifestId.equals(other$manifestId)) {
            return false;
        }
        String this$domainName = this.getDomainName();
        String other$domainName = other.getDomainName();
        if (this$domainName == null ? other$domainName != null : !this$domainName.equals(other$domainName)) {
            return false;
        }
        String this$fullDomainUrl = this.getFullDomainUrl();
        String other$fullDomainUrl = other.getFullDomainUrl();
        if (this$fullDomainUrl == null ? other$fullDomainUrl != null : !this$fullDomainUrl.equals(other$fullDomainUrl)) {
            return false;
        }
        String this$descriptionKey = this.getDescriptionKey();
        String other$descriptionKey = other.getDescriptionKey();
        if (this$descriptionKey == null ? other$descriptionKey != null : !this$descriptionKey.equals(other$descriptionKey)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$template = this.getTemplate();
        String other$template = other.getTemplate();
        return !(this$template == null ? other$template != null : !this$template.equals(other$template));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PwaManifest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $largeIconPath = this.getLargeIconPath();
        result = result * 59 + ($largeIconPath == null ? 43 : $largeIconPath.hashCode());
        String $smallIconPath = this.getSmallIconPath();
        result = result * 59 + ($smallIconPath == null ? 43 : $smallIconPath.hashCode());
        String $backgroundColor = this.getBackgroundColor();
        result = result * 59 + ($backgroundColor == null ? 43 : $backgroundColor.hashCode());
        String $themeColor = this.getThemeColor();
        result = result * 59 + ($themeColor == null ? 43 : $themeColor.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $manifestId = this.getManifestId();
        result = result * 59 + ($manifestId == null ? 43 : $manifestId.hashCode());
        String $domainName = this.getDomainName();
        result = result * 59 + ($domainName == null ? 43 : $domainName.hashCode());
        String $fullDomainUrl = this.getFullDomainUrl();
        result = result * 59 + ($fullDomainUrl == null ? 43 : $fullDomainUrl.hashCode());
        String $descriptionKey = this.getDescriptionKey();
        result = result * 59 + ($descriptionKey == null ? 43 : $descriptionKey.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $template = this.getTemplate();
        result = result * 59 + ($template == null ? 43 : $template.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PwaManifest(enabled=" + this.isEnabled() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", largeIconPath=" + this.getLargeIconPath() + ", smallIconPath=" + this.getSmallIconPath() + ", backgroundColor=" + this.getBackgroundColor() + ", themeColor=" + this.getThemeColor() + ", version=" + this.getVersion() + ", manifestId=" + this.getManifestId() + ", domainName=" + this.getDomainName() + ", fullDomainUrl=" + this.getFullDomainUrl() + ", descriptionKey=" + this.getDescriptionKey() + ", content=" + this.getContent() + ", template=" + this.getTemplate() + ")";
    }
}

