/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.pwa.service;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.meeds.pwa.model.PwaNotificationAction;
import io.meeds.pwa.model.PwaNotificationMessage;
import io.meeds.pwa.model.UserPushSubscription;
import io.meeds.pwa.plugin.DefaultPwaNotificationPlugin;
import io.meeds.pwa.plugin.PwaNotificationPlugin;
import io.meeds.pwa.service.PwaManifestService;
import io.meeds.pwa.service.PwaSubscriptionService;
import io.meeds.pwa.storage.PwaNotificationStorage;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import nl.martijndwars.webpush.Notification;
import nl.martijndwars.webpush.PushService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.service.WebNotificationService;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.ResourceBundleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PwaNotificationService {
    public static final String PWA_NOTIFICATION_CREATED = "pwa.notification.created";
    public static final String PWA_NOTIFICATION_OPEN_UI_ACTION = "open";
    public static final String PWA_NOTIFICATION_MARK_READ_USER_ACTION = "markRead";
    public static final String PWA_NOTIFICATION_MARK_READ_ACTION_LABEL = "pwa.notification.action.markAsRead";
    public static final String EVENT_NOTIFICATION_SENT = "pwa.notificationSent";
    public static final String EVENT_NOTIFICATION_RESPONSE_ERROR = "pwa.notificationResponseError";
    public static final String EVENT_NOTIFICATION_SENDING_ERROR = "pwa.notificationSendingError";
    public static final String EVENT_OUTDATED_SUBSCRIPTION = "pwa.outdatedSubscription";
    public static final String EVENT_ERROR_PARAM_NAME = "error";
    public static final String EVENT_SUBSCRIPTION_PARAM_NAME = "subscription";
    public static final String EVENT_HTTP_RESPONSE_PARAM_NAME = "httpResponse";
    public static final String EVENT_NOTIFICATION_ID_PARAM_NAME = "notificationId";
    public static final String EVENT_ACTION_PARAM_NAME = "action";
    public static final String EVENT_DURATION_PARAM_NAME = "duration";
    public static final Random RANDOM = new Random();
    private static final Log LOG = ExoLogger.getLogger(PwaNotificationService.class);
    @Autowired
    private PwaManifestService pwaManifestService;
    @Autowired
    private PwaSubscriptionService pwaSubscriptionService;
    @Autowired
    private PwaNotificationStorage pwaNotificationStorage;
    @Autowired
    private WebNotificationService webNotificationService;
    @Autowired
    private ListenerService listenerService;
    @Autowired
    private OrganizationService organizationService;
    @Autowired
    private LocaleConfigService localeConfigService;
    @Autowired
    private ResourceBundleService resourceBundleService;
    @Autowired
    private DefaultPwaNotificationPlugin defaultPwaNotificationPlugin;
    @Autowired
    private PushService pushService;
    @Value(value="${pwa.notifications.enabled:true}")
    private boolean enabled;
    @Value(value="${pwa.notifications.pool.size:5}")
    private int poolSize;
    @Value(value="${pwa.notifications.maxBodyLength:75}")
    private int maxBodyLength;
    @Value(value="${pwa.notifications.requireInteraction:true}")
    private boolean requireInteraction;
    @Value(value="${pwa.notifications.renotify:true}")
    private boolean renotify;
    @Value(value="${pwa.notifications.silent:false}")
    private boolean silent;
    @Autowired
    private List<PwaNotificationPlugin> plugins;
    private ScheduledExecutorService executorService;

    @PostConstruct
    public void init() {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("PWA-Push-Notification-%d").build();
        this.executorService = Executors.newScheduledThreadPool(this.poolSize, threadFactory);
    }

    @PreDestroy
    public void destroy() {
        this.executorService.shutdown();
    }

    public PwaNotificationMessage getNotification(long webNotificationId, String username) throws ObjectNotFoundException, IllegalAccessException {
        NotificationInfo notification = this.webNotificationService.getNotificationInfo(String.valueOf(webNotificationId));
        if (notification == null) {
            throw new ObjectNotFoundException(String.format("Notification with id %s doesn't exists", webNotificationId));
        }
        if (!StringUtils.equals((CharSequence)notification.getTo(), (CharSequence)username)) {
            throw new IllegalAccessException(String.format("Notification with id %s access denied", webNotificationId));
        }
        String pluginId = notification.getKey().getId();
        PwaNotificationPlugin notificationPlugin = this.plugins.stream().filter(p -> StringUtils.equals((CharSequence)p.getId(), (CharSequence)pluginId)).findFirst().orElse(this.defaultPwaNotificationPlugin);
        LocaleConfig localeConfig = this.getLocaleConfig(username);
        PwaNotificationMessage notificationMessage = notificationPlugin.process(notification, localeConfig);
        this.setDefaultNotificationMessageProperties(notificationMessage, notification, localeConfig);
        return notificationMessage;
    }

    public void updateNotification(long webNotificationId, String action, String username) throws ObjectNotFoundException, IllegalAccessException {
        NotificationInfo notification = this.webNotificationService.getNotificationInfo(String.valueOf(webNotificationId));
        if (notification == null) {
            throw new ObjectNotFoundException(String.format("Notification with id %s doesn't exists", webNotificationId));
        }
        if (!StringUtils.equals((CharSequence)notification.getTo(), (CharSequence)username)) {
            throw new IllegalAccessException(String.format("Notification with id %s access denied", webNotificationId));
        }
        if (StringUtils.equals((CharSequence)action, (CharSequence)PWA_NOTIFICATION_MARK_READ_USER_ACTION)) {
            this.webNotificationService.markRead(String.valueOf(webNotificationId));
        } else {
            String pluginId = notification.getKey().getId();
            PwaNotificationPlugin notificationPlugin = this.plugins.stream().filter(p -> StringUtils.equals((CharSequence)p.getId(), (CharSequence)pluginId)).findFirst().orElse(this.defaultPwaNotificationPlugin);
            notificationPlugin.handleAction(notification, action, username);
        }
    }

    public ScheduledFuture<?> create(long webNotificationId) {
        if (this.pwaManifestService.isPwaEnabled()) {
            return this.executorService.schedule(() -> this.sendCreateNotification(webNotificationId), 1L, TimeUnit.SECONDS);
        }
        return null;
    }

    public String getVapidPublicKeyString() {
        return this.pwaNotificationStorage.getVapidPublicKeyString();
    }

    private int sendCreateNotification(Long webNotificationId) {
        NotificationInfo notification = this.webNotificationService.getNotificationInfo(String.valueOf(webNotificationId));
        int sentCount = this.sendNotification(notification, PWA_NOTIFICATION_OPEN_UI_ACTION);
        if (sentCount > 0) {
            this.listenerService.broadcast(PWA_NOTIFICATION_CREATED, (Object)webNotificationId, null);
        }
        return sentCount;
    }

    private int sendNotification(NotificationInfo notification, String action) {
        if (notification == null) {
            LOG.warn("Can't send notification action {} since notification is null", new Object[]{action});
            return 0;
        }
        String notificationId = notification.getId();
        String username = notification.getTo();
        if (username != null) {
            return this.sendNotification(Long.parseLong(notificationId), action, username);
        }
        if (notification.getSendToUserIds() != null) {
            return notification.getSendToUserIds().stream().map(user -> this.sendNotification(Long.parseLong(notificationId), action, username)).reduce(0, Integer::sum);
        }
        return 0;
    }

    private int sendNotification(long notificationId, String action, String username) {
        List<UserPushSubscription> subscriptions = this.pwaSubscriptionService.getSubscriptions(username);
        return subscriptions.stream().map(subscription -> {
            block7: {
                long start = System.currentTimeMillis();
                try {
                    String payload = notificationId + ":" + action;
                    HttpResponse httpResponse = this.sendPushMessage((UserPushSubscription)subscription, payload.getBytes());
                    StatusLine status = httpResponse.getStatusLine();
                    if (status.getStatusCode() == 410) {
                        try {
                            this.pwaSubscriptionService.deleteSubscription(subscription.getId(), username, false);
                            break block7;
                        }
                        finally {
                            this.broadcastEvent(EVENT_OUTDATED_SUBSCRIPTION, notificationId, action, username, (UserPushSubscription)subscription, httpResponse, start, null);
                        }
                    }
                    if (status.getStatusCode() < 200 || status.getStatusCode() > 299) {
                        this.broadcastEvent(EVENT_NOTIFICATION_RESPONSE_ERROR, notificationId, action, username, (UserPushSubscription)subscription, httpResponse, start, null);
                        break block7;
                    }
                    this.broadcastEvent(EVENT_NOTIFICATION_SENT, notificationId, action, username, (UserPushSubscription)subscription, httpResponse, start, null);
                    return 1;
                }
                catch (Exception e) {
                    LOG.warn("Error while sending push notification {} to user {}. Ignore reattempting and continue processing messages queue.", new Object[]{notificationId, username, e});
                    this.broadcastEvent(EVENT_NOTIFICATION_SENDING_ERROR, notificationId, action, username, (UserPushSubscription)subscription, null, start, e.getMessage());
                }
            }
            return 0;
        }).reduce(0, Integer::sum);
    }

    private HttpResponse sendPushMessage(UserPushSubscription sub, byte[] payload) throws Exception {
        Notification notification = new Notification(sub.getEndpoint(), sub.userPublicKey(), sub.authAsBytes(), payload);
        return this.pushService.send(notification);
    }

    private void setDefaultNotificationMessageProperties(PwaNotificationMessage notificationMessage, NotificationInfo notification, LocaleConfig localeConfig) {
        List<PwaNotificationAction> notificationActions = notificationMessage.getActions();
        if (CollectionUtils.isEmpty(notificationMessage.getActions()) || notificationActions.stream().noneMatch(a -> StringUtils.equals((CharSequence)a.getAction(), (CharSequence)PWA_NOTIFICATION_MARK_READ_USER_ACTION))) {
            notificationActions = notificationActions == null ? new ArrayList<PwaNotificationAction>() : new ArrayList<PwaNotificationAction>(notificationActions);
            notificationActions.add(new PwaNotificationAction(this.resourceBundleService.getSharedString(PWA_NOTIFICATION_MARK_READ_ACTION_LABEL, localeConfig.getLocale()), PWA_NOTIFICATION_MARK_READ_USER_ACTION));
            notificationMessage.setActions(notificationActions);
        }
        notificationMessage.setRequireInteraction(this.requireInteraction);
        notificationMessage.setRenotify(this.renotify);
        notificationMessage.setSilent(this.silent);
        notificationMessage.setLang(localeConfig.getLanguage());
        notificationMessage.setDir(localeConfig.getOrientation() == null || localeConfig.getOrientation().isLT() ? "ltr" : "rtl");
        if (StringUtils.isBlank((CharSequence)notificationMessage.getTag())) {
            notificationMessage.setTag(notification.getId());
        }
        if (StringUtils.length((CharSequence)notificationMessage.getBody()) > this.maxBodyLength) {
            notificationMessage.setBody(notificationMessage.getBody().substring(0, this.maxBodyLength) + "...");
        }
        if (StringUtils.isBlank((CharSequence)notificationMessage.getUrl())) {
            notificationMessage.setUrl("/");
        }
    }

    public LocaleConfig getLocaleConfig(String username) {
        try {
            UserProfile userProfile = this.organizationService.getUserProfileHandler().findUserProfileByName(username);
            String language = userProfile == null ? null : userProfile.getAttribute("user.language");
            return language == null ? this.localeConfigService.getDefaultLocaleConfig() : this.localeConfigService.getLocaleConfig(language);
        }
        catch (Exception e) {
            LocaleConfig defaultLocaleConfig = this.localeConfigService.getDefaultLocaleConfig();
            LOG.warn("Error retrieving user {} language, use default language {}", new Object[]{username, defaultLocaleConfig.getLanguage()});
            return defaultLocaleConfig;
        }
    }

    private void broadcastEvent(String eventName, long notificationId, String action, String username, UserPushSubscription subscription, HttpResponse httpResponse, long start, String errorMessage) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(EVENT_SUBSCRIPTION_PARAM_NAME, subscription);
        params.put(EVENT_ERROR_PARAM_NAME, errorMessage);
        params.put(EVENT_ACTION_PARAM_NAME, action);
        params.put(EVENT_DURATION_PARAM_NAME, System.currentTimeMillis() - start);
        params.put(EVENT_NOTIFICATION_ID_PARAM_NAME, notificationId);
        params.put(EVENT_HTTP_RESPONSE_PARAM_NAME, httpResponse);
        this.listenerService.broadcast(eventName, (Object)username, params);
    }
}

