/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.pwa.rest;

import io.meeds.pwa.service.PwaSwService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"service-worker"})
@Tag(name="service-worker", description="Retrieve PWA Service Worker")
public class ServiceWorkerRest {
    @Autowired
    private PwaSwService pwaSwService;

    @GetMapping
    @Operation(summary="Get PWA Service Worker", description="Get PWA Service Worker", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="PWA Service Worker retrieved"), @ApiResponse(responseCode="304", description="PWA Service Worker not modified")})
    public ResponseEntity<String> getServiceWorkerContent(WebRequest request) {
        String content = this.pwaSwService.getContent();
        if (content == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        if (request.checkNotModified(String.valueOf((content = content.replace("@lang@", request.getLocale().toLanguageTag())).hashCode()))) {
            return null;
        }
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().eTag(String.valueOf(content.hashCode()))).header("Service-Worker-Allowed", new String[]{"/"})).contentType(MediaType.valueOf((String)"text/javascript")).body((Object)content);
    }
}

